<?php
/**
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package Musiziya
 * @since Musiziya 1.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
        <?php wp_head(); ?>

    </head>

	<body <?php body_class(); ?>>
		<?php wp_body_open(); ?>
		<a class="skip-link screen-reader-text"
		   href="#content"><?php esc_html_e('Skip to content', 'musiziya'); ?>
		</a>
			<?php if (musiziya_get_option('new_class_trip')) { ?>
	<div id="newclass-trip">
	<?php } ?>
		<header id="masthead" class="site-header clearfix">
			<?php
				if (musiziya_get_option('header_layout') == 'transparent') {
					get_template_part('header/header', 'transparent');
				} else {
					get_template_part('header/header', 'transparent');
				}
			?>
		</header>  <!-- masthead -->
	</div>
	<main id="content" class="site-content">
	<?php if (musiziya_get_option('new_class_top')) { ?>
	<div id="newclass-sec">
		<?php } ?>
		<?php if (!is_page_template('page-fullwidth.php')) { ?>
			<?php get_template_part('loop/sub-header'); ?>
		<?php }?>
	</div>