<?php
/**
 * The template for displaying content video
 *
 * Used for both single and index/archive/search.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;
//single item layout
if(is_singular()) :

$column_classes = flicker_get_columns_classes();

//light or dark version
$version = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'version' ) : 'dark';
$main_section_class = ( $version !== 'dark' ) ? 'ls' : 'ds';
?>

<?php
	$pID = get_the_ID();
    //detecting featured video
	$embed_url = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( $pID, 'post-featured-video', '' ) : '';
    if ( $embed_url ) : ?>
<section class="<?php echo esc_attr( $main_section_class ); ?> section_padding_top_150 video-entry-thumbnail">
	<div class="container">
		<div class="row">
			<div class="<?php echo ( 'col-xs-12 col-md-10 col-md-offset-1' === $column_classes['main_column_class'] ) ? esc_attr( 'col-xs-12 col-md-10 col-md-offset-1' ) : esc_attr( 'col-xs-12' ); ?>">
				<?php flicker_post_thumbnail(); ?>
			</div>
		</div>
	</div>
</section>
<section class="<?php echo esc_attr( $main_section_class ); ?> page_content section_padding_top_50 section_padding_bottom_130 columns_padding_25">
<?php else: ?>
<section class="<?php echo esc_attr( $main_section_class ); ?> page_content section_padding_top_150 section_padding_bottom_130 columns_padding_25">
<?php endif; ?>

	<div class="container">
		<div class="row">
			<div id="content" class="<?php echo esc_attr( $column_classes['main_column_class'] ); ?>">
		<article id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item content-padding big-padding with_background rounded overflow_hidden ' ); ?>>

        <div class="item-content">
            <header class="entry-header">

	            <?php if ( is_sticky() && is_home() && ! is_paged() ) {
		            echo '<div class="featured-post grey"><i class="rt-icon2-clip highlight"></i>' . esc_html__( ' Sticky: ', 'flicker' ) . '</div>';
	            } ?>

                <div class="entry-meta small-text content-justify vertical-center">
		            <?php
		            if ( 'post' == get_post_type() ) {
			            flicker_posted_on( true );
		            } ?>
		            <?php flicker_share_this(); ?>
                </div>

                <hr>

                <div class="entry-meta">
		            <?php
		            printf( '<a href="%1$s">%2$s <span>%3$s</span></a>',
			            esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			            esc_html__( 'By:', 'flicker' ),
			            get_the_author()
		            );
		            ?>
		            <?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>
                        / <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ', ', 'Used between list items, there is a space after the comma.', 'flicker' ) ); ?></span>

		            <?php endif; ?>
		            <?php if ( comments_open() ) : ?>
                        / <a href="<?php comments_link(); ?>">
                            <span class="value"><?php comments_number( "0 comments", "1 comment", "% comments" ); ?></span>
                        </a>
		            <?php else: ?>
                        / <span>
                    <span><?php echo esc_html__( 'Comments closed', 'flicker' ); ?></span>
                </span>
		            <?php endif; ?>
                </div>

            </header><!-- .entry-header -->

	        <?php if ( !empty( get_the_content() ) ) : ?>
            <div class="entry-content">
		        <?php
		        the_content( esc_html__( 'Read More', 'flicker' ) );
		        ?>
            </div><!-- .entry-content -->
	        <?php endif; //has content ?>

	        <?php
	        the_tags( '<div class="tag-links topmargin_30">', ' ', '</div>' );

	        wp_link_pages( array(
		        'before'      => '<div class="page-links highlightlinks topmargin_30"><span class="page-links-title">' . esc_html__( 'Pages:', 'flicker' ) . '</span>',
		        'after'       => '</div>',
		        'link_before' => '<span>',
		        'link_after'  => '</span>',
	        ) );
	        ?>
        </div>

	</article><!-- #post-## -->

	<?php
	flicker_post_nav();
	flicker_related_posts();
    flicker_list_authors();
    ?>
<?php
//eof single page layout
//blog feed layout
else:
	$post_layout = 'post-layout-standard';
	if (function_exists( 'fw_get_db_post_option' )) {
		$post_layout = fw_get_db_post_option( $post->ID, 'post-layout', 'post-layout-standard' );
	}
	//standard feed layout (image at the top or not image at all if option is standard or has no post thumbnail)
	//	if ($post_layout == 'post-layout-standard' || ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ) :
	$small_layout = ( $post_layout == 'post-layout-standard' || !$show_post_thumbnail ) ? false : true;
		if ($small_layout) : //additional markup for small layout post
?>
	<article id="post-<?php the_ID(); ?>" <?php post_class('format-small-image with_background rounded overflow_hidden '); ?>>
		<div class="side-item side-md content-padding big-padding">
			<div class="row">
				<?php flicker_post_thumbnail( $small_layout ); ?>
				<div class="col-md-6">

	<?php else : //standard layout markup ?>

	<article id="post-<?php the_ID(); ?>" <?php post_class('vertical-item content-padding big-padding offset_button with_background rounded'); ?>>
	<?php
		flicker_post_thumbnail();
	endif; //small_format check
	?>
	<div class="item-content">

		<header class="entry-header">

			<?php if ( is_sticky() && is_home() && ! is_paged() ) {
				echo '<div class="featured-post grey"><i class="rt-icon2-clip highlight"></i>' . esc_html__( ' Sticky: ', 'flicker' ) . '</div>';
			} ?>

            <div class="entry-meta small-text content-justify vertical-center">
	            <?php
	            if ( 'post' == get_post_type() ) {
		            flicker_posted_on( true );
	            } ?>
                <?php flicker_share_this(); ?>
            </div>

			<?php
			the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
			?>

            <hr>

            <div class="entry-meta">
	            <?php
	            printf( '<a href="%1$s">%2$s <span>%3$s</span></a>',
		            esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
		            esc_html__( 'By:', 'flicker' ),
		            get_the_author()
	            );
	            ?>
	            <?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>
                     / <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ', ', 'Used between list items, there is a space after the comma.', 'flicker' ) ); ?></span>

	            <?php endif; ?>
	            <?php if ( comments_open() ) : ?>
                     / <a href="<?php comments_link(); ?>">
                        <span class="value"><?php comments_number( "0 comments", "1 comment", "% comments" ); ?></span>
                    </a>
	            <?php else: ?>
                     / <span>
                    <span><?php echo esc_html__( 'Comments closed', 'flicker' ); ?></span>
                </span>
	            <?php endif; ?>
            </div>



		</header><!-- .entry-header -->

        <?php if ( !empty( get_the_content() ) ) : ?>
		<?php if ( is_search() ) : ?>
			<div class="entry-summary">
				<?php the_excerpt(); ?>
			</div><!-- .entry-summary -->
		<?php else : ?>
			<div class="entry-content">
				<?php
				//hidding "more link" in content
				the_content( esc_html__( 'Read More', 'flicker' ) );

				wp_link_pages( array(
					'before'      => '<div class="page-links highlightlinks topmargin_30"><span class="page-links-title">' . esc_html__( 'Pages:', 'flicker' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '<span>',
					'link_after'  => '</span>',
				) );
				?>

            </div><!-- .entry-content -->

        <?php endif; //is_search
        endif; //has content
        ?>

        <span class="button_wrap topmargin_20">
            <a href="<?php the_permalink(); ?>" class="theme_button color1"><?php echo esc_html__( 'Read More', 'flicker' ); ?></a>
        </span>
	</div><!-- eof .item-content -->


		<?php if ($small_layout) : //additional markup for small format post ?>
				</div><!-- eof .col-md-6 -->
			</div><!-- eof .row -->
		</div><!-- eof .side-item -->
		<?php endif; //small_format ?>
	</article><!-- #post-## -->
<?php endif;  //is singular ?>