<?php
/**
 * Template for displaying search forms
 *
 */
?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
    <div class="form-group-wrap">
        <div class="form-group bottommargin_0">
            <input type="search" class="search-field form-control"
                   placeholder="<?php echo esc_attr_x( 'Search Keyword', 'placeholder', 'flicker' ); ?>"
                   value="<?php echo get_search_query(); ?>" name="s"
                   title="<?php echo esc_attr_x( 'Search for:', 'label', 'flicker' ); ?>"/>
        </div>
        <button type="submit" class="search-submit theme_button color2 no_bg_button">
            <span class="screen-reader-text"><?php echo esc_html_x( 'Search', 'submit button', 'flicker' ); ?></span>
        </button>
    </div>
</form>
