<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Filters and Actions
 */

if ( ! function_exists( 'flicker_action_setup' ) ) :
	/**
	 * Theme setup.
	 *
	 * Set up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support post thumbnails.
	 * @internal
	 */
	function flicker_action_setup() {

		/*
		 * Make Theme available for translation.
		 */
		load_theme_textdomain( 'flicker', FLICKER_THEME_PATH . '/languages' );

		add_editor_style( array( 'css/main.css' ) );

		// Add RSS feed links to <head> for posts and comments.
		add_theme_support( 'automatic-feed-links' );

		// Enable support for Post Thumbnails, and declare two sizes.
		add_theme_support( 'post-thumbnails' );

		//Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		set_post_thumbnail_size( 775, 517, true );
		add_image_size( 'flicker-full-width', 1170, 780, true );
		add_image_size( 'flicker-small-width', 500, 800, true );
		add_image_size( 'flicker-square-width', 780, 780, true );

		//content width
		$GLOBALS['content_width'] = apply_filters( 'flicker_filter_content_width', 891 );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption'
		) );

		/*
		 * Enable support for Post Formats.
		 * See http://codex.wordpress.org/Post_Formats
		 */
		add_theme_support( 'post-formats', array(
			'standard',
			'aside',
			'chat',
			'gallery',
			'link',
			'image',
			'quote',
			'status',
			'video',
			'audio',
		) );

		// Declare WooCommerce support
		add_theme_support( 'woocommerce' );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

	} //flicker_action_setup()

endif;
add_action( 'after_setup_theme', 'flicker_action_setup' );


/**
 * Extend the default WordPress body classes.
 *
 * Adds body classes to denote:
 * 1. Single or multiple authors.
 * 2. Presence of header image.
 * 3. Index views.
 * 4. Full-width content layout.
 * 5. Presence of footer widgets.
 * 6. Single views.
 * 7. Featured content layout.
 *
 * @param array $classes A list of existing body class values.
 *
 * @return array The filtered body class list.
 * @internal
 */
if ( !function_exists( 'flicker_filter_body_classes' ) ) :
	function flicker_filter_body_classes( $classes ) {
		if ( is_multi_author() ) {
			$classes[] = 'group-blog';
		}

		if ( get_header_image() ) {
			$classes[] = 'header-image';
		} else {
			$classes[] = 'masthead-fixed';
		}

		if ( is_archive() || is_search() || is_home() ) {
			$classes[] = 'archive-list-view';
		}

		if ( function_exists( 'fw_ext_sidebars_get_current_position' ) ) {
			$current_position = fw_ext_sidebars_get_current_position();
			if ( in_array( $current_position, array( 'full', 'left' ) )
			     || empty( $current_position )
			     || is_page_template( 'page-templates/full-width.php' )
			     || is_attachment()
			) {
				$classes[] = 'full-width';
			}
		} else {
			$classes[] = 'full-width';
		}

		if ( is_active_sidebar( 'sidebar-footer' ) ) {
			$classes[] = 'footer-widgets';
		}

		if ( is_singular() && ! is_front_page() ) {
			$classes[] = 'singular';
		}

		if ( is_front_page() && 'slider' == get_theme_mod( 'featured_content_layout' ) ) {
			$classes[] = 'slider';
		} elseif ( is_front_page() ) {
			$classes[] = 'grid';
		}

		return $classes;
	} //flicker_filter_body_classes()
endif;
add_filter( 'body_class', 'flicker_filter_body_classes' );

//changing default comment form
if ( ! function_exists( 'flicker_filter_flicker_contact_form_fields' ) ) :
	function flicker_filter_flicker_contact_form_fields( $fields ) {
		$commenter     = wp_get_current_commenter();
		$user          = wp_get_current_user();
		$user_identity = $user->exists() ? $user->display_name : '';
		$req           = get_option( 'require_name_email' );
		$aria_req      = ( $req ? " aria-required='true'" : '' );
		$html_req      = ( $req ? " required='required'" : '' );
		$html5         = 'html5';
		$fields        = array(
			'author'        => '<div class="col-sm-6"><p class="comment-form-author">' . '<label for="author">' . esc_html__( 'Name', 'flicker' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
			                   '<input id="author" class="form-control" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . $html_req . ' placeholder="' . esc_html__( 'Your Name', 'flicker' ) . ( $req ? '*' : '' ) .  '"></p></div>',
			'email'         => '<div class="col-sm-6"><p class="comment-form-email"><label for="email">' . esc_html__( 'Email', 'flicker' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
			                   '<input id="email" class="form-control" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30" ' . $aria_req . $html_req . ' placeholder="' . esc_html__( 'Email Address', 'flicker' ) . ( $req ? '*' : '' ) . '"/></p></div>',
			'comment_field' => '<div class="col-sm-12"><p class="comment-form-comment"><label for="comment">' . esc_html_x( 'Comment', 'noun', 'flicker' ) . '</label> <textarea id="comment"  class="form-control" name="comment" cols="45" rows="5"  aria-required="true" required="required"  placeholder="' . esc_html__( 'Comment', 'flicker' ) . '"></textarea></p></div>',
		);

		return $fields;
	} //flicker_filter_flicker_contact_form_fields()

endif;
add_filter( 'comment_form_default_fields', 'flicker_filter_flicker_contact_form_fields' );


//changing gallery thumbnail size for entry-thumbnail display
if ( ! function_exists( 'flicker_filter_fw_shortcode_atts_gallery' ) ) :
	function flicker_filter_fw_shortcode_atts_gallery( $out, $pairs, $atts ) {
		$out['size'] = 'post-thumbnail';
		return $out;
	} //flicker_filter_fw_shortcode_atts_gallery()
endif;

if ( ! function_exists( 'flicker_shortcode_atts_gallery_trigger' ) ) :
	function flicker_shortcode_atts_gallery_trigger( $add_filter = true ) {
		if ( $add_filter ) {
			add_filter( 'shortcode_atts_gallery', 'flicker_filter_fw_shortcode_atts_gallery', 10, 3 );
		} else {
			false;
		}
	} //flicker_shortcode_atts_gallery_trigger()
endif;

//changing events slug
if ( ! function_exists( 'flicker_filter_fw_ext_events_post_slug' ) ) :
	function flicker_filter_fw_ext_events_post_slug( $slug ) {
		return 'event';
	} //flicker_filter_fw_ext_events_post_slug()
endif;
add_filter( 'fw_ext_events_post_slug', 'flicker_filter_fw_ext_events_post_slug' );

if ( ! function_exists( 'flicker_filter_fw_ext_events_taxonomy_slug' ) ) :
	function flicker_filter_fw_ext_events_taxonomy_slug( $slug ) {
		return 'events';
	} //flicker_filter_fw_ext_events_taxonomy_slug()
endif;
add_filter( 'fw_ext_events_taxonomy_slug', 'flicker_filter_fw_ext_events_taxonomy_slug' );

//wrapping in a span categories and archives items count
if ( !function_exists('flicker_filter_add_span_to_arhcive_widget_count') ) :
	function flicker_filter_add_span_to_arhcive_widget_count( $links ) {
		//for categories widget
		$links = str_replace( '</a> (', '</a> <span>/ ', $links );
		//for archive widget
		$links = str_replace( '&nbsp;(', '</a> <span>/ ', $links );
		$links = preg_replace( '/([0-9]+)\)/', '$1</span>', $links );

		return $links;
	} //flicker_filter_add_span_to_arhcive_widget_count()
endif;

//categories
add_filter( 'wp_list_categories', 'flicker_filter_add_span_to_arhcive_widget_count' );
//arhcive
add_filter( 'get_archives_link', 'flicker_filter_add_span_to_arhcive_widget_count' );


if ( !function_exists( 'flicker_filter_monster_widget_text' ) ) :
	function flicker_filter_monster_widget_text( $text ) {
		$text = str_replace( 'name="monster-widget-just-testing"', 'name="monster-widget-just-testing" class="form-control"', $text );

		return $text;
	}
endif;
add_filter( 'monster-widget-get-text', 'flicker_filter_monster_widget_text' );


/**
 * Extend the default WordPress post classes.
 *
 * Adds a post class to denote:
 * Non-password protected page with a post thumbnail.
 *
 * @param array $classes A list of existing post class values.
 *
 * @return array The filtered post class list.
 * @internal
 */
if ( !function_exists( 'flicker_filter_post_classes' ) ) :
	function flicker_filter_post_classes( $classes ) {
		if ( ! post_password_required() && ! is_attachment() && has_post_thumbnail() ) {
			$classes[] = 'has-post-thumbnail';
		}
		return $classes;
	} //flicker_filter_post_classes()
endif;
add_filter( 'post_class', 'flicker_filter_post_classes' );


/**
 * Add bootstrap CSS classes to default password protected form.
 *
 *
 * @return string HTML code of password form
 * @internal
 */
if ( !function_exists( 'flicker_filter_password_form' ) ) :
	function flicker_filter_password_form( $html ) {
		$label = esc_html__( 'Password', 'flicker' );
		$html  = str_replace( 'input name="post_password"', 'input class="form-control" name="post_password" placeholder="' . $label . '"', $html );
		$html  = str_replace( 'input type="submit"', 'input class="theme_button color1" type="submit"', $html );

		return $html;
	} //flicker_filter_password_form()
endif;
add_filter( 'the_password_form', 'flicker_filter_password_form' );


/**
 * Add bootstrap CSS class to readmore blog feed anchor.
 *
 *
 * @return string HTML code of password form
 * @internal
 */
if ( !function_exists( 'flicker_filter_gallery_post_style_owl') ) :
	function flicker_filter_gallery_post_style_owl( $gallery_html ) {
		if ( $gallery_html && ! is_admin() ) {
			$gallery_html = str_replace( 'gallery ', 'isotope_container ', $gallery_html );
			//if page is current
		}

		return $gallery_html;
	} //flicker_filter_gallery_post_style_owl()
endif;
add_filter( 'gallery_style', 'flicker_filter_gallery_post_style_owl' );

/**
 * Flush out the transients used in flicker_categorized_blog.
 * @internal
 */
if ( !function_exists( 'flicker_action_category_transient_flusher' ) ) :
	function flicker_action_category_transient_flusher() {
		delete_transient( 'flicker_category_count' );
	} //flicker_action_category_transient_flusher()
endif;
add_action( 'edit_category', 'flicker_action_category_transient_flusher' );
add_action( 'save_post', 'flicker_action_category_transient_flusher' );


/**
 * Register widget areas.
 * @internal
 */

if ( !function_exists( 'flicker_action_widgets_init' ) ) :
	function flicker_action_widgets_init() {
		register_sidebar( array(
			'name'          => esc_html__( 'Main Widget Area', 'flicker' ),
			'id'            => 'sidebar-main',
			'description'   => esc_html__( 'Appears in the content section of the site.', 'flicker' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title text-center">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Shop Widget Area', 'flicker' ),
			'id'            => 'sidebar-shop',
			'description'   => esc_html__( 'Appears on the shop page of the site.', 'flicker' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Footer Widget Area', 'flicker' ),
			'id'            => 'sidebar-footer',
			'description'   => esc_html__( 'Appears in the footer section of the site.', 'flicker' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title with_line">',
			'after_title'   => '</h3>',
		) );
	} //flicker_action_widgets_init()
endif;
add_action( 'widgets_init', 'flicker_action_widgets_init' );

/**
 * Processing google fonts customizer options
 */

if ( ! function_exists( 'flicker_action_process_google_fonts' ) ) :
	function flicker_action_process_google_fonts() {
		$google_fonts        = fw_get_google_fonts();
		$include_from_google = array();

		$font_body     = fw_get_db_customizer_option( 'main_font' );
		$font_headings = fw_get_db_customizer_option( 'h_font' );

		// if is google font
		if ( isset( $google_fonts[ $font_body['family'] ] ) ) {
			$include_from_google[ $font_body['family'] ] = $google_fonts[ $font_body['family'] ];
		}

		if ( isset( $google_fonts[ $font_headings['family'] ] ) ) {
			$include_from_google[ $font_headings['family'] ] = $google_fonts[ $font_headings['family'] ];
		}

		$google_fonts_links = flicker_get_remote_fonts( $include_from_google );
		// set a option in db for save google fonts link
		update_option( 'flicker_google_fonts_link', $google_fonts_links );
	} //flicker_action_process_google_fonts()

endif;
add_action( 'customize_save_after', 'flicker_action_process_google_fonts', 999, 2 );

if ( ! function_exists( 'flicker_get_remote_fonts' ) ) :
	function flicker_get_remote_fonts( $include_from_google ) {
		/**
		 * Get remote fonts
		 *
		 * @param array $include_from_google
		 */
		if ( ! sizeof( $include_from_google ) ) {
			return '';
		}

		$html = "<link href='http://fonts.googleapis.com/css?family=";

		foreach ( $include_from_google as $font => $styles ) {
			$html .= str_replace( ' ', '+', $font ) . ':' . implode( ',', $styles['variants'] ) . '|';
		}

		$html = substr( $html, 0, - 1 );
		$html .= "' rel='stylesheet' type='text/css'>";

		return $html;
	} //flicker_get_remote_fonts()
endif;

if ( ! function_exists( 'flicker_action_add_login_page_script_and_styles' ) ) :
	function flicker_action_add_login_page_script_and_styles( $page ) {
		wp_enqueue_style(
			'flicker-login-page-style',
			FLICKER_THEME_URI . '/css/login-page.css',
			array(),
			'1.0'
		);
		wp_enqueue_script(
			'flicker-login-page-script',
			FLICKER_THEME_URI . '/js/login-page.js',
			array( 'jquery' ),
			'1.0',
			false
		);
	}
endif;
add_action( 'login_enqueue_scripts', 'flicker_action_add_login_page_script_and_styles' );


//admin dashboard styles and scripts
if ( ! function_exists( 'flicker_action_load_custom_wp_admin_style' ) ) :
	function flicker_action_load_custom_wp_admin_style() {
		wp_register_style( 'flicker_custom_wp_admin_css', FLICKER_THEME_URI . '/css/admin-style.css', false, '1.0.0' );
		wp_enqueue_style( 'flicker_custom_wp_admin_css' );

		wp_register_style( 'flicker_custom_wp_admin_fonts', FLICKER_THEME_URI . '/css/fonts.css', false, '1.0.0' );
		wp_enqueue_style( 'flicker_custom_wp_admin_fonts' );

		if ( defined( 'FW' ) ) {
			wp_enqueue_script(
				'flicker-dashboard-widget-script',
				FLICKER_THEME_URI . '/js/dashboard-widget-script.js',
				array( 'jquery' ),
				'1.0',
				false
			);
		}
	} //flicker_action_load_custom_wp_admin_style()
endif;
add_action( 'admin_enqueue_scripts', 'flicker_action_load_custom_wp_admin_style' );


// removing woo styles
// Remove each style one by one
if ( !function_exists('flicker_filter_flicker_dequeue_styles')) :
	function flicker_filter_flicker_dequeue_styles( $enqueue_styles ) {
		unset( $enqueue_styles['woocommerce-general'] );    // Remove the gloss
		unset( $enqueue_styles['woocommerce-layout'] );        // Remove the layout
		unset( $enqueue_styles['woocommerce-smallscreen'] );    // Remove the smallscreen optimisation
		return $enqueue_styles;
	} //flicker_filter_flicker_dequeue_styles()
endif;
add_filter( 'woocommerce_enqueue_styles', '__return_false' );

//this action defined in functions.php
add_action( 'tgmpa_register', 'flicker_action_register_required_plugins' );

if ( !function_exists('flicker_filter_wrap_cat_title_before_colon_in_span')) :
	function flicker_filter_wrap_cat_title_before_colon_in_span($title) {
		return preg_replace('/^.*: /', '<span class="taxonomy-name-title">${0}</span>', $title );
	}
endif;
add_filter('get_the_archive_title', 'flicker_filter_wrap_cat_title_before_colon_in_span');


//if Unyson installed - managing main slider and contact form scripts, sidebars
if ( defined( 'FW' ) ):
	//display main slider
	if ( ! function_exists( 'flicker_action_slider' ) ):

		function flicker_action_slider() {
			if(is_search()) {
				return;
			}
			$slider_id = fw_get_db_post_option( get_the_ID(), 'slider_id', false );
			if ( fw_ext( 'slider' ) ) {
				echo fw()->extensions->get( 'slider' )->render_slider( $slider_id, false );
			}

		}

		add_action( 'flicker_slider', 'flicker_action_slider' );

	endif;

	//display blog slider
	if ( ! function_exists( 'flicker_action_blog_slider' ) ):

		function flicker_action_blog_slider() {

			$blog_slider_options = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'blog_slider_switch' ) : '';
			$blog_slider_enabled = $blog_slider_options['yes'];
			if( $blog_slider_enabled ) {
				$slider_id= $blog_slider_enabled['slider_id'];
				if ( fw_ext( 'slider' ) ) {
					$slider_html = fw()->extensions->get( 'slider' )->render_slider( $slider_id, false );
					if( !empty( $slider_html ) ) {
						?>
						<div class="blog-slider col-sm-12">
							<?php
							echo wp_kses_post( $slider_html );
							?>
						</div>
						<?php
					}
				}
			}
		}

		add_action( 'flicker_blog_slider', 'flicker_action_blog_slider' );
	endif;

	/**
	 * Display current submitted FW_Form errors
	 * @return array
	 */
	if ( ! function_exists( 'flicker_action_display_form_errors' ) ):
		function flicker_action_display_form_errors() {
			$form = FW_Form::get_submitted();

			if ( ! $form || $form->is_valid() ) {
				return;
			}

			wp_enqueue_script(
				'flicker-show-form-errors',
				FLICKER_THEME_URI . '/js/form-errors.js',
				array( 'jquery' ),
				'1.0',
				true
			);

			wp_localize_script( 'flicker-show-form-errors', '_localized_form_errors', array(
				'errors'  => $form->get_errors(),
				'form_id' => $form->get_id()
			) );
		}
	endif;
	add_action( 'wp_enqueue_scripts', 'flicker_action_display_form_errors' );


	//removing standard sliders from Unyson - we use our theme slider
	if ( !function_exists( 'flicker_filter_disable_sliders' ) ) :
		function flicker_filter_disable_sliders( $sliders ) {
			foreach ( array( 'owl-carousel', 'bx-slider', 'nivo-slider' ) as $name ) {
				$key = array_search( $name, $sliders );
				unset( $sliders[ $key ] );
			}

			return $sliders;
		}
	endif;

	add_filter( 'fw_ext_slider_activated', 'flicker_filter_disable_sliders' );

	//removing standard fields from Unyson slider - we use our own slider fields
	if ( !function_exists( 'flicker_slider_population_method_custom_options' ) ) :
		function flicker_slider_population_method_custom_options( $arr ) {
			/**
			 * Filter for disable standard slider fields for carousel slider
			 *
			 * @param array $arr
			 */
			unset(
				$arr['wrapper-population-method-custom']['options']['custom-slides']['slides_options']['title'],
				$arr['wrapper-population-method-custom']['options']['custom-slides']['slides_options']['desc']
			);

			return $arr;
		}
	endif;
	add_filter( 'fw_ext_theme_slider_population_method_custom_options', 'flicker_slider_population_method_custom_options' );

	//adding custom sidebar for shop page if WooCommerce active
	if ( class_exists( 'WooCommerce' ) ) :
		if ( !function_exists( 'flicker_filter_fw_ext_sidebars_add_conditional_tag' ) ) :
			function flicker_filter_fw_ext_sidebars_add_conditional_tag($conditional_tags) {
				$conditional_tags['is_archive_page_slug'] = array(
					'order_option' => 2, // (optional: default is 1) position in the 'Others' lists in backend
					'check_priority' => 'last', // (optional: default is last, can be changed to 'first') use it to change priority checking conditional tag
					'name' => esc_html__('Products Type - Shop', 'flicker'), // conditional tag title
					'conditional_tag' => array(
						'callback' => 'is_shop', // existing callback
						'params' => array('products') //parameters for callback
					)
				);

				return $conditional_tags;
			}
		endif;
		add_filter('fw_ext_sidebars_conditional_tags', 'flicker_filter_fw_ext_sidebars_add_conditional_tag' );

		remove_theme_support( 'wc-product-gallery-zoom' );
		remove_theme_support( 'wc-product-gallery-lightbox' );
		remove_theme_support( 'wc-product-gallery-slider' );
	endif; //WooCommerce

	//theme icon fonts
	if ( ! function_exists( 'flicker_filter_custom_packs_list' ) ) :
		function flicker_filter_custom_packs_list($current_packs) {
			/**
			 * $current_packs is an array of pack names.
			 * You should return which one you would like to show in the picker.
			 */
			return array('social_icons', 'flicker_icons', 'font-awesome');
		}
	endif;
	add_filter('fw:option_type:icon-v2:filter_packs', 'flicker_filter_custom_packs_list');

	if ( ! function_exists( 'flicker_filter_add_my_icon_pack' ) ) :
		function flicker_filter_add_my_icon_pack($default_packs) {
			/**
			 * No fear. Defaults packs will be merged in back. You can't remove them.
			 * Changing some flags for them is allowed.
			 */
			return array(
				'flicker_icons' => array(
					'name'             => 'flicker_icons', // same as key
					'title'            => 'Flicker Icons',
					'css_class_prefix' => 'rt-icon2',
					'css_file'         => FLICKER_THEME_PATH . '/css/fonts.css',
					'css_file_uri'     => FLICKER_THEME_URI . '/css/fonts.css',
				),
				'social_icons' => array(
					'name'             => 'social_icons', // same as key
					'title'            => 'Social Icons',
					'css_class_prefix' => 'socicon',
					'css_file'         => FLICKER_THEME_PATH . '/css/fonts.css',
					'css_file_uri'     => FLICKER_THEME_URI . '/css/fonts.css',
				)
			);
		}
	endif;
	add_filter('fw:option_type:icon-v2:packs', 'flicker_filter_add_my_icon_pack');

	if ( ! function_exists( 'flicker_breadcrumbs_blank_search_query_fix' ) ) :
		/**
		 * Breadcrumbs modifications
		 */
		function flicker_breadcrumbs_blank_search_query_fix( $items ) {

			if ( is_search() ) {
				if ( trim ( get_search_query() ) == false ) {
					$items[ sizeof( $items ) - 1 ]['name'] = esc_html__( 'Search', 'flicker' );
				}
			}

			return $items;
		}
	endif;

	add_filter( 'fw_ext_breadcrumbs_build', 'flicker_breadcrumbs_blank_search_query_fix' );

	//enable tags for events
	if ( ! function_exists( 'flicker_add_tags_for_events_unyson_extension' ) ) :
		function flicker_add_tags_for_events_unyson_extension() {
			return true;
		}
	endif;

	add_filter('fw:ext:events:enable-tags', 'flicker_add_tags_for_events_unyson_extension');

endif; //defined('FW')

//adding custom styles to TinyMCE
// Callback function to insert 'styleselect' into the $buttons array
if ( ! function_exists( 'flicker_filter_mce_theme_format_insert_button' ) ) :
	function flicker_filter_mce_theme_format_insert_button( $buttons ) {
		array_unshift( $buttons, 'styleselect' );

		return $buttons;
	} //flicker_filter_mce_theme_format_insert_button()
endif;
// Register our callback to the appropriate filter
add_filter( 'mce_buttons_2', 'flicker_filter_mce_theme_format_insert_button' );

// Callback function to filter the MCE settings
if ( ! function_exists( 'flicker_filter_mce_theme_format_add_styles' ) ) :
	function flicker_filter_mce_theme_format_add_styles( $init_array ) {
		// Define the style_formats array
		$style_formats = array(
			// Each array child is a format with it's own settings
			array(
				'title'   => esc_html__( 'Small text', 'flicker' ),
				'block'   => 'p',
				'classes' => 'small-text',
				'wrapper' => false,
			),
			array(
				'title'   => esc_html__( 'Main theme color', 'flicker' ),
				'inline'  => 'span',
				'classes' => 'highlight',
				'wrapper' => false,
			),

		);
		// Insert the array, JSON ENCODED, into 'style_formats'
		$init_array['style_formats'] = json_encode( $style_formats );

		return $init_array;

	} //flicker_filter_mce_theme_format_add_styles()
endif;

// Attach callback to 'tiny_mce_before_init'
add_filter( 'tiny_mce_before_init', 'flicker_filter_mce_theme_format_add_styles', 1 );


//demo content on remote hosting
/**
 * @param FW_Ext_Backups_Demo[] $demos
 *
 * @return FW_Ext_Backups_Demo[]
 */


if ( ! function_exists( 'flicker_filter_theme_fw_ext_backups_demos' ) ) :

	function flicker_filter_theme_fw_ext_backups_demos( $demos ) {
		$demo_version_suffix = '-v' . FLICKER_REMOTE_DEMO_VERSION; // '-v1.0.0'

		$demos_array = array (
			'flicker-demo' . $demo_version_suffix => array (
				'title'        => esc_html__( 'Flicker Demo', 'flicker' ),
				'screenshot'   => esc_url('http://webdesign-finder.com/remote-demo-content/flicker/demo/screenshot.png'),
				'preview_link' => esc_url('http://webdesign-finder.com/flicker/'),
			),
		);

		// You may request this demo id from this theme author to get a colorized demo content. See the author contacts information.
		$secret_demo_id = FLICKER_REMOTE_DEMO_ID;

		// remote demo URL
		$download_url = esc_url('http://webdesign-finder.com/remote-demo-content/flicker');

		foreach ( $demos_array as $id => $data ) {
			$demo = new FW_Ext_Backups_Demo( $id, 'piecemeal', array (
				'url'     => $download_url,
				'file_id' => $id,
			) );
			$demo->set_title( $data[ 'title' ] );
			$demo->set_screenshot( $data[ 'screenshot' ] );
			$demo->set_preview_link( $data[ 'preview_link' ] );

			$demos[ $demo->get_id() ] = $demo;

			unset( $demo );
		}

		return $demos;
	} //flicker_filter_theme_fw_ext_backups_demos()
endif;
add_filter( 'fw:ext:backups-demo:demos', 'flicker_filter_theme_fw_ext_backups_demos' );


//////////
//Booked//
//////////
//Remove Booked plugin front-end color theme (color-theme.php)
if( class_exists('booked_plugin')) {
	remove_action( 'wp_enqueue_scripts', array('booked_plugin', 'front_end_color_theme'));
}//Booked

//renaming projects to gallery
if ( ! function_exists( 'flicker_projects_change_post_names' ) ):
	function flicker_projects_change_post_names() {
		return array(
			'singular' => esc_html__( 'Project', 'flicker' ),
			'plural'   => esc_html__( 'Gallery', 'flicker' )
		);
	}
endif;

add_action( 'fw_ext_projects_post_type_name', 'flicker_projects_change_post_names' );
