<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'heading_align' => array(
		'type'    => 'select',
		'value'   => 'text-left',
		'label'   => esc_html__( 'Text alignment', 'flicker' ),
		'desc'    => esc_html__( 'Select heading text alignment', 'flicker' ),
		'choices' => array(
			''   => esc_html__( 'Left', 'flicker' ),
			'text-center' => esc_html__( 'Center', 'flicker' ),
			'text-right'  => esc_html__( 'Right', 'flicker' ),
		),
	),
	'headings'      => array(
		'type'        => 'addable-box',
		'value'       => '',
		'label'       => esc_html__( 'Headings', 'flicker' ),
		'desc'        => esc_html__( 'Choose a tag and text inside it', 'flicker' ),
		'box-options' => array(
			'heading_tag'            => array(
				'type'    => 'select',
				'value'   => 'h3',
				'label'   => esc_html__( 'Heading tag', 'flicker' ),
				'desc'    => esc_html__( 'Select a tag for your ', 'flicker' ),
				'choices' => array(
					'h3' => esc_html__( 'H3 tag', 'flicker' ),
					'h2' => esc_html__( 'H2 tag', 'flicker' ),
					'h4' => esc_html__( 'H4 tag', 'flicker' ),
					'h5' => esc_html__( 'H5 tag', 'flicker' ),
					'h6' => esc_html__( 'H6 tag', 'flicker' ),
					'p'  => esc_html__( 'P tag', 'flicker' ),

				),
			),
			'heading_text'           => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Heading text', 'flicker' ),
				'desc'  => esc_html__( 'Text to appear in slide layer', 'flicker' ),
			),
			'heading_text_color'     => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Heading text color', 'flicker' ),
				'desc'    => esc_html__( 'Select a color for your text in layer', 'flicker' ),
				'choices' => array(
					''           => esc_html__( 'Inherited', 'flicker' ),
					'highlight'  => esc_html__( 'Theme accent color', 'flicker' ),
					'grey'       => esc_html__( 'Dark grey theme color', 'flicker' ),
					'black'      => esc_html__( 'Dark theme color', 'flicker' ),

				),
			),
			'heading_text_weight'    => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Heading text weight', 'flicker' ),
				'desc'    => esc_html__( 'Select a weight for your text in layer', 'flicker' ),
				'choices' => array(
					''     => esc_html__( 'Normal', 'flicker' ),
					'bold' => esc_html__( 'Bold', 'flicker' ),
					'thin' => esc_html__( 'Thin', 'flicker' ),

				),
			),
			'heading_text_transform' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Heading text transform', 'flicker' ),
				'desc'    => esc_html__( 'Select a weight for your text in layer', 'flicker' ),
				'choices' => array(
					''                => esc_html__( 'None', 'flicker' ),
					'text-lowercase'  => esc_html__( 'Lowercase', 'flicker' ),
					'text-uppercase'  => esc_html__( 'Uppercase', 'flicker' ),
					'text-capitalize' => esc_html__( 'Capitalize', 'flicker' ),

				),
			),
			'heading_crossing_line' => array(
				'type'         => 'switch',
				'label'        => __( 'Header crossing line', 'flicker' ),
				'desc'         => __( 'Select here if you want to add color crossing line', 'flicker' ),
				'right-choice' => array(
					'value' => 'with_line',
					'label' => __( 'Yes', 'flicker' ),
				),
				'left-choice'  => array(
					'value' => '',
					'label' => __( 'No', 'flicker' ),
				),
			),
		),
		'template'    => '{{- heading_text }}',
	)
);
