<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(

	'tab_main_options' => array(
		'type' => 'tab',
		'title' => esc_html__('Main Options', 'flicker'),
		'options' => array(
			'is_fullwidth'     => array(
				'label' => esc_html__( 'Full Width', 'flicker' ),
				'type'  => 'switch',
			),

			'background_color' => array(
				'type'    => 'select',
				'value'   => 'ls',
				'label'   => esc_html__( 'Background color', 'flicker' ),
				'desc'    => esc_html__( 'Select background color', 'flicker' ),
				'help'    => esc_html__( 'Select one of predefined background colors', 'flicker' ),
				'choices' => array(
					'ls'             => esc_html__( 'Light', 'flicker' ),
					'ls ms'          => esc_html__( 'Light Grey', 'flicker' ),
					'cs grey'        => esc_html__( 'Grey', 'flicker' ),
					'ds ms'          => esc_html__( 'Dark Grey', 'flicker' ),
					'ds'             => esc_html__( 'Dark', 'flicker' ),
					'cs'             => esc_html__( 'Main color', 'flicker' ),
					'cs gradient'    => esc_html__( 'Color Gradient color', 'flicker' ),
				),
			),
			'top_padding'      => array(
				'type'    => 'select',
				'value'   => 'section_padding_top_50',
				'label'   => esc_html__( 'Top padding', 'flicker' ),
				'desc'    => esc_html__( 'Choose top padding value', 'flicker' ),
				'choices' => array(
					'section_padding_top_0'   => esc_html__( '0', 'flicker' ),
					'section_padding_top_5'   => esc_html__( '5 px', 'flicker' ),
					'section_padding_top_15'  => esc_html__( '15 px', 'flicker' ),
					'section_padding_top_25'  => esc_html__( '25 px', 'flicker' ),
					'section_padding_top_30'  => esc_html__( '30 px', 'flicker' ),
					'section_padding_top_40'  => esc_html__( '40 px', 'flicker' ),
					'section_padding_top_50'  => esc_html__( '50 px', 'flicker' ),
					'section_padding_top_65'  => esc_html__( '65 px', 'flicker' ),
					'section_padding_top_75'  => esc_html__( '75 px', 'flicker' ),
					'section_padding_top_100' => esc_html__( '100 px', 'flicker' ),
					'section_padding_top_130' => esc_html__( '130 px', 'flicker' ),
					'section_padding_top_150' => esc_html__( '150 px', 'flicker' ),
				),
			),
			'bottom_padding'   => array(
				'type'    => 'select',
				'value'   => 'section_padding_bottom_50',
				'label'   => esc_html__( 'Bottom padding', 'flicker' ),
				'desc'    => esc_html__( 'Choose bottom padding value', 'flicker' ),
				'choices' => array(
					'section_padding_bottom_0'   => esc_html__( '0', 'flicker' ),
					'section_padding_bottom_5'   => esc_html__( '5 px', 'flicker' ),
					'section_padding_bottom_15'  => esc_html__( '15 px', 'flicker' ),
					'section_padding_bottom_25'  => esc_html__( '25 px', 'flicker' ),
					'section_padding_bottom_30'  => esc_html__( '30 px', 'flicker' ),
					'section_padding_bottom_40'  => esc_html__( '40 px', 'flicker' ),
					'section_padding_bottom_50'  => esc_html__( '50 px', 'flicker' ),
					'section_padding_bottom_65'  => esc_html__( '65 px', 'flicker' ),
					'section_padding_bottom_75'  => esc_html__( '75 px', 'flicker' ),
					'section_padding_bottom_100' => esc_html__( '100 px', 'flicker' ),
					'section_padding_bottom_130' => esc_html__( '130 px', 'flicker' ),
					'section_padding_bottom_150' => esc_html__( '150 px', 'flicker' ),
				),
			),
			'columns_padding'  => array(
				'type'    => 'select',
				'value'   => 'columns_padding_15',
				'label'   => esc_html__( 'Column paddings', 'flicker' ),
				'desc'    => esc_html__( 'Choose columns horizontal paddings value', 'flicker' ),
				'choices' => array(
					'columns_padding_0'  => esc_html__( '0', 'flicker' ),
					'columns_padding_1'  => esc_html__( '1 px', 'flicker' ),
					'columns_padding_2'  => esc_html__( '2 px', 'flicker' ),
					'columns_padding_5'  => esc_html__( '5 px', 'flicker' ),
					'columns_padding_15' => esc_html__( '15 px - default', 'flicker' ),
					'columns_padding_25' => esc_html__( '25 px', 'flicker' ),
				),
			),
			'columns_top_margin'  => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Column Top Margin', 'flicker' ),
				'desc'    => esc_html__( 'Choose columns top margin value', 'flicker' ),
				'choices' => array(
					'columns_margin_top_0'  => esc_html__( '0 px', 'flicker' ),
					''  => esc_html__( '10 px  - default', 'flicker' ),
					'columns_margin_top_20'  => esc_html__( '20 px', 'flicker' ),
					'columns_margin_top_30'  => esc_html__( '30 px', 'flicker' ),
					'columns_margin_top_40'  => esc_html__( '40 px', 'flicker' ),
				),
			),
			'columns_bottom_margin'  => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Column Bottom Margin', 'flicker' ),
				'desc'    => esc_html__( 'Choose columns bottom margin value', 'flicker' ),
				'choices' => array(
					'columns_margin_bottom_0'  => esc_html__( '0 px', 'flicker' ),
					''  => esc_html__( '10 px  - default', 'flicker' ),
					'columns_margin_bottom_20'  => esc_html__( '20 px', 'flicker' ),
					'columns_margin_bottom_30'  => esc_html__( '30 px', 'flicker' ),
					'columns_margin_bottom_40'  => esc_html__( '40 px', 'flicker' ),
				),
			),
			'background_image' => array(
				'label'   => esc_html__( 'Background Image', 'flicker' ),
				'desc'    => esc_html__( 'Please select the background image', 'flicker' ),
				'type'    => 'background-image',
				'choices' => array(//	in future may will set predefined images
				)
			),
			'background_cover' => array(
				'label' => esc_html__( 'Background Cover', 'flicker' ),
				'type'  => 'switch',
			),
			'parallax'         => array(
				'label' => esc_html__( 'Parallax', 'flicker' ),
				'type'  => 'switch',
			),
			'is_table'         => array(
				'label' => esc_html__( 'Vertical align content', 'flicker' ),
				'desc'  => esc_html__( 'Align columns content vertically on wide screens', 'flicker' ),
				'type'  => 'switch',
			),

			'section_id' => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__('ID attribute', 'flicker'),
				'desc'  => esc_html__('Add ID attribute to section. Useful for single page menu', 'flicker'),
			),
		),
	),

	'tab_onehalf_media_options' => array(
		'type' => 'tab',
		'title' => esc_html__('One half width Media', 'flicker'),
		'options' => array(
			'side_media_image' => array(
				'type'  => 'upload',
				'value' => array(),
				'label' => esc_html__('Side media image', 'flicker'),
				'desc'  => esc_html__('Select image that you want to appear as one half side image', 'flicker'),
				'images_only' => true,
			),
			'side_media_link' => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__('Link to your side media', 'flicker'),
				'desc'  => esc_html__('You can add a link to your side media. If YouTube link will be provided, video will play in LightBox', 'flicker'),
			),
			'side_media_video' => array(
				'type'    => 'oembed',
				'value'   => '',
				'label'   => esc_html__( 'Video', 'flicker' ),
				'desc'    => esc_html__( 'Adds video player. Works only when side media image is set', 'flicker' ),
				'help'    => esc_html__( 'Leave blank if no needed', 'flicker' ),
				'preview' => array(
					'width'      => 278, // optional, if you want to set the fixed width to iframe
					'height'     => 185, // optional, if you want to set the fixed height to iframe
					/**
					 * if is set to false it will force to fit the dimensions,
					 * because some widgets return iframe with aspect ratio and ignore applied dimensions
					 */
					'keep_ratio' => true
				),
			),
			'side_media_position'  => array(
				'type'  => 'switch',
				'value' => 'cover_left',
				'label' => esc_html__('Media position', 'flicker'),
				'desc'  => esc_html__('Left or right media position', 'flicker'),
				'left-choice' => array(
					'value' => 'cover_left',
					'label' => esc_html__('Left', 'flicker'),
				),
				'right-choice' => array(
					'value' => 'cover_right',
					'label' => esc_html__('Right', 'flicker'),
				),
			),
		),

	),

);
