<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * Shortcode Posts - vertical item layout type 2
 */

$terms          = get_the_terms( get_the_ID(), 'category' );
$filter_classes = '';
foreach ( $terms as $term ) {
	$filter_classes .= ' filter-' . $term->slug;
}

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;

?>
<article <?php post_class( "vertical-item content-padding with_background rounded text-center offset_button " . $filter_classes ); ?>>
    <?php flicker_post_thumbnail(); ?>
	<div class="item-content">
        <header class="entry-header">

            <div class="entry-meta small-text content-justify">
	            <?php
	            if ( 'post' == get_post_type() ) {
		            flicker_posted_on( true );
	            } ?>
		        <?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>

                    <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'flicker' ) ); ?></span>

		        <?php endif; ?>
            </div>

			<?php
			the_title( '<h4 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
			?>

        </header><!-- .entry-header -->
        <div class="entry-content">
            <div class="content-3lines-ellipsis">
	            <?php the_excerpt(); ?>
            </div>
            <span class="button_wrap">
                <a href="<?php the_permalink(); ?>" class="theme_button color1"><?php echo esc_html__( 'Read More', 'flicker' ); ?></a>
            </span>
        </div><!-- .entry-content -->
	</div>

</article><!-- eof vertical-item -->
