<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * Shortcode Posts - title item layout
 */

$terms          = get_the_terms( get_the_ID(), 'category' );
$filter_classes = '';
foreach ( $terms as $term ) {
	$filter_classes .= ' filter-' . $term->slug;
}

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;

//wrapping in div for carousel layout
?>

<?php
global $post;
$post_layout = 'post-layout-standard';
if ( function_exists( 'fw_get_db_post_option' ) ) {
$post_layout = fw_get_db_post_option( $post->ID, 'post-layout', 'post-layout-standard' );
}
//standard feed layout (image at the top or not image at all if option is standard or has no post thumbnail)
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'format-small-image' ); ?>>
    <div class="side-item side-md content-padding with_background rounded overflow_hidden">
        <div class="row">
            <?php flicker_post_thumbnail( true ); ?>
	        <?php if ( get_the_post_thumbnail() ) : ?>
            <div class="col-md-7">
            <?php else: ?>
            <div class="col-sm-12">
            <?php endif; ?>

                <div class="item-content">
                    <header class="entry-header">

                        <div class="entry-meta small-text content-justify">
	                        <?php
	                        if ( 'post' == get_post_type() ) {
		                        flicker_posted_on( true );
	                        } ?>
				            <?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>

                                <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'flicker' ) ); ?></span>

				            <?php endif; ?>
                        </div>

			            <?php
			            the_title( '<h4 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
			            ?>

                    </header><!-- .entry-header -->
                    <div class="entry-content content-3lines-ellipsis">
			            <?php the_excerpt(); ?>
                    </div><!-- .entry-content -->
                </div>

            </div><!-- eof .col-md-6 -->
        </div><!-- eof .row -->
    </div><!-- eof .side-item -->

</article><!-- #post-## -->