<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * Shortcode Posts - regular item layout
 */

$event_meta = fw_get_db_post_option( get_the_ID(), fw()->extensions->get( 'events' )->get_event_option_id() );
$event_full_meta = fw_get_db_post_option( get_the_ID() );

$event_date = $event_meta['event_children'][0]['event_date_range'];
$event_location = !empty( $event_meta['event_location']['city'] ) ? $event_meta['event_location']['city'] : $event_meta['event_location']['address'];
$time_start = date( get_option('time_format'), strtotime( $event_date['from']) );
$time_end = date( get_option('time_format'), strtotime( $event_date['to']) );

$buy_tickets_link = !empty( $event_full_meta['buy-tickets-link'] ) ? $event_full_meta['buy-tickets-link'] : '';
$ticket_price = !empty( $event_full_meta['ticket-price'] ) ? $event_full_meta['ticket-price'] : '';

//has thumbnail layout
if ( get_the_post_thumbnail() ) : ?>
    <article <?php post_class( 'vertical-item content-absolute hover-entry-content text-center' ) ?>>
        <div class="item-media mutted-media top_rounded overflow_hidden">
            <?php the_post_thumbnail( 'flicker-small-width' ) ?>
            <?php if ( $ticket_price ) : ?>
            <div class="entry-meta-corner grey">
                <span class="small-text"><?php echo esc_html__( 'from', 'flicker' ); ?></span>
                <span class="big"><?php echo esc_html( $ticket_price ); ?></span>
                <span class="small-text"><?php echo esc_html__( 'per ticket', 'flicker' ); ?></span>
            </div>
            <?php endif; ?>
        </div>
        <div class="item-content cs">
            <h3 class="entry-title bottommargin_0">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h3>
            <p class="small-text bottommargin_0">
	            <?php echo date( get_option('date_format'), strtotime( $event_date['from']) ) . ' / ' . $time_start . ' / ' . $event_location; ?>
            </p>
            <div class="entry-content">
                <div class="content-3lines-ellipsis">
	                <?php the_excerpt(); ?>
                </div>
                <div class="topmargin_20 event_buttons">
                    <?php if ( $buy_tickets_link ) : ?>
                    <a href="<?php the_permalink(); ?>" class="theme_button color2 buy_tickets_button"><?php echo esc_html__( 'Buy Tickets', 'flicker' ); ?></a>
                    <?php endif; ?>
                    <a href="<?php the_permalink(); ?>" class="theme_button inverse"><?php echo esc_html__( 'Read More', 'flicker' ); ?></a>
                </div>
            </div>
        </div>
    </article>
	<?php
//no featured image
else :
	?>
    <article <?php post_class( 'vertical-item content-padding text-center' ) ?>>
        <div class="item-content cs">
            <h3 class="entry-title bottommargin_0">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h3>
            <p class="small-text bottommargin_20">
				<?php echo date( get_option('date_format'), strtotime( $event_date['from']) ) . ' / ' . $time_start . ' / ' . $event_location; ?>
            </p>
            <div class="content-3lines-ellipsis">
                <?php the_excerpt(); ?>
            </div>
            <div class="topmargin_20 event_buttons">
                <?php if ( $buy_tickets_link ) : ?>
                    <a href="<?php the_permalink(); ?>" class="theme_button color2 buy_tickets_button"><?php echo esc_html__( 'Read More', 'flicker' ); ?></a>
                <?php endif; ?>
                <a href="<?php the_permalink(); ?>" class="theme_button inverse"><?php echo esc_html__( 'Read More', 'flicker' ); ?></a>
            </div>
        </div>
    </article>
	<?php
endif;
?>