<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'style' => array(
		'type'     => 'multi-picker',
		'label'    => false,
		'desc'     => false,
		'picker' => array(
			'ruler_type' => array(
				'type'    => 'select',
				'label'   => esc_html__( 'Ruler Type', 'flicker' ),
				'desc'    => esc_html__( 'Here you can set the styling and size of the HR element', 'flicker' ),
				'choices' => array(
					'line'  => esc_html__( 'Line', 'flicker' ),
					'space' => esc_html__( 'Whitespace', 'flicker' ),
				)
			)
		),
		'choices'     => array(
			'space' => array(
				'height' => array(
					'label' => esc_html__( 'Height', 'flicker' ),
					'desc'  => esc_html__( 'How much whitespace do you need? Enter a pixel value. Positive value will increase the whitespace, negative value will reduce it. eg: \'50\', \'-25\', \'200\'', 'flicker' ),
					'type'  => 'text',
					'value' => '50'
				)
			)
		)
	),
	'responsive'         => array(
		'attr'          => array( 'class' => 'fw-advanced-button' ),
		'type'          => 'popup',
		'label'         => esc_html__( 'Responsive visibility', 'flicker' ),
		'button'        => esc_html__( 'Settings', 'flicker' ),
		'size'          => 'medium',
		'popup-options' => array(
			'hidden_lg'     => array(
				'type'    => 'multi-picker',
				'label'   => false,
				'desc'    => false,
				'picker'  => array(
					'selected' => array(
						'type'         => 'switch',
						'value'        => 'yes',
						'label'        => __( 'Large ( > 1199px)', 'flicker' ),
						'desc'         => esc_html__( 'Display on large screen?', 'flicker' ),
						'left-choice'  => array(
							'value' => 'no',
							'label' => esc_html__( 'No', 'flicker' ),
						),
						'right-choice' => array(
							'value' => 'yes',
							'label' => esc_html__( 'Yes', 'flicker' ),
						)
					),
				),
			),
			'hidden_md'     => array(
				'type'    => 'multi-picker',
				'label'   => false,
				'desc'    => false,
				'picker'  => array(
					'selected' => array(
						'type'         => 'switch',
						'value'        => 'yes',
						'label'        => __( 'Medium ( > 991px )', 'flicker' ),
						'desc'         => esc_html__( 'Display on medium screen?', 'flicker' ),
						'left-choice'  => array(
							'value' => 'no',
							'label' => esc_html__( 'No', 'flicker' ),
						),
						'right-choice' => array(
							'value' => 'yes',
							'label' => esc_html__( 'Yes', 'flicker' ),
						)
					),
				),
			),
			'hidden_sm'     => array(
				'type'    => 'multi-picker',
				'label'   => false,
				'desc'    => false,
				'picker'  => array(
					'selected' => array(
						'type'         => 'switch',
						'value'        => 'yes',
						'label'        => __( 'Small ( > 767px )', 'flicker' ),
						'desc'         => esc_html__( 'Display on small screen?', 'flicker' ),
						'left-choice'  => array(
							'value' => 'no',
							'label' => esc_html__( 'No', 'flicker' ),
						),
						'right-choice' => array(
							'value' => 'yes',
							'label' => esc_html__( 'Yes', 'flicker' ),
						)
					),
				),
			),
			'hidden_xs' => array(
				'type'    => 'multi-picker',
				'label'   => false,
				'desc'    => false,
				'picker'  => array(
					'selected' => array(
						'type'         => 'switch',
						'value'        => 'yes',
						'label'        => __( 'Extra small ( < 768px )', 'flicker' ),
						'desc'         => esc_html__( 'Display on extra small screen?', 'flicker' ),
						'left-choice'  => array(
							'value' => 'no',
							'label' => esc_html__( 'No', 'flicker' ),
						),
						'right-choice' => array(
							'value' => 'yes',
							'label' => esc_html__( 'Yes', 'flicker' ),
						)
					),
				),
				'choices' => array(),
			),
		),
	),
);
