<?php
/**
 * The template for displaying Comments
 *
 * The area of the page that contains comments and the comment form.
 */

/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<div id="comments" class="comments-area with_background rounded with_padding big-padding">
	<?php
	//fields are hooked in inc/hooks.php

	if ( have_comments() ) {
		$title_reply = sprintf( esc_html( _n( 'One comment', '%1$s Comments:', get_comments_number(), 'flicker' ) ), number_format_i18n( get_comments_number() ) );
	} else {
		$title_reply = esc_html__( 'No comments', 'flicker' );
	}

	$args = array(
		'comment_field'        => is_user_logged_in() ? '<div class="col-sm-12"><p class="comment-form-comment"><label for="comment">' . esc_html_x( 'Comment', 'noun', 'flicker' ) . '</label> <textarea id="comment"  class="form-control" name="comment" cols="45" rows="5"  aria-required="true" required="required"  placeholder="' . esc_html__( 'Comment', 'flicker' ) . '"></textarea></p></div>' : '',
		'logged_in_as'         => '<div class="user-avatar">' . get_avatar( get_current_user_id() ) . '</div><div class="row columns_padding_10">',
		'comment_notes_before' => '<div class="user-avatar">' . get_avatar( get_current_user_id() ) . '</div><div class="row columns_padding_10">',
		'class_form'           => 'comment-form',
		'cancel_reply_link'    => esc_html__( 'Cancel reply', 'flicker' ),
		'label_submit'         => esc_html__( 'Send Comment', 'flicker' ),
		'title_reply'          => '<span class="sr-only">' . esc_html__( 'Leave a comment:', 'flicker' ) . '</span>',
		'title_reply_before'   => '<h3 class="highlightlinks">',
		'title_reply_after'    => '</h3>',
		'submit_button'        => '<button type="submit" name="%1$s" id="%2$s" class="theme_button color1 min_width_button">%4$s</button><button type="reset" id="reset_%2$s" class="theme_button min_width_button">' . esc_html__( 'Clear Form', 'flicker' ) . '</button>',
		'submit_field'         => '<div class="col-sm-12 bottommargin_0"><p class="form-submit topmargin_20">%1$s %2$s</p></div></div>',
		'format'               => 'html5',
	); ?>
	<?php if ( have_comments() ) : ?>
		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
			<nav id="comment-nav-above" class="navigation comment-navigation text-center" role="navigation">
				<?php flicker_paging_comments_nav(); ?>
			</nav><!-- #comment-nav-above -->
		<?php endif; // Check for comment navigation. ?>

        <h3><?php echo esc_html( $title_reply ) ?></h3>

		<ol class="comment-list">
			<?php
			wp_list_comments( array(
				'walker'      => flicker_return_comments_walker(),
				'style'       => 'ol',
				'short_ping'  => true,
				'avatar_size' => 70,
			) );
			?>
		</ol><!-- .comment-list -->
		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
			<nav id="comment-nav-below" class="navigation comment-navigation text-center" role="navigation">
				<?php flicker_paging_comments_nav(); ?>
			</nav><!-- #comment-nav-below -->
		<?php endif; // Check for comment navigation. ?>

		<?php if ( ! comments_open() ) : ?>
			<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'flicker' ); ?></p>
		<?php endif; //comments_open() ?>

	<?php endif; // have_comments()

	comment_form( $args );
    ?>
</div><!-- #comments -->