<?php
/**
 * @package Musiziya
 * @since Musiziya 1.0
 *
 */
?>

<?php musiziya_post_thumbnail(); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<header class="entry-header">
		<div class="entry-meta">
			<?php musiziya_posted_on(); ?>
		</div>
	</header> <!-- entry-header -->

	<div class="entry-content clearfix">
		<?php
			/* translators: %s: Name of current post */
			the_content( sprintf(
				esc_html__( 'Continue reading %s', 'musiziya' ),
				the_title( '<span class="screen-reader-text">', '</span>', false )
				) );

			wp_link_pages( array(
				'before'      	 => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'musiziya' ) . '</span>',
				'after'       	 => '</div>',
				'link_before' 	 => '<span>',
				'link_after'  	 => '</span>',
				'current_before' => '',
				'current_after'  => '',
				'pagelink'    	 => '%',
			) );
		?>
	</div><!-- .entry-content -->
	
	<footer class="entry-footer">
		<?php musiziya_entry_footer(); ?>
	</footer> <!-- entry-footer -->
</article>

<?php if(musiziya_get_option ('blog_author_bio')) { ?>
	<?php get_template_part( 'loop/content', 'author' ); ?>
<?php } ?>