<?php
/**
 * The template for displaying the footer.
 * Contains the closing of the #content main and all content after
 *
 * @package Musiziya
 * @since Musiziya 1.0
 */
?>


<?php if( !is_page_template( 'page-fullwidth.php' ) ) { ?>

<?php } ?>
</main><!--/#content-->

<footer class="footer-wrapper">
	<?php get_sidebar('footer'); ?>
	<div class="sub-footer">
	<div class="container">
		<div class="row">
			<div class="col-xs-12">
				<div class="col-md-12">
					<span class="copyright-message">
						<?php echo wp_kses_post(musiziya_get_option('footer_copyright_text')); ?>
					</span>	
					
					<?php if (musiziya_get_option('new_class_footer')) { ?>
						<div id="newclass-footer">
					<?php } ?>
							<span class="copyright-message cntr-cm">
								<?php echo esc_html_e( 'Copyright &copy; ', 'musiziya' )?> <?php echo esc_attr( get_bloginfo( 'name' ) ); ?>
							</span>	
						</div>
					

					<div class="social-icons">
						<?php if ( has_nav_menu( 'footer-menu' ) ) : ?>
							<div class="footer-nav">
								<?php musiziya_footer_nav(); ?>
							</div>
						<?php endif; ?>
					</div><!-- end icons -->
				</div>	
			</div><!-- end col-xs-12 -->	
		</div><!-- end row -->
	</div><!-- end container -->
</div><!-- end sub-footer -->
</footer>

<?php if (musiziya_get_option('scroll_to_top')) { ?>
	<a href="<?php echo esc_url( __( '#', 'musiziya' ) ); ?>" id="return-to-top"><i class="fa fa-arrow-up"></i></a>
<?php } ?>

<?php wp_footer(); ?>
</body>
</html>