<?php
/**
 * @package Musiziya
 * @since Musiziya 1.0
 */

?>

<?php if (post_password_required()) { ?>
   
<?php return; } ?>

<div id="comments" class="comments-area">


	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) :
	?>
	<h3 class="comments-header">
		<?php
		$musiziya_comment_count = get_comments_number();
		if ( '1' === $musiziya_comment_count ) {
		printf(
		/* translators: 1: title. */
		esc_html__( 'One thought on &ldquo;%1$s&rdquo;', 'musiziya' ),
		'<span>' . get_the_title() . '</span>'
			);
			} else {
			printf( 
				esc_html( _nx( '%1$s thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', $musiziya_comment_count, 'comments title', 'musiziya' ) ),
				number_format_i18n( $musiziya_comment_count ),
				'<span>' . get_the_title() . '</span>'
				);
			}
			?>
	</h3><!-- .comments-title -->

	<?php the_comments_navigation(); ?>
	<div class="commentlist col-md-12">
		<ul><?php wp_list_comments( array( 'callback' => 'musiziya_comment' ) ); ?></ul>
	</div><!-- .comment-list -->

	<?php
	the_comments_navigation();
	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() ) :
	?>
	<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'musiziya' ); ?></p>
	<?php
	endif;
	endif; // Check for have_comments().
	comment_form(
			array(
				'id_form'              => 'form',
				'class_form'           => 'row',
				'fields'               => array(
					'author'            => '<div class="form-group col-sm-4"><input id="author" class="form-control input-style-2" type="text" name="author"  placeholder="'. esc_attr__( 'Name', 'musiziya') .'" required /></div>',
					'email'             => '<div class="form-group col-sm-4"><input name="email" id="email" class="form-control input-style-2" type="email" placeholder="'. esc_attr__( 'Email address', 'musiziya') .'" required /></div>',
					'url'           => '<div class="form-group col-sm-4"><input id="url" class="form-control input-style-2" name="url" type="text"  placeholder="'. esc_attr__( 'http://example.com', 'musiziya') .'" /></div>',
				),
				'comment_field'        => '<div class="form-group col-sm-12"><textarea cols="30" id="message" class="form-control input-style-2" name="comment" rows="3" placeholder="'. esc_attr__( 'Enter your comment', 'musiziya') .'" required></textarea></div>',
				'must_log_in'          => '',
				'logged_in_as'         => '',
				'comment_notes_before' => '',
				'comment_notes_after'  => '',
				'title_reply'          => '',
				'title_reply_to'       => esc_html__('Leave a Reply to %s', 'musiziya' ),
				'cancel_reply_link'    => esc_html__('Cancel', 'musiziya' ),
				'label_submit'         => esc_html__('Submit', 'musiziya' ),
				'submit_button'        => '<div class="form-group col-sm-12"><button type="submit" class="submit btn-default"><span>' . esc_html__('Post Comment', 'musiziya') . '</span></button></div>',
				'submit_field'         => '%1$s %2$s',
			)
		); 
	?>

</div><!-- #comments -->