<?php 

/**
* @package Musiziya enqueued scripts
* @since Musiziya 1.0
*
*/

/**
    Load needed scripts
**/

function musiziya_scripts() {
	wp_enqueue_script('modernizr', MUSIZIYA_JS_URI . '/modernizr.js', 	array(), '2.8.3', true);
	wp_enqueue_script('bootstrap', MUSIZIYA_JS_URI . '/bootstrap.js', 	array('jquery'), '3.3.5', true);
	wp_enqueue_script('musiziya-scripts', MUSIZIYA_JS_URI . '/scripts.js', 	array(), '1.1.2', true);
	wp_enqueue_script('totop', MUSIZIYA_JS_URI . '/totop.js', 	array(), '1.1.2', true);
	wp_enqueue_script('menusearch', MUSIZIYA_JS_URI . '/menusearch.js', 	array(), '2.8.3', true);

	if ( is_singular() && wp_attachment_is_image() ) {
		wp_enqueue_script('keyboard-image-navigation', MUSIZIYA_JS_URI . '/keyboard-image-navigation.js');
	}

	if ( (!is_admin()) && is_singular() && comments_open() && !is_front_page() && get_option('thread_comments')) { 
		wp_enqueue_script( 'comment-reply' ); 
	}

	// Enqueue editor styles.
	wp_enqueue_style('musiziya-gutenberg', MUSIZIYA_CSS_URI   . '/gutenberg.css');
	
	// Load Bootstrap
	wp_enqueue_style('bootstrap', MUSIZIYA_CSS_URI   . '/bootstrap.css');
	// animate 
	wp_enqueue_style('animate', MUSIZIYA_CSS_URI 	. '/animate.css');

	// flaticon
	wp_enqueue_style('flaticon', MUSIZIYA_CSS_URI 	. '/flaticon.css');
	// fontawesome
	wp_enqueue_style('fontawesome', MUSIZIYA_CSS_URI 	. '/fontawesome.css');
	//WooCommerce
	wp_enqueue_style('musiziya-shop', 		MUSIZIYA_CSS_URI   . '/shop.css');

}

add_action('wp_enqueue_scripts', 'musiziya_scripts');


function musiziya_customstyles() {
	// Load main stylesheet
	wp_enqueue_style( 'musiziya-style', get_stylesheet_uri() );
		$option_css = trim(preg_replace( '/\s+/', ' ', musiziya_get_option_css()));
		if(!empty($option_css)) {
			$customcss = $option_css;
        wp_add_inline_style( 'musiziya-style', $customcss );
		}
	}
add_action( 'wp_enqueue_scripts', 'musiziya_customstyles' );
	