<?php
/**
 *
 * Register Menus, Sidebars, Footer widgets
 *
 * @package Musiziya
 * @since Musiziya 1.0
 */

/**
    Menus & Navigation
**/

// Primary menu
function musiziya_main_nav() {
  wp_nav_menu(array(
    'menu'              => esc_html__('Primary', 'musiziya'),
    'theme_location'    => 'primary',
    'container'         => false,
    'menu_class'        => 'nav navbar-nav',
    'fallback_cb'       => 'Musiziya_Bootstrap_Navwalker::fallback',
    'walker'            => new Musiziya_Bootstrap_Navwalker()
    ) 
  );
}
function musiziya_main_nav_mobile() {
  wp_nav_menu(array(
    'menu'              => esc_html__('Mobile', 'musiziya'),
    'theme_location'    => 'mobilem',
    'container'         => false,
    'menu_class'        => 'nav navbar-nav',
    'fallback_cb'       => 'Musiziya_Bootstrap_Navwalker::fallback',
    'walker'            => new Musiziya_Bootstrap_Navwalker()
    ) 
  );
}

// Footer menu
function musiziya_footer_nav() {
  wp_nav_menu(array(
    'menu'              => esc_html__('Footer Menu', 'musiziya'),
    'theme_location'    => 'footer-menu',
    'container'         => false,
    'menu_class'        => 'unstyled',
    'fallback_cb'       => 'Musiziya_Bootstrap_Navwalker_Footer::fallback',
    'walker'            => new Musiziya_Bootstrap_Navwalker_Footer()
    ) 
  );
}

function musiziya_add_sidebar_offc($items, $args) {
    if($args->theme_location == 'primary' && musiziya_get_option('navbar_search') ) {
        $sidebaroffc = '
        <li id="sidebar-offcanvas">
			 <a class="navbar-toggle" onclick="openNav2()">
				<i class="fa fa-bars" aria-hidden="true"></i>
			</a>
        </li>';
        $items .= $sidebaroffc;
    }
    return $items;
}
add_filter('wp_nav_menu_items', 'musiziya_add_sidebar_offc', 10, 2);

/**
    Add search box to Navigation menu
**/
function musiziya_add_search_box($items, $args) {
    if($args->theme_location == 'primary' && musiziya_get_option('navbar_search') ) {
        $searchlink = '
        <li id="search_dropdown">
			<a href="#searchmenu" class=" "> <i class="fa fa-search"></i> </a>
               
            <ul id="searchmenu" class="top-search-row">
				<li class="top-search-cell">
					<span class="close"> </span>

					<form class="searchmenu-navbar-form" role="search" action="'. esc_url( get_home_url( '/' ) ) . '">     
						<div class="input-group tpsrc">
							 
							<input type="text" name="s" class="searchmenu-popup" value="" placeholder="' . sprintf (esc_attr__('Search', 'musiziya') ) . '"/> 					
						</div>
							<button class="searchbtncc ribbon"><i class="fa fa-search"></i></button>
					</form>
				</li>
			</ul>
        </li>';
        $items .= $searchlink;
    }
    return $items;
}
add_filter('wp_nav_menu_items', 'musiziya_add_search_box', 10, 2);


/**
    Register widgetized area and update sidebar with default widgets
**/

function musiziya_widgets_init() {

  // add sidebars
  register_sidebar( array(
    'name'          => esc_html__( 'Posts Sidebar', 'musiziya' ),
    'id'            => 'sidebar',
    'description'   => esc_html__('The default sidebar, place widgets here will show in all posts', 'musiziya'),
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="widget-title">',
    'after_title'   => '</h4>',
   ) );
  register_sidebar( array(
    'name'          => esc_html__( 'Pages Sidebar', 'musiziya' ),
    'id'            => 'sidebar-2',
    'description'   => esc_html__('The second sidebar, place widgets here will show in all pages','musiziya'),
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="widget-title">',
    'after_title'   => '</h4>',
   ) ); 
  register_sidebar( array(
    'name'          => esc_html__( 'Blog page Sidebar', 'musiziya' ),
    'id'            => 'sidebar-3',
    'description'   => esc_html__('The second sidebar, place widgets here will show in all pages','musiziya'),
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="widget-title">',
    'after_title'   => '</h4>',
   ) ); 
   
register_sidebar( array(
    'name'          => esc_html__( 'Shop', 'musiziya' ),
    'id'            => 'shop-woo',
    'description'   => esc_html__('Shop sidebar','musiziya'),
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="widget-title">',
    'after_title'   => '</h4>',
   ) ); 
   register_sidebar( array(
    'name'          => esc_html__( 'Single Product', 'musiziya' ),
    'id'            => 'single-product-woo',
    'description'   => esc_html__('Single Product','musiziya'),
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="widget-title">',
    'after_title'   => '</h4>',
   ) ); 
 
register_sidebar( array(
    'name'          => esc_html__( 'Offcanvas', 'musiziya' ),
    'id'            => 'off-sidebar',
    'description'   => esc_html__('Offcanvas sidebar','musiziya'),
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="widget-title">',
    'after_title'   => '</h4>',
   ) );

  // add footer widgets
  switch (musiziya_get_option('footer_col')) {
  
    case '1':
    register_sidebar(array(
     'name'          => esc_html__( 'Footer Widget 1', 'musiziya' ),
     'id'            => 'footer-widget-1',
     'description'   => esc_html__('The first Row of Footer Widgets, place widgets as per no. of footer widgets setting you set in Theme Options', 'musiziya'),
     'before_widget' => '<div class="footer-widgets col-md-12 %2$s" id="%1$s">',
     'after_widget'  => '</div>',
     'before_title'  => '<h4 class="footer-widget-title">',
     'after_title'   => '</h4>',
     ) );
    break;

    case '2':
    register_sidebar(array(
     'name'          => esc_html__( 'Footer Widget 1', 'musiziya' ),
     'id'            => 'footer-widget-1',
     'description'   => esc_html__('The first Row of Footer Widgets, place widgets as per no. of footer widgets setting you set in Theme Options', 'musiziya'),
     'before_widget' => '<div class="footer-widgets col-md-6 %2$s" id="%1$s">',
     'after_widget'  => '</div>',
     'before_title'  => '<h4 class="footer-widget-title">',
     'after_title'   => '</h4>',
     ) );
    break;

    case '3':
    register_sidebar(array(
     'name'          => esc_html__( 'Footer Widget 1', 'musiziya' ),
     'id'            => 'footer-widget-1',
     'description'   => esc_html__('The first Row of Footer Widgets, place widgets as per no. of footer widgets setting you set in Theme Options', 'musiziya'),
     'before_widget' => '<div class="footer-widgets col-md-4 %2$s" id="%1$s">',
     'after_widget'  => '</div>',
     'before_title'  => '<h4 class="footer-widget-title">',
     'after_title'   => '</h4>',
     ) );
    break;

    case '4':
    register_sidebar(array(
     'name'          => esc_html__( 'Footer Widget 1', 'musiziya' ),
     'id'            => 'footer-widget-1',
     'description'   => esc_html__('The first Row of Footer Widgets, place widgets as per no. of footer widgets setting you set in Theme Options', 'musiziya'),
     'before_widget' => '<div class="footer-widgets col-md-3 %2$s" id="%1$s">',
     'after_widget'  => '</div>',
     'before_title'  => '<h4 class="footer-widget-title">',
     'after_title'   => '</h4>',
     ) );
    break;
  }

}

add_action( 'widgets_init', 'musiziya_widgets_init' );

/*Comments*/


if ( ! function_exists( 'musiziya_comment' ) ) {
	function musiziya_comment( $comment, $args, $depth )
	{
		$GLOBALS['comment'] = $comment;

		switch ( $comment->comment_type ):
			case 'pingback':
			case 'trackback': ?>
				<div class="pingback">
					<div class="inside-pb">
						<span><?php esc_html_e( 'Pingback:', 'musiziya' ); ?> </span> 
						<div><?php comment_author_link(); ?></div>
						<?php edit_comment_link( esc_html__( '(Edit)', 'musiziya' ), '<span class="edit-link">', '</span>' ); ?>
					</div>
				</div>
				<?php
				break;
			default: ?>
				<li <?php comment_class('musiziya-sec'); ?> id="li-comment-<?php comment_ID(); ?>">
					<div class="comment row" id="comment-<?php comment_ID(); ?>">
						<div class="col-sm-2">
							<?php echo get_avatar( $comment, 110, '', '', array( 'class' => 'img-responsive' ) ); ?>
						</div>
						<div class="comment-body col-sm-10">
							<div class="title-ccc"><?php comment_author(); ?></div>
							<div class="footer-desc">
							<?php comment_text(); ?>
							</div>
							<div class="footer-comm">
								<span class="comm-dat"><?php comment_date( get_option('date_format') );?></span>
								<span>
								<?php comment_reply_link(
									array_merge( $args,
										array(
											'reply_text' => esc_html__( 'Reply', 'musiziya' ),
											'after' 	 => '',
											'depth' 	 => $depth,
											'max_depth'  => $args['max_depth']
										)
									)
								); ?>
								</span>
							</div>
						</div>
						
					</div>
					</li>
			<?php
			break;
		endswitch;
	}
}


/*Gutenberg*/


function musiziya_gutenberg_editor_palette_styles() {
    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'strong red', 'musiziya' ),
            'slug' => 'strong-red',
            'color' => '#47f0f2',
        ),
        array(
            'name' => esc_html__( 'strong white', 'musiziya' ),
            'slug' => 'strong-white',
            'color' => '#fff',
        ),
		array(
            'name' => esc_html__( 'light black', 'musiziya' ),
            'slug' => 'light-black',
            'color' => '#221b3c',
        ),
        array(
            'name' => esc_html__( 'very light gray', 'musiziya' ),
            'slug' => 'very-light-gray',
            'color' => '#797979',
        ),
        array(
            'name' => esc_html__( 'very dark black', 'musiziya' ),
            'slug' => 'very-dark-black',
            'color' => '#000000',
        ),
    ) );

		// Add custom editor font sizes.
		add_theme_support( 'editor-font-sizes', array(
				array(
					'name'      => esc_html__( 'Small', 'musiziya' ),
					'size'      => 14,
					'slug'      => 'small',
				),
				array(
					'name'      => esc_html__( 'Normal', 'musiziya' ),
					'size'      => 16,
					'slug'      => 'normal',
				),
				array(
					'name'      => esc_html__( 'Large', 'musiziya' ),
					'size'      => 40,
					'slug'      => 'large',
				),
				array(
					'name'      => esc_html__( 'Huge', 'musiziya' ),
					'size'      => 50,
					'slug'      => 'huge',
				),
			)
		);
}
add_action( 'after_setup_theme', 'musiziya_gutenberg_editor_palette_styles' );

function musiziya_theme_add_editor_styles() {
    add_editor_style( 'custom-editor-style.css' );
}
add_action( 'admin_init', 'musiziya_theme_add_editor_styles' );