<?php
/**
 * The template part for selected header
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$social_icons = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'social_icons' ) : '';

$slider_enabled = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( get_the_ID(), 'slider_id', false ) : false;
$header_class = ( is_front_page() && $slider_enabled ) ? 'header_transparent' : 'background_cover';

$header_button_label = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'header_button_label' ) : '';
$header_button_link = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'header_button_link' ) : '';
?>

<section class="page_topline ds table_section table_section_sm section_padding_top_10 section_padding_bottom_10">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-6 text-center text-sm-left">
	            <?php if ( ! empty( $social_icons ) ) : ?>
                    <span class="small-text rightpadding_20">follow us:</span>
		            <?php
		            //get icons-social shortcode to render icons in team member item
		            $shortcodes_extension = fw()->extensions->get( 'shortcodes' );
		            if ( ! empty( $shortcodes_extension ) ) {
			            echo fw_ext( 'shortcodes' )->get_shortcode( 'icons_social' )->render( array( 'social_icons' => $social_icons ) );
		            }
		            ?>
	            <?php endif; //social icons ?>
            </div>
            <div class="col-sm-6 text-center text-sm-right">
                <div class="inline-content small-text greylinks">
		            <?php if ( class_exists( 'WooCommerce' ) ) : ?>

                        <div>
				            <?php if ( ! is_user_logged_in() ) : ?>
                                <a href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>"><?php echo esc_html__( 'Login / Register', 'flicker' ); ?>
                                </a>
				            <?php else: ?>
                                <a href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>"><?php echo esc_html__( 'My account', 'flicker' ); ?>
                                </a>
				            <?php endif; ?>
                        </div>

                        <div>
                            <a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="cart-button">
					            <?php if ( WC()->cart->get_cart_contents_count() ) : ?>
                                    <i class="fa fa-shopping-basket" aria-hidden="true"></i>
						            <?php
						            echo '<span class="total-price">' . WC()->cart->get_cart_subtotal() . '</span>';
					            else: ?>
                                    <i class="fa fa-shopping-basket empty" aria-hidden="true"></i>
					            <?php endif; ?>
                            </a>
                        </div>
		            <?php endif; ?>

                    <div class="dropdown inline-block">
                        <a href="" id="search-dropdown" class="square_button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fa fa-search" aria-hidden="true"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="search-dropdown">
                            <span id="serch-dropdown-close">
                                <i class="fa fa-times" aria-hidden="true"></i>
                            </span>
                            <div class="widget widget_search">
                                <?php get_search_form(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<header class="page_header header_darkgrey toggler_xs_right tall_header <?php echo esc_html( $header_class ); ?>">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12 display_table">
                <div class="header_left_logo display_table_cell">
	                <?php get_template_part( 'template-parts/header/header-logo' ); ?>
                </div>

                <div class="header_mainmenu display_table_cell text-center">
                    <nav class="mainmenu_wrapper primary-navigation">
		                <?php wp_nav_menu( array(
			                'theme_location' => 'primary',
			                'menu_class'     => 'sf-menu nav-menu nav',
			                'container'      => 'ul'
		                ) ); ?>
                    </nav>
                    <!-- header toggler -->
                    <span class="toggle_menu"><span></span></span>
                </div>

                <div class="header_right_buttons display_table_cell text-right hidden-xs">
                    <?php if ( $header_button_label && $header_button_link ) : ?>
                        <a href="<?php echo esc_html( $header_button_link ); ?>" class="theme_button color1"><?php echo esc_html( $header_button_label ); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</header>