<?php
/**
 * The default template for displaying event content
 *
 * Used for both single and index/archive/search.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;

$event_meta = fw_get_db_post_option( get_the_ID(), fw()->extensions->get( 'events' )->get_event_option_id() );
$event_full_meta = fw_get_db_post_option( get_the_ID() );

$event_date = $event_meta['event_children'][0]['event_date_range'];
$event_location = !empty( $event_meta['event_location']['city'] ) ? $event_meta['event_location']['city'] : $event_meta['event_location']['address'];
$time_start = date( get_option('time_format'), strtotime( $event_date['from']) );
$time_end = date( get_option('time_format'), strtotime( $event_date['to']) );

$buy_tickets_link = !empty( $event_full_meta['buy-tickets-link'] ) ? $event_full_meta['buy-tickets-link'] : '';
$ticket_price = !empty( $event_full_meta['ticket-price'] ) ? $event_full_meta['ticket-price'] : '';

//single item layout
if ( is_singular() ) :
	//part of template for single event layout is overriden in framework-customizations/extensions/events/views/single.php
	?>

	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php flicker_post_thumbnail(); ?>

		<header class="entry-header">

			<div class="entry-meta item-meta">
				<?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) && flicker_categorized_blog() ) : ?>
					<span
						class="categories-links"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'flicker' ) ); ?></span>
					<?php
				endif;

				if ( 'post' == get_post_type() ) {
					flicker_posted_on();
				}
				?>
			</div><!-- .entry-meta -->

			<h1 class="entry-title"><?php the_title(); ?></h1>

		</header><!-- .entry-header -->

		<div class="entry-content">
			<?php
			the_content( esc_html__( 'Read More', 'flicker' ) );
			?>
		</div><!-- .entry-content -->

		<?php the_tags( '<footer class="entry-meta"><span class="tag-links categories-links theme_buttons small_buttons color1">', ' ', '</span></footer>' ); ?>

		<?php
		wp_link_pages( array(
			'before'      => '<div class="page-links topmargin_30"><span class="page-links-title">' . esc_html__( 'Pages:', 'flicker' ) . '</span>',
			'after'       => '</div>',
			'link_before' => '<span>',
			'link_after'  => '</span>',
		) );
		?>

	</article><!-- #post-## -->

	<?php
//eof single page layout
//blog feed layout
else:
	$options = ( function_exists( 'fw_get_db_post_option' ) ) ? fw_get_db_post_option( $post->ID, fw()->extensions->get( 'events' )->get_event_option_id() ) : false;

	//layout for events in feed is always two columns if it has a featured image
	$small_layout = ( ! $show_post_thumbnail ) ? false : true;
	if ( $small_layout ) : //additional markup for small layout post
		?>

		<article id="post-<?php the_ID(); ?>" <?php post_class( 'with_background rounded overflow_hidden ' ); ?>>
		<div class="side-item side-md content-padding">
		<div class="row">
        <div class="col-md-5">
            <div class="item-media-wrap">
                <div class="item-media mutted-media ds">
                    <?php the_post_thumbnail( 'flicker-small-width' ); ?>
	                <?php if ( $ticket_price ) : ?>
                        <div class="entry-meta-corner grey">
                            <span class="small-text"><?php echo esc_html__( 'from', 'flicker' ); ?></span>
                            <span class="big"><?php echo esc_html( $ticket_price ); ?></span>
                            <span class="small-text"><?php echo esc_html__( 'per ticket', 'flicker' ); ?></span>
                        </div>
	                <?php endif; ?>
                </div>
            </div>
        </div>
		<div class="col-md-7">

	<?php else : //standard layout markup ?>
		<article id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item content-padding with_background rounded overflow_hidden' ); ?>>
		<?php
		flicker_post_thumbnail();
	endif; //small_format check
	?>
	<div class="item-content entry-content">
		<header class="entry-header bottommargin_20">
			<?php
			the_title( '<h3 class="entry-title bottommargin_0"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
			?>
            <p class="small-text bottommargin_0">
				<?php echo date( get_option('date_format'), strtotime( $event_date['from']) ) . ' / ' . $time_start . ' / ' . $event_location; ?>
            </p>
		</header><!-- .entry-header -->

		<?php if ( is_search() ) : ?>
			<div class="entry-summary">
				<?php the_excerpt(); ?>
			</div><!-- .entry-summary -->
		<?php else : ?>
			<div class="entry-content">
				<?php
				//hidding "more link" in content
				the_excerpt();

				//categories
				if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) && flicker_categorized_blog() ) :
					?>
					<div
						class="categories-links topmargin_20"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'flicker' ) ); ?></div>
				<?php endif; //categories

				wp_link_pages( array(
					'before'      => '<div class="page-links topmargin_30"><span class="page-links-title">' . esc_html__( 'Pages:', 'flicker' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '<span>',
					'link_after'  => '</span>',
				) );

				?>

                <div class="topmargin_20 event_buttons">
					<?php if ( $buy_tickets_link ) : ?>
                        <a href="<?php the_permalink(); ?>" class="theme_button color2 buy_tickets_button"><?php echo esc_html__( 'Buy Tickets', 'flicker' ); ?></a>
					<?php endif; ?>
                    <a href="<?php the_permalink(); ?>" class="theme_button inverse"><?php echo esc_html__( 'Read More', 'flicker' ); ?></a>
                </div>
			</div><!-- .entry-content -->
		<?php endif; ?>

		<?php

		//not showing tags in feed
		//the_tags( '', '' ); 
		?>
	</div><!-- eof .item-content -->
	<?php if ( $small_layout ) : //additional markup for small format post  ?>
	</div><!-- eof .col-md-6 -->
	</div><!-- eof .row -->
	</div><!-- eof .side-item -->
<?php endif; //small_format 
	?>
	</article><!-- #post-## -->

<?php endif;  //is singular ?>