<?php
/**
 * The default template for displaying aside content
 *
 * Used for both single and index/archive/search.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;

//single item layout
if ( is_singular() ) :
	?>
	<article id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item content-padding big-padding with_background rounded overflow_hidden' ); ?>>
		<?php flicker_post_thumbnail(); ?>

        <div class="item-content">
            <header class="entry-header">

				<?php if ( is_sticky() && is_home() && ! is_paged() ) {
					echo '<div class="featured-post grey"><i class="rt-icon2-clip highlight"></i>' . esc_html__( ' Sticky: ', 'flicker' ) . '</div>';
				} ?>

                <div class="entry-meta small-text content-justify vertical-center">
					<?php
					if ( 'post' == get_post_type() ) {
						flicker_posted_on( true );
					} ?>
					<?php flicker_share_this(); ?>
                </div>

                <hr>

                <div class="entry-meta">
					<?php
					printf( '<a href="%1$s">%2$s <span>%3$s</span></a>',
						esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
						esc_html__( 'By:', 'flicker' ),
						get_the_author()
					);
					?>
					<?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>
                        / <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ', ', 'Used between list items, there is a space after the comma.', 'flicker' ) ); ?></span>

					<?php endif; ?>
					<?php if ( comments_open() ) : ?>
                        / <a href="<?php comments_link(); ?>">
                            <span class="value"><?php comments_number( "0 comments", "1 comment", "% comments" ); ?></span>
                        </a>
					<?php else: ?>
                        / <span>
                    <span><?php echo esc_html__( 'Comments closed', 'flicker' ); ?></span>
                </span>
					<?php endif; ?>
                </div>

            </header><!-- .entry-header -->

			<?php if ( !empty( get_the_content() ) ) : ?>
                <div class="entry-content">
					<?php
					the_content( esc_html__( 'Read More', 'flicker' ) );
					?>
                </div><!-- .entry-content -->
			<?php endif; //has content ?>

			<?php
			the_tags( '<div class="tag-links topmargin_30">', ' ', '</div>' );

			wp_link_pages( array(
				'before'      => '<div class="page-links highlightlinks topmargin_30"><span class="page-links-title">' . esc_html__( 'Pages:', 'flicker' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
			) );
			?>
        </div>

	</article><!-- #post-## -->

	<?php
	flicker_post_nav();
	flicker_related_posts();
	flicker_list_authors();
	?>
<?php
//eof single page layout
//blog feed layout
else:
	?>
	<article id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item content-padding big-padding offset_button with_background rounded' ); ?>>
        <div class="item-content entry-content">

            <header class="entry-header">

				<?php if ( is_sticky() && is_home() && ! is_paged() ) {
					echo '<div class="featured-post grey"><i class="rt-icon2-clip highlight"></i>' . esc_html__( ' Sticky: ', 'flicker' ) . '</div>';
				} ?>

                <div class="entry-meta small-text content-justify vertical-center">
					<?php
					if ( 'post' == get_post_type() ) {
						flicker_posted_on( true );
					} ?>
					<?php flicker_share_this(); ?>
                </div>

				<?php
				the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
				?>

                <hr>

                <div class="entry-meta">
					<?php
					printf( '<a href="%1$s">%2$s <span>%3$s</span></a>',
						esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
						esc_html__( 'By:', 'flicker' ),
						get_the_author()
					);
					?>
					<?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>
                        / <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ', ', 'Used between list items, there is a space after the comma.', 'flicker' ) ); ?></span>

					<?php endif; ?>
					<?php if ( comments_open() ) : ?>
                        / <a href="<?php comments_link(); ?>">
                            <span class="value"><?php comments_number( "0 comments", "1 comment", "% comments" ); ?></span>
                        </a>
					<?php else: ?>
                        / <span>
                    <span><?php echo esc_html__( 'Comments closed', 'flicker' ); ?></span>
                </span>
					<?php endif; ?>
                </div>



            </header><!-- .entry-header -->

			<?php if ( !empty( get_the_content() ) ) : ?>
				<?php if ( is_search() ) : ?>
                    <div class="entry-summary">
						<?php the_excerpt(); ?>
                    </div><!-- .entry-summary -->
				<?php else : ?>
                    <div class="entry-content">
						<?php
						//hidding "more link" in content
						the_content( esc_html__( 'Read More', 'flicker' ) );

						wp_link_pages( array(
							'before'      => '<div class="page-links highlightlinks topmargin_30"><span class="page-links-title">' . esc_html__( 'Pages:', 'flicker' ) . '</span>',
							'after'       => '</div>',
							'link_before' => '<span>',
							'link_after'  => '</span>',
						) );
						?>

                    </div><!-- .entry-content -->

				<?php endif; //is_search
			endif; //has content
			?>

            <span class="button_wrap topmargin_20">
            <a href="<?php the_permalink(); ?>" class="theme_button color1"><?php echo esc_html__( 'Read More', 'flicker' ); ?></a>
        </span>
        </div><!-- eof .item-content -->

	</article><!-- #post-## -->
<?php endif;  //is singular