<?php
/**
 * The template part for selected title (breadcrubms) section
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>
<section class="page_breadcrumbs ls section_padding_top_25 section_padding_bottom_25 table_section table_section_md">
	<div class="container">
		<div class="row">
            <div class="col-md-8 text-center text-md-left">
                <h2 class="highlight">
		            <?php
		            get_template_part( 'template-parts/breadcrumbs/page-title-text' );
		            ?>
                </h2>
            </div>
			<div class="col-md-4 text-center text-md-right">
				<?php
				if ( function_exists( 'woocommerce_breadcrumb123' ) ) {
					woocommerce_breadcrumb( array(
						'delimiter'   => '',
						'wrap_before' => '<nav class="woocommerce-breadcrumb" ' . ( is_single() ? 'itemprop="breadcrumb"' : '' ) . '><ol class="breadcrumb big-spacing darklinks">',
						'wrap_after'  => '</ol></nav>',
						'before'      => '<li>',
						'after'       => '</li>',
						'home'        => esc_html_x( 'Home', 'breadcrumb', 'flicker' )
					) );
				} elseif ( function_exists( 'fw_ext_breadcrumbs' ) ) {
					fw_ext_breadcrumbs();
				}
				?>
			</div>
		</div>
	</div>
</section>