<?php
/**
 * The template for displaying image attachments
 */

get_header();

// Retrieve attachment metadata.
$metadata       = wp_get_attachment_metadata();
$column_classes = flicker_get_columns_classes(); ?>
	<div id="content" class="<?php echo esc_attr( $column_classes['main_column_class'] ); ?> content-area image-attachment">
		<?php
		// Start the Loop.
		while ( have_posts() ) : the_post();
			?>
			<article id="post-<?php the_ID(); ?>" <?php post_class("with_padding big-padding with_background rounded"); ?>>
				<div class="entry-content">
					<div class="entry-attachment bottommargin_30">
						<div class="attachment">
							<?php flicker_the_attached_image(); ?>
						</div><!-- .attachment -->

						<?php if ( has_excerpt() ) : ?>
							<div class="entry-caption">
								<?php the_excerpt(); ?>
							</div><!-- .entry-caption -->
						<?php endif; ?>
					</div><!-- .entry-attachment -->
					<header class="entry-header">

                        <div class="entry-meta small-text content-justify vertical-center">
							<?php flicker_posted_on( true ); ?>
							<?php flicker_share_this(); ?>
                        </div>

                        <hr>

                        <div class="entry-meta">
							<?php
							printf( '<a href="%1$s">%2$s <span>%3$s</span></a>',
								esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
								esc_html__( 'By:', 'flicker' ),
								get_the_author()
							);
							?>
                            <span>/
	                        <?php esc_html_e( 'in', 'flicker' ); ?> <span class="parent-post-link highlightlinks"><a href="<?php echo esc_url( get_permalink( $post->post_parent ) ); ?>"><?php echo get_the_title( $post->post_parent ); ?></a></span>
                            </span>
							<?php if ( comments_open() ) : ?>
                                / <a href="<?php comments_link(); ?>">
                                    <span class="value"><?php comments_number( "0 comments", "1 comment", "% comments" ); ?></span>
                                </a>
							<?php else: ?>
                                / <span>
                                <span><?php echo esc_html__( 'Comments closed', 'flicker' ); ?></span>
                                </span>
							<?php endif; ?>
                        </div>

					</header><!-- .entry-header -->
					<?php
					the_content();
					wp_link_pages( array(
						'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'flicker' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
					) );
					?>

                    <div class="full-size-link categories-links theme_buttons small_buttons color1 topmargin_20"><a href="<?php echo esc_url( wp_get_attachment_url() ); ?>"><?php echo esc_html( $metadata['width'] ); ?> &times; <?php echo esc_html( $metadata['height'] ); ?></a></div>
				</div><!-- .entry-content -->
			</article><!-- #post-## -->

            <nav id="image-navigation" class="row columns_padding_5 page-nav small-text">
                <div class="col-xs-6">
	                <?php previous_image_link( false, '<div class="previous-imag nav-item text-center main_bg_color rounded">' . esc_html__( 'Previous Image', 'flicker' ) . '</div>' ); ?>
                </div>
                <div class="col-xs-6">
	                <?php next_image_link( false, '<div class="next-image nav-item text-center main_bg_color rounded">' . esc_html__( 'Next Image', 'flicker' ) . '</div>' ); ?>
                </div>
            </nav>

			<?php comments_template(); ?>

		<?php endwhile; // end of the loop. ?>
	</div><!--eof #content -->
<?php if ( $column_classes['sidebar_class'] ): ?>
	<!-- main aside sidebar -->
	<aside class="<?php echo esc_attr( $column_classes['sidebar_class'] ); ?>">
		<?php get_sidebar(); ?>
	</aside>
	<!-- eof main aside sidebar -->
	<?php
endif;
get_footer();