<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}
/**
 * Theme functions and definitions
 *
 * Set up the theme and provides some helper functions, which are used in the
 * theme as custom template tags. Others are attached to action and filter
 * hooks in WordPress to change core functionality.
 *
 * When using a child theme you can override certain functions (those wrapped
 * in a function_exists() call) by defining them first in your child theme's
 * functions.php file. The child theme's functions.php file is included before
 * the parent theme's file, so the child theme functions would be used.
 *
 * @link https://codex.wordpress.org/Theme_Development
 * @link https://codex.wordpress.org/Child_Themes
 *
 * Functions that are not pluggable (not wrapped in function_exists()) are
 * instead attached to a filter or action hook.
 *
 * For more information on hooks, actions, and filters,
 * {@link https://codex.wordpress.org/Plugin_API}
 */

define('FLICKER_THEME_VERSION', '1.1.0');

//Since WP v4.7 using new functions
//https://developer.wordpress.org/themes/basics/linking-theme-files-directories/#linking-to-theme-directories
define( 'FLICKER_THEME_URI', get_parent_theme_file_uri() );
define( 'FLICKER_THEME_PATH', get_parent_theme_file_path() );

// You may request this demo id from this theme author to get a colorized demo content.
// See the Theme support service contacts information.
define( 'FLICKER_REMOTE_DEMO_ID', '58694328');
define( 'FLICKER_REMOTE_DEMO_VERSION', '1.0.0');

/**
 * Theme Includes
 *
 * https://github.com/ThemeFuse/Theme-Includes
 */
require_once FLICKER_THEME_PATH . '/inc/init.php';

/**
 * TGM Plugin Activation
 */
require_once FLICKER_THEME_PATH . '/inc/tgm-plugin-activation/class-tgm-plugin-activation.php';

if ( ! function_exists( 'flicker_action_register_required_plugins' ) ):
	/** @internal */
	function flicker_action_register_required_plugins() {
		tgmpa( array (
			array (
				'name'             => 'Unyson',
				'slug'             => 'unyson',
				'required'         => true,
			),
			array(
				'name'             => 'MWTemplates Unyson Extensions',
				'slug'             => 'mwt-unyson-extensions',
				'source'           => 'http://webdesign-finder.com/flicker/plugins/mwt-unyson-extensions.zip',
				'required'         => true,
				'version'          => '1.1',
			),
			array (
				'name'             => 'MWTemplates Theme Addons',
				'slug'             => 'mwt-addons',
				'source'           => 'http://webdesign-finder.com/flicker/plugins/mwt-addons.zip',
				'required'         => true,
				'version'          => '1.1',
			),
			array (
				'name'             => 'MWTemplates Theme Widgets',
				'slug'             => 'mwt-widgets',
				'source'           => 'http://webdesign-finder.com/flicker/plugins/mwt-widgets.zip',
				'required'         => true,
				'version'          => '1.1',
			),
			array (
				'name'             => 'MailChimp',
				'slug'             => 'mailchimp-for-wp',
				'required'         => true,
			),
			array (
				'name'             => 'Contact Form 7',
				'slug'             => 'contact-form-7',
				'required'         => true,
			),
			array (
				'name'             => 'Envato Market',
				'slug'             => 'envato-market',
				'source'           => esc_url('https://envato.github.io/wp-envato-market/dist/envato-market.zip'),
				'required'         => true,
			),
			array(
				'name'     		   => 'AccessPress Social Counter',
				'slug'     		   => 'accesspress-social-counter',
				'required'         => false
			),
			array(
				'name'     		   => 'Instagram Feed',
				'slug'     		   => 'instagram-feed',
				'required'         => false
			),
			array(
				'name'     		   => 'Cue',
				'slug'     		   => 'cue',
				'required'         => false
			),
			array (
				'name'             => 'Snazzy Maps',
				'slug'             => 'snazzy-maps',
				'source'           => 'http://webdesign-finder.com/remote-demo-content/common-plugins-original/snazzy-maps.1.1.5.zip',
				'required'         => false,
				'version'          => '1.1.5',
			),
			array(
				'name'     		   => 'WooCommerce',
				'slug'     		   => 'woocommerce',
				'required'         => false
			),
		),
		array(
			'domain'       => 'flicker',
			'dismissable'  => false,
		) );
	}
endif;

//changing team post name
if ( ! function_exists( 'flicker_filter_fw_ext_team_post_name' ) ) :
	function flicker_filter_fw_ext_team_post_name( $array ) {
		return array(
			'singular' => esc_html__( 'Member Profile', 'flicker' ),
			'plural'   => esc_html__( 'My Team', 'flicker' )
		);
	} //flicker_filter_fw_ext_team_post_name()
endif;
add_filter( 'fw_ext_team_post_type_name', 'flicker_filter_fw_ext_team_post_name' );

function flicker_action_flush_rewrite_rules() {
	flush_rewrite_rules();
}
add_action( 'fw:ext:backups:tasks:finish:id:demo-content-install', 'flicker_action_flush_rewrite_rules' );

//changing team post name
if ( ! function_exists( 'flicker_filter_fw_ext_team_post_name' ) ) :
	function flicker_filter_fw_ext_team_post_name( $array ) {
		return array(
			'singular' => esc_html__( 'Member Profile', 'flicker' ),
			'plural'   => esc_html__( 'My Team', 'flicker' )
		);
	} //flicker_filter_fw_ext_team_post_name()
endif;
add_filter( 'fw_ext_team_post_type_name', 'flicker_filter_fw_ext_team_post_name' );



