<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

//get button to add in a teaser:
$button         = fw_ext( 'shortcodes' )->get_shortcode( 'button' );
$button_options = $button->get_options();
unset( $button_options['link'] );
unset( $button_options['target'] );
$button_array = array(
	'button' => array(
		'type'    => 'multi-picker',
		'label'   => false,
		'desc'    => false,
		'value'   => false,
		'picker'  => array(
			'show_button' => array(
				'type'         => 'switch',
				'label'        => esc_html__( 'Show teaser button', 'flicker' ),
				'left-choice'  => array(
					'value' => '',
					'label' => esc_html__( 'No', 'flicker' ),
				),
				'right-choice' => array(
					'value' => 'button',
					'label' => esc_html__( 'Yes', 'flicker' ),
				),
			),
		),
		'choices' => array(
			''       => array(),
			'button' => $button_options,
		),
	)
);

$step_arrow = array(
	'step_arrow' => array(
		'type'    => 'multi-picker',
		'value'   => '',
		'picker'  => array(
			'show_step_arrow' => array(
				'type'         => 'switch',
				'label'        => esc_html__( 'Show step arrow', 'flicker' ),
				'left-choice'  => array(
					'value' => '',
					'label' => esc_html__( 'No', 'flicker' ),
				),
				'right-choice' => array(
					'value' => 'arrow',
					'label' => esc_html__( 'Yes', 'flicker' ),
				),
			),
		),
		'choices' => array(
			''       => array(),
			'arrow' => array(
				'arrow_color' => array(
					'type'    => 'select',
					'value'   => 'highlight',
					'label'   => esc_html__( 'Arrow Color', 'flicker' ),
					'choices' => array(
						'highlight'  => esc_html__( 'Accent Color 1', 'flicker' ),
						'highlight2' => esc_html__( 'Accent Color 2', 'flicker' ),
						'highlight3' => esc_html__( 'Accent Color 3', 'flicker' ),
					)
				),
				'arrow_type' => array(
					'type'    => 'select',
					'value'   => '',
					'label'   => esc_html__( 'Arrow Type', 'flicker' ),
					'choices' => array(
						''  => esc_html__( 'Normal', 'flicker' ),
						'up-side-down' => esc_html__( 'Up Side Dowm', 'flicker' ),
					)
				)
			),
		),
	)
);

$teaser_center_array = array(
	'teaser_center' => array(
		'type'         => 'switch',
		'value'        => '',
		'label'        => esc_html__( 'Center teaser contents', 'flicker' ),
		'left-choice'  => array(
			'value' => '',
			'label' => esc_html__( 'No', 'flicker' ),
		),
		'right-choice' => array(
			'value' => 'text-center',
			'label' => esc_html__( 'Yes', 'flicker' ),
		),
	),
);

$icon_options = array(
	'type'    => 'group',
	'options' => array(
		'icon'       => array(
			'type'  => 'icon',
			'label' => esc_html__( 'Choose an Icon', 'flicker' ),
			'set'   => 'rt-icons-2',
		),
		'icon_size'  => array(
			'type'    => 'select',
			'value'   => 'size_normal',
			'label'   => esc_html__( 'Icon Size', 'flicker' ),
			'choices' => array(
				'size_small'  => esc_html__( 'Small', 'flicker' ),
				'size_normal' => esc_html__( 'Normal', 'flicker' ),
				'size_big'    => esc_html__( 'Big', 'flicker' ),
			)
		),
		'icon_style' => array(
			'type'    => 'image-picker',
			'value'   => '',
			'label'   => esc_html__( 'Icon Style', 'flicker' ),
			'desc'    => esc_html__( 'Select one of predefined icon styles. If not set - no icon will appear.', 'flicker' ),
			'help'    => esc_html__( 'If not set - no icon will appear.', 'flicker' ),
			'choices' => array(
				''                            => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_00.png',
				'default_icon'                => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_01.png',
				'black'                       => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_02.png',
				'highlight'                   => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_03.png',
				'highlight2'                   => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_03_2.png',
				'highlight3'                   => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_03_3.png',
				'border_icon'                 => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_04.png',
				'black border_icon'           => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_05.png',
				'highlight border_icon'       => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_06.png',
				'highlight2 border_icon'       => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_06_2.png',
				'highlight3 border_icon'       => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_06_3.png',
				'main_bg_color'               => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_07.png',
				'main_bg_color2'               => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_07_2.png',
				'main_bg_color3'               => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_07_3.png',
				'dark_bg_color'               => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_08.png',
				'border_icon round'           => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_09.png',
				'black border_icon round'     => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_10.png',
				'highlight border_icon round' => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_11.png',
				'highlight2 border_icon round' => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_11_2.png',
				'highlight3 border_icon round' => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_11_3.png',
				'main_bg_color round'         => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_12.png',
				'main_bg_color2 round'         => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_12_2.png',
				'main_bg_color3 round'         => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_12_3.png',
				'dark_bg_color round'         => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_teaser_13.png',
			),

			'blank' => false, // (optional) if true, images can be deselected
		),
	),
);

$image_options = array(
	'type'        => 'upload',
	'value'       => '',
	'label'       => esc_html__( 'Teaser Image', 'flicker' ),
	'image'       => esc_html__( 'Image for your teaser.', 'flicker' ),
	'help'        => 'Image for your teaser. Image can appear as an element, or background or even can be hidden depends from chosen teaser type',
	'images_only' => true,
);

$option_teaser_icon = array(
	'icon_options' => $icon_options,
);

$option_teaser_image = array(
	'teaser_image' => $image_options,
);

$option_teaser_square = array(
	'teaser_image' => $image_options,
	'icon'         => array(
		'type'  => 'icon',
		'label' => esc_html__( 'Choose an Icon', 'flicker' ),
		'set'   => 'rt-icons-2',
	),
);

$option_teaser_counter = array(
	'icon_options'    => $icon_options,
	'counter_options' => array(
		'type'    => 'group',
		'options' => array(

			'number'                  => array(
				'type'  => 'text',
				'value' => 10,
				'label' => esc_html__( 'Count To Number', 'flicker' ),
				'desc'  => esc_html__( 'Choose value to count to', 'flicker' ),
			),
			'counter_additional_text' => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Add some text after counter', 'flicker' ),
				'desc'  => esc_html__( 'You can add "+", "%", decimal values etc.', 'flicker' ),
			),
			'speed'                   => array(
				'type'       => 'slider',
				'value'      => 1000,
				'properties' => array(
					'min'  => 500,
					'max'  => 5000,
					'step' => 100,
				),
				'label'      => esc_html__( 'Counter Speed (counter teaser only)', 'flicker' ),
				'desc'       => esc_html__( 'Choose counter speed (in milliseconds)', 'flicker' ),
			),
		),
	),
);

$options = array(
	'title'        => array(
		'type'  => 'text',
		'label' => esc_html__( 'Teaser Title', 'flicker' ),
	),
	'link'         => array(
		'type'  => 'text',
		'value' => '',
		'label' => esc_html__( 'Teaser link', 'flicker' ),
		'desc'  => esc_html__( 'Link on title and optional button', 'flicker' ),
	),
	'teaser_types' => array(
		'type'         => 'multi-picker',
		'label'        => false,
		'desc'         => false,
		'picker'       => array(
			'teaser_type' => array(
				'type'    => 'image-picker',
				'value'   => 'icon_top',
				'label'   => esc_html__( 'Teaser Type', 'flicker' ),
				'desc'    => esc_html__( 'Select one of predefined teaser types', 'flicker' ),
				'choices' => array(
					'icon_top'      => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_top.png',
					'icon_left'     => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_left.png',
					'icon_right'    => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_right.png',
					'image_top'     => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/image_top.png',
					'image_left'    => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/image_left.png',
					'image_right'   => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/image_right.png',
					'icon_image_bg' => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_image_bg.png',
					'counter'       => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/teaser/static/img/icon_counter.png',
				),
				'blank'   => false, // (optional) if true, images can be deselected
			),

		),
		'choices'      => array(
			'icon_top'      => array_merge( $option_teaser_icon, $teaser_center_array, $button_array, $step_arrow ),
			'icon_left'     => $option_teaser_icon,
			'icon_right'    => $option_teaser_icon,
			'image_top'     => array_merge( $option_teaser_image, $teaser_center_array, $button_array, $step_arrow ),
			'image_left'    => $option_teaser_image,
			'image_right'   => $option_teaser_image,
			'icon_image_bg' => $option_teaser_square,
			'counter'       => $option_teaser_counter
		),
		'show_borders' => true,
	),
	'teaser_style' => array(
		'type'    => 'select',
		'label'   => esc_html__( 'Teaser Box Style', 'flicker' ),
		'choices' => array(
			''                             => esc_html__( 'Default (no border or background)', 'flicker' ),
			'with_padding with_border'     => esc_html__( 'Bordered', 'flicker' ),
			'with_padding with_background' => esc_html__( 'Muted Background', 'flicker' ),
			'with_padding ls ms'           => esc_html__( 'Grey background', 'flicker' ),
			'with_padding ds'              => esc_html__( 'Dark background', 'flicker' ),
			'with_padding ds ms'           => esc_html__( 'Darkgrey background', 'flicker' ),
			'with_padding cs'              => esc_html__( 'Main color background', 'flicker' ),
		)
	),
	'content'      => array(
		'type'  => 'textarea',
		'label' => esc_html__( 'Teaser text', 'flicker' ),
		'desc'  => esc_html__( 'Enter desired teaser content', 'flicker' ),
	),

	'title_tag' => array(
		'type'    => 'select',
		'value'   => 'h3',
		'label'   => esc_html__( 'Title Tag', 'flicker' ),
		'choices' => array(
			'h2' => esc_html__( 'H2', 'flicker' ),
			'h3' => esc_html__( 'H3', 'flicker' ),
			'h4' => esc_html__( 'H4', 'flicker' ),
			'h5' => esc_html__( 'H5', 'flicker' ),
		)
	),

	'title_text_transform' => array(
		'type'    => 'select',
		'value'   => '',
		'label'   => esc_html__( 'Title text transform', 'flicker' ),
		'choices' => array(
			''                => esc_html__( 'None', 'flicker' ),
			'text-lowercase'  => esc_html__( 'Lowercase', 'flicker' ),
			'text-uppercase'  => esc_html__( 'Uppercase', 'flicker' ),
			'text-capitalize' => esc_html__( 'Capitalize', 'flicker' ),

		),
	),
);