<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'tabs'       => array(
		'type'          => 'addable-popup',
		'label'         => esc_html__( 'Tabs', 'flicker' ),
		'popup-title'   => esc_html__( 'Add/Edit Tabs', 'flicker' ),
		'desc'          => esc_html__( 'Create your tabs', 'flicker' ),
		'template'      => '{{=tab_title}}',
		'popup-options' => array(
			'tab_title'          => array(
				'type'  => 'text',
				'label' => esc_html__( 'Tab Title', 'flicker' )
			),
			'tab_content'        => array(
				'type'  => 'wp-editor',
				'label' => esc_html__( 'Tab Content', 'flicker' ),
			),
			'tab_featured_image' => array(
				'type'        => 'upload',
				'value'       => '',
				'label'       => esc_html__( 'Tab Featured Image', 'flicker' ),
				'image'       => esc_html__( 'Featured image for your tab', 'flicker' ),
				'help'        => esc_html__( 'Image for your tab. It appears on the top of your tab content', 'flicker' ),
				'images_only' => true,
			),
			'tab_icon'           => array(
				'type'  => 'icon',
				'label' => esc_html__( 'Icon in tab title', 'flicker' ),
				'set'   => 'rt-icons-2',
			),
		),
	),
	'small_tabs' => array(
		'type'         => 'switch',
		'value'        => '',
		'label'        => esc_html__( 'Small Tabs', 'flicker' ),
		'desc'         => esc_html__( 'Decrease tabs size', 'flicker' ),
		'left-choice'  => array(
			'value' => '',
			'label' => esc_html__( 'No', 'flicker' ),
		),
		'right-choice' => array(
			'value' => 'small-tabs',
			'label' => esc_html__( 'Yes', 'flicker' ),
		),
	),
	'top_border' => array(
		'type'         => 'switch',
		'value'        => '',
		'label'        => esc_html__( 'Top color border', 'flicker' ),
		'desc'         => esc_html__( 'Add top color border to tab content', 'flicker' ),
		'left-choice'  => array(
			'value' => '',
			'label' => esc_html__( 'No top border', 'flicker' ),
		),
		'right-choice' => array(
			'value' => 'top-color-border',
			'label' => esc_html__( 'Color top border', 'flicker' ),
		),
	),
	'id'         => array( 'type' => 'unique' ),
);