<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * Shortcode Posts - vertical item layout type 2
 */

$terms          = get_the_terms( get_the_ID(), 'category' );
$filter_classes = '';
foreach ( $terms as $term ) {
	$filter_classes .= ' filter-' . $term->slug;
}

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;

?>
<article <?php post_class( "vertical-item content-padding with_background rounded overflow_hidden text-center " . $filter_classes ); ?>>
	<?php flicker_post_thumbnail(); ?>
    <div class="item-content">
        <header class="entry-header">
			<?php
			the_title( '<h4 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
			?>
        </header><!-- .entry-header -->
    </div>

    <footer class="entry-footer greylinks small-text">
        <div class="inline-content">
	        <?php if ( function_exists( 'mwt_post_like_count' ) ) : ?>
                <span>
                    <i class="fa fa-heart rightpadding_5" aria-hidden="true"></i>
                    <span class="value"><?php flicker_post_like_count( get_the_ID() ); ?></span>
                </span>
	        <?php endif; ?>

	        <?php if ( comments_open() ) : ?>
                <a href="<?php comments_link(); ?>">
                    <i class="fa fa-comment rightpadding_5" aria-hidden="true"></i>
                    <span class="value"><?php comments_number( "0", "1", "%" ); ?></span>
                </a>
	        <?php else: ?>
                <span>
                <i class="fa fa-comment rightpadding_5" aria-hidden="true"></i>
                <span><?php echo esc_html__( 'Closed', 'flicker' ); ?></span>
            </span>
	        <?php endif; ?>
	        <?php if ( function_exists( 'mwt_show_post_views_count' ) ) : ?>
                <span>
                <i class="fa fa-eye rightpadding_5" aria-hidden="true"></i>
                <span class="value"><?php flicker_show_post_views_count(); ?></span>
            </span>
	        <?php endif; ?>
        </div>
    </footer>

</article><!-- eof vertical-item -->
