<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'number'        => array(
		'type'       => 'slider',
		'value'      => 6,
		'properties' => array(
			'min'  => 1,
			'max'  => 12,
			'step' => 1, // Set slider step. Always > 0. Could be fractional.

		),
		'label'      => esc_html__( 'Items number', 'flicker' ),
		'desc'       => esc_html__( 'Number of posts to display', 'flicker' ),
	),
	'margin'        => array(
		'label'   => esc_html__( 'Horizontal item margin (px)', 'flicker' ),
		'desc'    => esc_html__( 'Select horizontal item margin', 'flicker' ),
		'value'   => '30',
		'type'    => 'select',
		'choices' => array(
			'0'  => esc_html__( '0', 'flicker' ),
			'1'  => esc_html__( '1px', 'flicker' ),
			'2'  => esc_html__( '2px', 'flicker' ),
			'10' => esc_html__( '10px', 'flicker' ),
			'30' => esc_html__( '30px', 'flicker' ),
		)
	),
	'layout'        => array(
		'label'   => esc_html__( 'Post Layout', 'flicker' ),
		'desc'    => esc_html__( 'Choose post layout', 'flicker' ),
		'value'   => 'carousel',
		'type'    => 'select',
		'choices' => array(
			'carousel' => esc_html__( 'Carousel', 'flicker' ),
			'isotope'  => esc_html__( 'Masonry Grid', 'flicker' ),
		)
	),
	'item_layout'   => array(
		'label'   => esc_html__( 'Item layout', 'flicker' ),
		'desc'    => esc_html__( 'Choose Item layout', 'flicker' ),
		'value'   => 'item-regular',
		'type'    => 'select',
		'choices' => array(
			'item-horizontal'    => esc_html__( 'Horizontal item', 'flicker' ),
			'item-vertical' => esc_html__( 'Vertical item with excerpt', 'flicker' ),
			'item-vertical2' => esc_html__( 'Vertical item', 'flicker' ),
		)
	),
	'responsive_lg' => array(
		'label'   => esc_html__( 'Columns on large screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on wide screens (>1200px)', 'flicker' ),
		'value'   => '4',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
			'6' => esc_html__( '6', 'flicker' ),
		)
	),
	'responsive_md' => array(
		'label'   => esc_html__( 'Columns on middle screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on middle screens (>992px)', 'flicker' ),
		'value'   => '3',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
			'6' => esc_html__( '6', 'flicker' ),
		)
	),
	'responsive_sm' => array(
		'label'   => esc_html__( 'Columns on small screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on small screens (>768px)', 'flicker' ),
		'value'   => '2',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
			'6' => esc_html__( '6', 'flicker' ),
		)
	),
	'responsive_xs' => array(
		'label'   => esc_html__( 'Columns on extra small screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on extra small screens (<767px)', 'flicker' ),
		'value'   => '1',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
			'6' => esc_html__( '6', 'flicker' ),
		)
	),
	'show_filters'  => array(
		'type'         => 'switch',
		'value'        => false,
		'label'        => esc_html__( 'Show filters', 'flicker' ),
		'desc'         => esc_html__( 'Hide or show categories filters', 'flicker' ),
		'left-choice'  => array(
			'value' => false,
			'label' => esc_html__( 'No', 'flicker' ),
		),
		'right-choice' => array(
			'value' => true,
			'label' => esc_html__( 'Yes', 'flicker' ),
		),
	),
	'cat' => array(
		'type'  => 'multi-select',
		'label' => esc_html__('Select categories', 'flicker'),
		'desc'  => esc_html__('You can select one or more categories', 'flicker'),
		'population' => 'taxonomy',
		'source' => 'category',
		'prepopulate' => 10,
		'limit' => 100,
	)
);