<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'social_icons' => array(
		'type'            => 'addable-box',
		'value'           => '',
		'label'           => esc_html__( 'Social Buttons', 'flicker' ),
		'desc'            => esc_html__( 'Optional social buttons', 'flicker' ),
		'template'        => '{{=icon}}',
		'box-options'     => array(
			'icon'       => array(
				'type'  => 'icon',
				'label' => esc_html__( 'Social Icon', 'flicker' ),
				'set'   => 'social-icons',
			),
			'icon_class' => array(
				'type'        => 'select',
				'value'       => '',
				'label'       => esc_html__( 'Icon type', 'flicker' ),
				'desc'        => esc_html__( 'Select one of predefined social button types', 'flicker' ),
				'choices'     => array(
					''                                    => esc_html__( 'Default', 'flicker' ),
					'border-icon'                         => esc_html__( 'Simple Bordered Icon', 'flicker' ),
					'border-icon round-icon'            => esc_html__( 'Rounded Bordered Icon', 'flicker' ),
					'bg-icon'                             => esc_html__( 'Simple Background Icon', 'flicker' ),
					'bg-icon round-icon'                => esc_html__( 'Rounded Background Icon', 'flicker' ),
					'color-icon bg-icon'                  => esc_html__( 'Color Light Background Icon', 'flicker' ),
					'color-icon bg-icon round-icon'     => esc_html__( 'Color Light Background Rounded Icon', 'flicker' ),
					'color-icon'                          => esc_html__( 'Color Icon', 'flicker' ),
					'color-icon border-icon'              => esc_html__( 'Color Bordered Icon', 'flicker' ),
					'color-icon border-icon round-icon' => esc_html__( 'Rounded Color Bordered Icon', 'flicker' ),
					'color-bg-icon'                       => esc_html__( 'Color Background Icon', 'flicker' ),
					'color-bg-icon round-icon'          => esc_html__( 'Rounded Color Background Icon', 'flicker' ),

				),
				/**
				 * Allow save not existing choices
				 * Useful when you use the select to populate it dynamically from js
				 */
				'no-validate' => false,
			),
			'icon_url'   => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Icon Link', 'flicker' ),
				'desc'  => esc_html__( 'Provide a URL to your icon', 'flicker' ),
			)
		),
		'limit'           => 0, // limit the number of boxes that can be added
		'add-button-text' => esc_html__( 'Add', 'flicker' ),
		'sortable'        => true,
	),


);