<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$custom_column_classes = array(
	'custom_classes'    => array(
		'type'  => 'text',
		'label' => esc_html__( 'Custom column classes', 'flicker' ),
		'desc'  => esc_html__( 'Enter custom column classes', 'flicker' ),
	),
);

$options = array(
	'column_align'     => array(
		'type'    => 'select',
		'value'   => '',
		'label'   => esc_html__( 'Text alignment in column', 'flicker' ),
		'desc'    => esc_html__( 'Select text alignment inside your column', 'flicker' ),
		'choices' => array(
			''            => esc_html__( 'Inherit', 'flicker' ),
			'text-left'   => esc_html__( 'Left', 'flicker' ),
			'text-center' => esc_html__( 'Center', 'flicker' ),
			'text-right'  => esc_html__( 'Right', 'flicker' ),
		),
	),
	'column_padding'   => array(
		'type'    => 'select',
		'value'   => '',
		'label'   => esc_html__( 'Column padding', 'flicker' ),
		'desc'    => esc_html__( 'Select optional internal column paddings', 'flicker' ),
		'choices' => array(
			''           => esc_html__( 'No padding', 'flicker' ),
			'padding_10' => esc_html__( '10px', 'flicker' ),
			'padding_20' => esc_html__( '20px', 'flicker' ),
			'padding_30' => esc_html__( '30px', 'flicker' ),
			'padding_40' => esc_html__( '40px', 'flicker' ),
            'with_padding' => esc_html__( 'Theme style padding', 'flicker' ),

		),
	),
	'background_color' => array(
		'type'    => 'select',
		'value'   => '',
		'label'   => esc_html__( 'Background color', 'flicker' ),
		'desc'    => esc_html__( 'Select background color', 'flicker' ),
		'help'    => esc_html__( 'Select one of predefined background colors', 'flicker' ),
		'choices' => array(
			''               => esc_html__( 'Transparent (No Background)', 'flicker' ),
			'with_background'=> esc_html__( 'Highlight', 'flicker' ),
			'muted_background'=> esc_html__( 'Muted', 'flicker' ),
			'ds ms'          => esc_html__( 'Dark Grey', 'flicker' ),
			'ds'             => esc_html__( 'Dark', 'flicker' ),
			'cs'             => esc_html__( 'Main color', 'flicker' ),
			'cs main_color2' => esc_html__( 'Second Main color', 'flicker' ),
		),
	),
	'column_animation' => array(
		'type'    => 'select',
		'value'   => '',
		'label'   => esc_html__( 'Animation type', 'flicker' ),
		'desc'    => esc_html__( 'Select one of predefined animations', 'flicker' ),
		'choices' => array(
			''               => esc_html__( 'None', 'flicker' ),
			'slideDown'      => esc_html__( 'slideDown', 'flicker' ),
			'scaleAppear'    => esc_html__( 'scaleAppear', 'flicker' ),
			'fadeInLeft'     => esc_html__( 'fadeInLeft', 'flicker' ),
			'fadeInUp'       => esc_html__( 'fadeInUp', 'flicker' ),
			'fadeInRight'    => esc_html__( 'fadeInRight', 'flicker' ),
			'fadeInDown'     => esc_html__( 'fadeInDown', 'flicker' ),
			'fadeIn'         => esc_html__( 'fadeIn', 'flicker' ),
			'slideRight'     => esc_html__( 'slideRight', 'flicker' ),
			'slideUp'        => esc_html__( 'slideUp', 'flicker' ),
			'slideLeft'      => esc_html__( 'slideLeft', 'flicker' ),
			'expandUp'       => esc_html__( 'expandUp', 'flicker' ),
			'slideExpandUp'  => esc_html__( 'slideExpandUp', 'flicker' ),
			'expandOpen'     => esc_html__( 'expandOpen', 'flicker' ),
			'bigEntrance'    => esc_html__( 'bigEntrance', 'flicker' ),
			'hatch'          => esc_html__( 'hatch', 'flicker' ),
			'tossing'        => esc_html__( 'tossing', 'flicker' ),
			'pulse'          => esc_html__( 'pulse', 'flicker' ),
			'floating'       => esc_html__( 'floating', 'flicker' ),
			'bounce'         => esc_html__( 'bounce', 'flicker' ),
			'pullUp'         => esc_html__( 'pullUp', 'flicker' ),
			'pullDown'       => esc_html__( 'pullDown', 'flicker' ),
			'stretchLeft'    => esc_html__( 'stretchLeft', 'flicker' ),
			'stretchRight'   => esc_html__( 'stretchRight', 'flicker' ),
			'fadeInUpBig'    => esc_html__( 'fadeInUpBig', 'flicker' ),
			'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'flicker' ),
			'fadeInLeftBig'  => esc_html__( 'fadeInLeftBig', 'flicker' ),
			'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'flicker' ),
			'slideInDown'    => esc_html__( 'slideInDown', 'flicker' ),
			'slideInLeft'    => esc_html__( 'slideInLeft', 'flicker' ),
			'slideInRight'   => esc_html__( 'slideInRight', 'flicker' ),
			'moveFromLeft'   => esc_html__( 'moveFromLeft', 'flicker' ),
			'moveFromRight'  => esc_html__( 'moveFromRight', 'flicker' ),
			'moveFromBottom' => esc_html__( 'moveFromBottom', 'flicker' ),
		),
	),
	'custom_column' => array(
		'type'    => 'multi-picker',
		'label'   => false,
		'desc'    => false,
		'picker'  => array(
			'custom' => array(
				'type'         => 'switch',
				'label'        => esc_html__( 'Custom column layout', 'flicker' ),
				'desc'        => esc_html__( 'Set your own column classes. It overrides other options. Use it only if you know what are you doing', 'flicker' ),
				'left-choice'  => array(
					'value' => '',
					'label' => esc_html__( 'No', 'flicker' ),
				),
				'right-choice' => array(
					'value' => 'custom_cl',
					'label' => esc_html__( 'Yes', 'flicker' ),
				),
			),
		),
		'choices' => array(
			''       => array(),
			'custom_cl' => $custom_column_classes,
		),
        'show_borders' => true,
	)

);
