<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'main' => array(
		'type'    => 'box',
		'title'   => '',
		'options' => array(
			'id'       => array(
				'type' => 'unique',
			),
			'builder'  => array(
				'type'    => 'tab',
				'title'   => esc_html__( 'Form Fields', 'flicker' ),
				'options' => array(
					'form' => array(
						'label'        => false,
						'type'         => 'form-builder',
						'value'        => array(
							'json' => apply_filters( 'fw:ext:forms:builder:load-item:form-header-title', true )
								? json_encode( array(
									array(
										'type'      => 'form-header-title',
										'shortcode' => 'form_header_title',
										'width'     => '',
										'options'   => array(
											'title'    => '',
											'subtitle' => '',
										)
									)
								) )
								: '[]'
						),
						'fixed_header' => true,
					),
				),
			),
			'settings' => array(
				'type'    => 'tab',
				'title'   => esc_html__( 'Settings', 'flicker' ),
				'options' => array(
					'settings-options' => array(
						'title'   => esc_html__( 'Contact Form Options', 'flicker' ),
						'type'    => 'tab',
						'options' => array(
							'background_color'    => array(
								'type'    => 'select',
								'value'   => 'ls',
								'label'   => esc_html__( 'Form Background color', 'flicker' ),
								'desc'    => esc_html__( 'Select background color', 'flicker' ),
								'help'    => esc_html__( 'Select one of predefined background colors', 'flicker' ),
								'choices' => array(
									''                              => esc_html__( 'No background', 'flicker' ),
									'with_padding muted_background' => esc_html__( 'Muted', 'flicker' ),
									'with_padding with_border'      => esc_html__( 'With Border', 'flicker' ),
									'with_padding ls'               => esc_html__( 'Light', 'flicker' ),
									'with_padding ls ms'            => esc_html__( 'Light Grey', 'flicker' ),
									'with_padding ds'               => esc_html__( 'Dark Grey', 'flicker' ),
									'with_padding ds ms'            => esc_html__( 'Dark', 'flicker' ),
									'with_padding cs'               => esc_html__( 'Main color', 'flicker' ),
									'with_padding cs main_color2'   => esc_html__( 'Second Main color', 'flicker' ),
								),
							),
							'columns_padding'     => array(
								'type'    => 'select',
								'value'   => 'columns_padding_15',
								'label'   => esc_html__( 'Column paddings in form', 'flicker' ),
								'desc'    => esc_html__( 'Choose columns horizontal paddings value', 'flicker' ),
								'choices' => array(
									'columns_padding_15' => esc_html__( '15 px - default', 'flicker' ),
									'columns_padding_0'  => esc_html__( '0', 'flicker' ),
									'columns_padding_1'  => esc_html__( '1 px', 'flicker' ),
									'columns_padding_2'  => esc_html__( '2 px', 'flicker' ),
									'columns_padding_5'  => esc_html__( '5 px', 'flicker' ),
									'columns_padding_10'  => esc_html__( '10 px', 'flicker' ),
								),
							),
							'input_text_center'     => array(
								'type'  => 'switch',
								'value' => '',
								'attr'  => array( 'class' => 'custom-class', 'data-foo' => 'bar' ),
								'label' => esc_html__('Input Text Center', 'flicker'),
								'desc'  => esc_html__('Center Text in Form Fields', 'flicker'),
								'left-choice' => array(
									'value' => '',
									'label' => esc_html__('No', 'flicker'),
								),
								'right-choice' => array(
									'value' => 'input-text-center',
									'label' => esc_html__('Yes', 'flicker'),
								),
							),
							'form_email_settings' => array(
								'type'    => 'group',
								'options' => array(
									'email_to' => array(
										'type'  => 'text',
										'label' => esc_html__( 'Email To', 'flicker' ),
										'help'  => esc_html__( 'We recommend you to use an email that you verify often', 'flicker' ),
										'desc'  => esc_html__( 'The form will be sent to this email address.', 'flicker' ),
									),
								),
							),
							'form_text_settings'  => array(
								'type'    => 'group',
								'options' => array(
									'subject-group'       => array(
										'type'    => 'group',
										'options' => array(
											'subject_message' => array(
												'type'  => 'text',
												'label' => esc_html__( 'Subject Message', 'flicker' ),
												'desc'  => esc_html__( 'This text will be used as subject message for the email', 'flicker' ),
												'value' => esc_html__( 'Contact Form', 'flicker' ),
											),
										)
									),
									'submit-button-group' => array(
										'type'    => 'group',
										'options' => array(
											'submit_button_text' => array(
												'type'  => 'text',
												'label' => esc_html__( 'Submit Button', 'flicker' ),
												'desc'  => esc_html__( 'This text will appear in submit button', 'flicker' ),
												'value' => esc_html__( 'Send', 'flicker' ),
											),
											'reset_button_text'  => array(
												'type'  => 'text',
												'label' => esc_html__( 'Reset Button', 'flicker' ),
												'desc'  => esc_html__( 'This text will appear in reset button. Leave blank if reset button not needed', 'flicker' ),
												'value' => esc_html__( 'Clear', 'flicker' ),
											),
										)
									),
									'success-group'       => array(
										'type'    => 'group',
										'options' => array(
											'success_message' => array(
												'type'  => 'text',
												'label' => esc_html__( 'Success Message', 'flicker' ),
												'desc'  => esc_html__( 'This text will be displayed when the form will successfully send', 'flicker' ),
												'value' => esc_html__( 'Message sent!', 'flicker' ),
											),
										)
									),
									'failure_message'     => array(
										'type'  => 'text',
										'label' => esc_html__( 'Failure Message', 'flicker' ),
										'desc'  => esc_html__( 'This text will be displayed when the form will fail to be sent', 'flicker' ),
										'value' => esc_html__( 'Oops something went wrong.', 'flicker' ),
									),
								),
							),
						)
					),
					'mailer-options'   => array(
						'title'   => esc_html__( 'Mailer Options', 'flicker' ),
						'type'    => 'tab',
						'options' => array(
							'mailer' => array(
								'label' => false,
								'type'  => 'mailer'
							)
						)
					)
				),
			),
		),
	)
);