<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
get_header();
global $post;
$options        = fw_get_db_post_option( $post->ID, fw()->extensions->get( 'events' )->get_event_option_id() );
$column_classes = flicker_get_columns_classes();

$option_events =  fw_get_db_post_option( $post->ID );
$gallery_images =  $option_events['post-featured-gallery'];
?>
    <div id="content" class="<?php echo esc_attr( $column_classes['main_column_class'] ); ?>">
		<?php
		// Start the Loop.
		while ( have_posts() ) : the_post(); ?>
            <article
                    id="post-<?php the_ID(); ?>" <?php post_class( 'event-single vertical-item content-padding big-padding with_background rounded overflow_hidden' ); ?>>
				<?php if ( ! empty( $gallery_images ) ) : ?>
                    <div class="item-media entry-thumbnail bottommargin_40">
                        <div class="owl-carousel"
                             data-items="1"
                             data-responsive-xs="1"
                             data-responsive-sm="1"
                             data-responsive-md="1"
                             data-responsive-lg="1"
                             data-nav="true"
                             data-dots="true"
                        >

							<?php foreach ( $gallery_images as $image ) : ?>
                                <div>
                                    <img src="<?php echo esc_url($image['url']) ?>" alt="<?php echo esc_attr($post->title); ?>">
                                </div>
							<?php endforeach; ?>
                        </div>
                    </div>
					<?php
				else:
					flicker_post_thumbnail();
				endif;
				?>
                <div class="item-content">

                    <div class="entry-content">

                        <header class="entry-header">

                            <div class="entry-meta small-text content-justify vertical-center">
			                    <?php flicker_posted_on( true ); ?>
			                    <?php flicker_share_this(); ?>
                            </div>

                            <hr>

                            <div class="entry-meta">
			                    <?php
			                    printf( '<a href="%1$s">%2$s <span>%3$s</span></a>',
				                    esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
				                    esc_html__( 'By:', 'flicker' ),
				                    get_the_author()
			                    );
			                    ?>
			                    <?php if ( in_array( 'fw-event-taxonomy-name', get_object_taxonomies( get_post_type() ) ) ) : ?>
                                    / <span class="categories-links highlightlinks"><?php echo get_the_term_list( $post->ID, 'fw-event-taxonomy-name') ?></span>

			                    <?php endif; ?>
			                    <?php if ( comments_open() ) : ?>
                                    / <a href="<?php comments_link(); ?>">
                                        <span class="value"><?php comments_number( "0 comments", "1 comment", "% comments" ); ?></span>
                                    </a>
			                    <?php else: ?>
                                    / <span>
                    <span><?php echo esc_html__( 'Comments closed', 'flicker' ); ?></span>
                </span>
			                    <?php endif; ?>
                            </div>

                        </header><!-- .entry-header -->

                        <!-- additional information about event -->
                        <div class="event-info bottommargin_30">
                            <p class="event-place">
								<?php
								if ( $options['event_location']['location'] ) : ?>
                                    <strong class="grey"><?php esc_html_e( 'Place', 'flicker' ) ?>:</strong>
									<?php
									echo esc_html( $options['event_location']['location'] );
								endif;

								if ( $options['event_location']['venue'] ) :
									echo esc_html( ', ' . $options['event_location']['venue'] );
								endif;
								?>
                            </p><!-- .event-place-->
							<?php

							foreach ( $options['event_children'] as $key => $row ) : ?>
								<?php if ( empty( $row['event_date_range']['from'] ) or empty( $row['event_date_range']['to'] ) ) : ?>
									<?php continue; ?>
								<?php endif; ?>

                                <div class="pull-right">
                                    <button class="theme_button small_button color1"
                                            data-uri="<?php echo add_query_arg( array(
										        'row_id'   => $key,
										        'calendar' => 'google'
									        ), fw_current_url() ); ?>" type="button"><?php esc_html_e( 'Google Calendar',
											'flicker' ) ?></button>
                                    <button class="theme_button small_button inverse" data-uri="<?php echo add_query_arg( array(
										'row_id'   => $key,
										'calendar' => 'ical'
									), fw_current_url() ); ?>" type="button"><?php esc_html_e( 'Ical Export',
											'flicker' ) ?></button>
                                </div>
                                <ul class="list-unstyled">
                                    <li><strong class="grey"><?php esc_html_e( 'Start', 'flicker' ) ?>
                                            :</strong> <?php echo wp_kses_post ( $row['event_date_range']['from'] ); ?></li>
                                    <li><strong class="grey"><?php esc_html_e( 'End', 'flicker' ) ?>
                                            :</strong> <?php echo wp_kses_post ( $row['event_date_range']['to'] ); ?></li>

                                </ul>
							<?php endforeach; ?>
                        </div>
                        <!-- .additional information about event -->

						<?php
						//tags
						echo get_the_term_list( $post->ID, 'fw-event-tag', '<span class="categories-links theme_buttons small_buttons inverse">', ' ', '</span>' );
						?>


						<?php the_content(); ?>

						<?php
						$map = fw_ext_events_render_map();
						if ( $map ):
							?>
                            <div class="event-map">
								<?php echo fw_ext_events_render_map(); ?>
                            </div>
							<?php
						endif; //map
						?>

						<?php do_action( 'flicker_ext_events_after_content' ); ?>
                    </div><!-- .entry-content -->
                </div><!-- .item-content -->

            </article>

			<?php
			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) {
				comments_template();
			}
		endwhile; ?>

    </div><!--eof #content -->
<?php if ( $column_classes['sidebar_class'] ): ?>
    <!-- main aside sidebar -->
    <aside class="<?php echo esc_attr( $column_classes['sidebar_class'] ); ?>">
		<?php get_sidebar(); ?>
    </aside>
    <!-- eof main aside sidebar -->
	<?php
endif;
get_footer();