<?php
/**
 * @package Musiziya
 * @since Musiziya 1.0
 * 
 */
?>

<article class="no-results not-found white-bk">
	<header class="entry-header">
		<h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'musiziya' ); ?></h1>
	</header><!-- .page-header -->

		<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
			<p><?php printf( esc_html__( 'Ready to publish your first post?-Get started here', 'musiziya' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

		<?php elseif ( is_search() ) : ?>

			<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'musiziya' ); ?></p>
			
			<div class="margin">
				<?php get_search_form(); ?>
			</div>
		<?php else : ?>

			<p><?php esc_html_e( 'It seems we did not find what you are looking for. Perhaps searching can help.', 'musiziya' ); ?></p>
			<?php get_search_form(); ?>

		<?php endif; ?>
	
</article><!-- .no-results -->
