<?php
/**
 * Custom template tags for this theme.
 * @package Musiziya
 * @since Musiziya 1.0
 */


if ( ! function_exists( 'musiziya_comment_nav' ) ) :
/**
 * Display navigation to next/previous comments when applicable.
 *
 * @since 1.0
 */
function musiziya_comment_nav() {
	// Are there comments to navigate through?
	if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
		?>
	<nav class="comment-navigation" role="navigation">
		<ul class="pager">
			<?php
			if ( $prev_link = get_previous_comments_link( esc_html__( 'Older Comments', 'musiziya' ) ) ) :
				printf( '<li class="nav-previous previous">%s</li>', $prev_link );
			endif;

			if ( $next_link = get_next_comments_link( esc_html__( 'Newer Comments ', 'musiziya' ) ) ) :
				printf( '<li class="nav-next next">%s</li>', $next_link );
			endif;
			?>
		</ul><!-- .nav-links -->
	</nav><!-- end .navigation -->
	<?php
	endif;
}
endif; // musiziya_comment_nav


if ( ! function_exists( 'musiziya_content_nav' ) ) :
/**
 * Display navigation to next/previous pages when applicable
 *
 * @since 1.0
 */
function musiziya_content_nav( $nav_id ) {
	global $wp_query, $post;

	// Don't print empty markup on single pages if there's nowhere to navigate.
	if ( is_single() ) {
		$previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
		$next = get_adjacent_post( false, '', false );

		if ( ! $next && ! $previous )
			return;
	}

	// Don't print empty markup in archives if there's only one page.
	if ( $wp_query->max_num_pages < 2 && ( is_home() || is_archive() || is_search() ) )
		return;

	$nav_class = ( is_single() ) ? 'post-navigation' : 'paging-navigation';

	?>
	<nav id="<?php echo esc_attr( $nav_id ); ?>" class="<?php echo esc_attr( $nav_class ); ?>" role="navigation">
		<ul class="pager">

			<?php if ( is_single() ) : // navigation links for single posts ?>

<?php previous_post_link( '<li class="nav-previous previous">%link</li>', '<span class="meta-nav">' . esc_html__('Previous', 'musiziya' ) . '</span>' ); ?>
<?php next_post_link( '<li class="nav-next next">%link</li>', ' <span class="meta-nav">' . esc_html__('Next', 'musiziya' ) . '</span>' ); ?>

			<?php elseif ( $wp_query->max_num_pages > 1 && ( is_home() || is_archive() || is_search() ) ) : // navigation links for home, archive, and search pages ?>

				<?php if ( get_next_posts_link() ) : ?>
					<li class="nav-previous previous"><?php next_posts_link( esc_html__( '<span class="meta-nav">&larr;</span> Older posts', 'musiziya' ) ); ?></li>
				<?php endif; ?>

				<?php if ( get_previous_posts_link() ) : ?>
					<li class="nav-next next"><?php previous_posts_link( esc_html__( 'Newer posts <span class="meta-nav">&rarr;</span>', 'musiziya' ) ); ?></li>
				<?php endif; ?>

			<?php endif; ?>

		</ul>
	</nav><!-- #<?php echo esc_html( $nav_id ); ?> -->
	<?php
}
endif; // musiziya_content_nav


if ( ! function_exists( 'musiziya_post_nav' ) ) :
/**
 * Display navigation to next/previous post when applicable.
 *
 * @since 1.0
 */
function musiziya_post_nav() {
	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous ) {
		return;
	}
	?>
	<nav class="navigation post-navigation">
		<h3 class="screen-reader-text"><?php esc_html__( 'Post navigation', 'musiziya' ); ?></h3>
		<div class="nav-links">
			<?php
				previous_post_link( '<div class="nav-previous">%link</div>', esc_html__('Previous', 'musiziya' ) );
				next_post_link(     '<div class="nav-next">%link</div>',     esc_html__('Next', 'musiziya' ) );
			?>
		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif; // musiziya_post_nav


if ( ! function_exists( 'musiziya_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 * 
 * @since 1.0
 */
function musiziya_posted_on() {
	$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
	}

	$time_string = sprintf( $time_string,
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_attr( get_the_modified_date( 'c' ) ),
		esc_html( get_the_modified_date() )
	);

	$posted_on = sprintf(
		esc_html_x( '%s', 'post date', 'musiziya' ),
		'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
	);

	$byline = sprintf(
		esc_html_x( '%s', 'post author', 'musiziya' ),
		'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
	);

	echo '<ul class="footer-blog-ic"><li class="posted-on">' . $posted_on . '</li><li class="byline"> ' . $byline . '</li></ul>'; // WPCS: XSS OK.

}
endif; // musiziya_posted_on



if ( ! function_exists( 'musiziya_entry_footer' ) ) :

function musiziya_entry_footer() {

	if ( 'post' == get_post_type() ) {

		$categories_list = get_the_category_list( esc_html__( ', ', 'musiziya' ) );
		if ( $categories_list && musiziya_categorized_blog()) { ?>
			<span class="cat-links">
				<?php printf( esc_html__( 'Categories %1$s ', 'musiziya' ), $categories_list ); ?>
			</span>
		<?php } 

		$tags_list = get_the_tag_list( '', esc_html__( ' ', 'musiziya' ) );
		if ( $tags_list ) { ?>
			<span class="tags-links">
				<?php printf( esc_html__( 'Tags %1$s ', 'musiziya' ), $tags_list ); ?>
			</span>
		<?php }

	} // get_post_type

	if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) { ?>
		<span class="comments-link">
			<?php comments_popup_link( esc_html__( 'Leave a comment ', 'musiziya' ), esc_html__( '1 Comment', 'musiziya' ), esc_html__( '% Comments ', 'musiziya' ) ); ?>
		</span>
	<?php }
}
endif; // musiziya_entry_footer

if ( ! function_exists( 'musiziya_the_attached_image' ) ) :
/**
 * Print the attached image with a link to the next attached image.
 *
 * @since 1.0
 */
function musiziya_the_attached_image() {
	$post = get_post();
	$attachment_size     = apply_filters( 'musiziya_attachment_size', array( 810, 810 ) );
	$next_attachment_url = wp_get_attachment_url();
	$attachment_ids = get_posts( array(
		'post_parent'    => $post->post_parent,
		'fields'         => 'ids',
		'numberposts'    => -1,
		'post_status'    => 'inherit',
		'post_type'      => 'attachment',
		'post_mime_type' => 'image',
		'order'          => 'ASC',
		'orderby'        => 'menu_order ID',
	) );

	// If there is more than 1 attachment in a gallery...
	if ( count( $attachment_ids ) > 1 ) {
		foreach ( $attachment_ids as $attachment_id ) {
			if ( $attachment_id == $post->ID ) {
				$next_id = current( $attachment_ids );
				break;
			}
		}
		 
	}

	printf( '<a href="%1$s" rel="attachment">%2$s</a>',
		esc_url( $next_attachment_url ),
		wp_get_attachment_image( $post->ID, $attachment_size )
	);
}
endif; // musiziya_the_attached_image

function musiziya_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'musiziya_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,

			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'musiziya_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats >= 1 ) {
		// This blog has more than 1 category  
		return true;
	} else {
		// This blog has only 1 category  categorized_blog should return false.
		return false;
	}
}


if ( ! function_exists( 'musiziya_post_thumbnail' ) ) :

function musiziya_post_thumbnail() {
	if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
		return;
	}

	if ( is_singular() ) : ?>

	<?php 
	$full_img = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full-size');
	$img_src= $full_img[0];
	?>
	<div class="post-thumbnail">
		
		<a href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
			<?php the_post_thumbnail( 'post-thumbnail' ); ?>
		</a>
		
	</div>

	<?php else : ?>
 
	
<div class="post-thumbnail">
	<a href="<?php the_permalink(); ?>" aria-hidden="true">
		<?php
		the_post_thumbnail( 'post-thumbnail', array( 'class' => 'single-featured', 'alt' => get_the_title() ) );
		?>
	</a>
</div>
	<?php endif; // End is_singular()
}
endif; // musiziya_post_thumbnail


function musiziya_category_transient_flusher() {
	// Like, beat it. Dig?
	delete_transient( 'all_the_cool_cats' );
}
add_action( 'edit_category', 'musiziya_category_transient_flusher' );
add_action( 'save_post',     'musiziya_category_transient_flusher' );
