<?php

/**
 * Musiziya - setup
 * @package Musiziya
 * @since Musiziya 1.0
 */

define('MUSIZIYA_THEME_OPTIONS', 'musiziya_settings');
define('MUSIZIYA_THEME_DIR', get_template_directory());
define('MUSIZIYA_THEME_URI', get_template_directory_uri());
define('MUSIZIYA_JS_URI',  MUSIZIYA_THEME_URI . '/includes/js');
define('MUSIZIYA_CSS_URI', MUSIZIYA_THEME_URI . '/includes/css');
define('MUSIZIYA_IMG_DIR', MUSIZIYA_THEME_DIR . '/images');
define('MUSIZIYA_IMG_URI', MUSIZIYA_THEME_URI . '/images');

if ( ! isset( $content_width )) {
  $content_width = 669; 
}
 

// WooCommerce
function musiziya_add_woocommerce_support() {
    add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'musiziya_add_woocommerce_support' );

//WooCommerce custom
add_filter( 'woocommerce_show_page_title', '__return_false' );

function musiziya_woocommerce_setup() {
	add_theme_support( 'woocommerce' );
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );
}
add_action( 'after_setup_theme', 'musiziya_woocommerce_setup' );


add_filter('loop_shop_columns', 'loop_columns');
if (!function_exists('loop_columns')) {
	function loop_columns() {
		return 3; // 3 products per row
	}
}
function woo_related_products_limit() {
  global $product;
	
	$args['posts_per_page'] = 6;
	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'musiziya_related_products_args' );
  function musiziya_related_products_args( $args ) {
	$args['posts_per_page'] = 3; // 4 related products
	$args['columns'] = 3; // arranged in 2 columns
	return $args;
}


// Get Google Fonts URL

if ( !function_exists('musiziya_fonts') ):
function musiziya_fonts() {
	wp_enqueue_style( 'musiziya-google-fonts', musiziya_google_fonts_url(), array(), null );
}
add_action( 'wp_enqueue_scripts', 'musiziya_fonts' );
endif;

function musiziya_google_fonts_url() {
	$fonts_url = '';

	$robotoslab = _x( 'on', 'roboto slab font: on or off', 'musiziya' );
	$poppins = _x( 'on', 'Poppins font: on or off', 'musiziya' );
	$merriweather = _x( 'on', 'Merriweather font: on or off', 'musiziya' );
	$Playfairdisplay = _x( 'on', 'Playfair Display font: on or off', 'musiziya' );
	$worksans = _x( 'on', 'Work Sans font: on or off', 'musiziya' );
	
	if ( 'off' !== $robotoslab || 'off' !== $poppins  || 'off' !== $worksans ||  'off' !== $merriweather || 'off' !== $Playfairdisplay ) {
		$font_families = array();
		
		if ( 'off' !== $robotoslab ) {
			$font_families[] = 'Roboto Slab:300,400,500,600,700,800';
		}
		
		if ( 'off' !== $poppins ) {
			$font_families[] = 'Poppins:400,500,600,700';
		}
		
		if ( 'off' !== $merriweather ) {
			$font_families[] = 'Merriweather:300,400,500,600,700,800,900';
		}
		
		if ( 'off' !== $Playfairdisplay ) {
			$font_families[] = 'Playfair Display:400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
		}
		
		if ( 'off' !== $worksans ) {
			$font_families[] = 'Work Sans:400,500,600,700';
		}
		
		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);
		
		$fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
	}
	
	return esc_url_raw( $fonts_url );
}

//end font

function musiziya_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'admin_init', 'musiziya_add_editor_styles' );

/**
    Theme setup
**/

if ( !function_exists( 'musiziya_setup' ) ) {

  function musiziya_setup() {
    add_theme_support( 'automatic-feed-links');
    add_theme_support( 'title-tag' );
    add_theme_support( 'post-thumbnails');
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'editor-styles' );
	
    load_theme_textdomain( 'musiziya', MUSIZIYA_THEME_DIR . '/languages' );

    // Register Menus
    register_nav_menus(
      array(
        'primary'     => esc_html__( 'Primary', 'musiziya' ),
        'mobilem'	  => esc_html__( 'Mobile Menu', 'musiziya' ),
		'footer-menu' => esc_html__( 'Footer Menu', 'musiziya' )
        ) 
      );

    // allows users to set a custom background.
    add_theme_support( 'custom-background', apply_filters( 'musiziya_custom_background_args', array(
      'default-color' => 'f5f5f5',
      )));

    //add image sizes
    add_image_size('musiziya-featured_image', 669, 272, true);
    add_image_size('musiziya-small-thumb',  50, 50, true);
    add_image_size('musiziya-full-size', 9999, 9999, false);
	add_image_size('musiziya_portfolio01_390x275', 390, 275, true);
  }
}

add_action( 'after_setup_theme', 'musiziya_setup' );

/**
    Getting post thumbnail url
 */
function musiziya_get_thumb_url($pots_ID){
  return wp_get_attachment_url( get_post_thumbnail_id( $pots_ID ) );
}

/*remove redux demo*/
/** remove redux menu under the tools **/
add_action( 'admin_menu', 'remove_redux_menu',12 );
function remove_redux_menu() {
    remove_submenu_page('tools.php','redux-about');
}

/**
    Load Required Files
**/
// Load Redux framework admin panel

if ( ! function_exists( 'redux_disable_dev_mode_plugin' ) ) {
        function redux_disable_dev_mode_plugin( $redux ) {
            if ( $redux->args['omusiziya_name'] != 'redux_demo' ) {
                $redux->args['dev_mode'] = false;
            }
        }

        add_action( 'redux/construct', 'redux_disable_dev_mode_plugin' );
    }

if (!isset($redux_demo)){
	include_once get_template_directory() . '/admin/custom/redux-config.php';
}
//
// Clean style
function musiziya_support() {
    add_theme_support(
        'html5',
        array(
            'script', 
            'style',
        )
    );
}
add_action( 'after_setup_theme', 'musiziya_support' );


include_once get_template_directory() . '/admin/custom/redux-config.php';


// Required Redux framework functions
include_once get_template_directory() . '/admin/custom/theme-options.php';


// Musiziya Styles and Scripts 
include_once get_template_directory() . '/admin/custom/core/scripts.php';

// Musiziya Sidebars, widgets and menus
include_once get_template_directory() . '/admin/custom/core/register.php';

// Custom functions & snippets
include_once get_template_directory() . '/admin/custom/core/clean.php';
include_once get_template_directory() . '/admin/custom/core/snippets.php';
include_once get_template_directory() . '/admin/custom/core/jetpack.php';

// Bootstrap Style Breadcrumbs
include_once get_template_directory() . '/includes/breadcrumbs.php';

// Bootstrap nav walker
include_once get_template_directory() . '/includes/bootstrap-walker.php';

// Bootstrap nav walker for footer
include_once get_template_directory() . '/includes/bootstrap-walker-footer.php';

// Custom template tags
include_once get_template_directory() . '/includes/template-tags.php';

//include tgma
require_once get_template_directory() . '/includes/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'musiziya_register_required_plugins' );

function musiziya_register_required_plugins() {
    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
      
// This is an example of how to include a plugin from the WordPress Plugin Repository.
		array(
			'name'      => esc_html__('Redux framework','musiziya'),
			'slug'      => 'redux-framework',
			'required'  => false,
),
		array(
			'name'      => esc_html__('Elementor Page Builder','musiziya'),
			'slug'      => 'elementor',
			'required'  => false,
),		
		array(
			'name'      => esc_html__('Unlimited Elements for Elementor','musiziya'),
			'slug'      => 'unlimited-elements-for-elementor',
			'required'  => false,
),	
		array(
			'name'      => esc_html__('Header Footer Elementor','musiziya'),
			'slug'      => 'header-footer-elementor',
			'required'  => false,
),			array(
			'name'      => esc_html__('Recent posts widget with thumbnails','musiziya'),
			'slug'      => 'recent-posts-widget-with-thumbnails',
			'required'  => false,
),		
		array(
			'name'      => esc_html__('One Click Demo Import','musiziya'),
			'slug'      => 'one-click-demo-import',
			'required'  => false,
),		
		array(
			'name'      => esc_html__('WooCommerce','musiziya'),
			'slug'      => 'woocommerce',
			'required'  => false,
),				
	
        
    );  

$config = array(
		'id'           => 'Musiziya',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
	
	);
    tgmpa( $plugins, $config );
}

 
 
?>