<?php
/**
 *
 * Redux framework functions
 *
 * @package admin panel functions
 * @author Payo-themes http://www.payo-themes.com
 * @copyright copyright (c) 2015
 * @since Musiziya 1.0
 */


/**
	Change customizer link
*/
/* Change customize link to theme options instead of live customizer */
function musiziya_change_customize_link($themes) {
	if(array_key_exists('musiziya', $themes)) {
		$themes['musiziya']['actions']['customize'] = admin_url('admin.php?page=musiziya_options');
	}
	return $themes;
}
add_filter('wp_prepare_themes_for_js', 'musiziya_change_customize_link');


/**
	Theme option function
*/

/* Generate theme option compressed CSS */
function musiziya_get_option_css(){
	ob_start();
	get_template_part('admin/custom/options-css');
	$output = ob_get_contents();
	ob_end_clean();
	return musiziya_theme_options_css($output);
}
/* add to head including favicons and custom css */
function musiziya_get_option_to_head(){

// icons
	if ( ! ( function_exists( 'has_site_icon' ) && has_site_icon() ) ) {
	
		$favicon = musiziya_get_option_media('favicon');
		if(!empty($favicon)) { 
			echo '<link rel="shortcut icon" href="' . esc_url( $favicon ) . '" />'."\n";
		}
			
		$apple_touch_icon = musiziya_get_option_media('apple_touch_icon');
		if(!empty($apple_touch_icon)) { 
			echo '<link rel="apple_touch_icon" sizes="72x72" href="' . esc_url($apple_touch_icon) . '" />'."\n";
		}
	}
}
add_action('wp_head', 'musiziya_get_option_to_head', 99);

function musiziya_theme_options_css($musiziya_theme_options) {
return $musiziya_theme_options;
}

/* Get theme option function */ 
function musiziya_get_option($option){
	global $musiziya_settings;
	if(isset($musiziya_settings[$option])){
		return $musiziya_settings[$option];
	} else {
		return false;
	}
}

/* Update theme option function */ 
function musiziya_update_option($key = false, $value = false){
	global $Redux_Options;
	if(!empty($key)){
		$Redux_Options->set($key, $value);
	} 
}

/* Convert hexdec color string to rgba */
function musiziya_hex2rgba($color, $opacity = false) {
	$default = 'rgb(0,0,0)';

	//Return default if no color provided
	if(empty($color))
		return $default;

	//Sanitize $color if "#" is provided
	if ($color[0] == '#' ) {
		$color = substr( $color, 1 );
	}

  //Check if color has 6 or 3 characters and get values
	if (strlen($color) == 6) {
		$hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
	} elseif ( strlen( $color ) == 3 ) {
		$hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
	} else {
		return $default;
	}

  //Convert hexadec to rgb
	$rgb = array_map('hexdec', $hex);

  //Check if opacity is set(rgba or rgb)
	if($opacity){
		if(abs($opacity) > 1){ $opacity = 1.0; }
		$output = 'rgba('.implode(",",$rgb).','.$opacity.')';
	} else {
		$output = 'rgb('.implode(",",$rgb).')';
	}

  //Return rgb(a) color string
	return $output;
}

/* Get image option url */
function musiziya_get_option_media($option){
	$media = musiziya_get_option($option);
	if(isset($media['url']) && !empty($media['url'])){
		return $media['url'];
	}
	return false;
}