<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

	  if ( ! class_exists( 'Redux' ) ) {
        return;
    }
 
// This is your option name where all the Redux data is stored.
    $omusiziya_name = "musiziya_settings";
	
    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'omusiziya_name'             => $omusiziya_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Musiziya Options', 'musiziya' ),
        'page_title'           => esc_html__( 'Musiziya Options', 'musiziya' ),
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-admin-generic',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the omusiziya_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then omusiziya_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'system_info'          => false,
        // REMOVE

        //'compiler'             => true,

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['omusiziya_name'] );
        }
            $args['intro_text'] = sprintf( esc_html__( 'Did you know that Redux sets a global variable for you? To access any of your saved options from within your code you can use your global variable: $%1$s', 'musiziya' ), $v );
        } 
        else {
            $args['intro_text'] = esc_html__( 'This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.', 'musiziya' );
        }

    // Add content after the form.
    $args['footer_text'] = esc_html__( 'This text is displayed below the options panel. It isn\'t required, but more info is always better! The footer_text field accepts all HTML.', 'musiziya' );

    Redux::setArgs( $omusiziya_name, $args );


Redux::setSection( $omusiziya_name, array(
    'icon' => 'el el-icon-cog',
    'title' => esc_html__('General', 'musiziya'),
    'fields' => array(
        array(
            'id' => 'info_success',
            'type' => 'info',
            'style' => 'success',
            'title' => esc_html__('Welcome to Musiziya Theme Option Panel', 'musiziya'),
            'icon' => 'el el-icon-smiley',
            'desc' => esc_html__('From here you can config your theme in the way you like.', 'musiziya')
        ),
        array(
            'id' => 'favicon',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Favicon', 'musiziya'),
            'subtitle' => esc_html__('Upload your favicon here', 'musiziya'),
            'desc' => esc_html__('Should be 16 x 16px Supported formats: .ico .gif .png', 'musiziya'),
            'default' => ''
        ),

        array(
            'id' => 'apple_touch_icon',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Apple Touch Icon', 'musiziya'),
            'subtitle' => esc_html__('Upload icon for the Apple touch', 'musiziya'),
            'desc' => esc_html__('Size: 57 x 57px Supported formats: .ico .gif .png', 'musiziya'),
            'default' => ''
        ),

        array(
            'id' => 'scroll_to_top',
            'type' => 'switch',
            'title' => esc_html__('Scroll to top button', 'musiziya'),
            'subtitle' => esc_html__('Check if you want to disable scroll to top button', 'musiziya'),
            'default' => false
        ),
		array(
            'id' => 'main_colorr',
            'type' => 'color',
            'title' => esc_html__('Main color', 'musiziya'),
            'subtitle' => esc_html__('main color', 'musiziya'),
            'transparent' => false,
            'default' => '#221b3c'
        ),
    )
) );

/* Header */
Redux::setSection( $omusiziya_name,array(
    'icon' => 'el el-icon-user',
    'title' => esc_html__('Header', 'musiziya'),
    'desc' => esc_html__('These are options to modify and style your header area', 'musiziya'),
    'fields' => array(
        array(
            'id' => 'logo',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Logo', 'musiziya'),
            'subtitle' => esc_html__('Upload your logo image here, or leave empty to show website title instead', 'musiziya'),
            'desc' => esc_html__('Note: Allowed extensions are .jpg, .png and .gif', 'musiziya'),
            'default' => get_template_directory_uri() . '/images/logo.svg',


        ),
        array(
            'id' => 'logo_width',
            'type' => 'slider',
            'title' => esc_html__('Logo Width', 'musiziya'),
            'subtitle' => esc_html__('Specify your logo width.', 'musiziya'),
            'validate' => 'numeric',
            "min" => "50",
            "step" => "1",
            "max" => "300",
            'default' => "143"
        ),
        array(
            'id' => 'logo_height',
            'type' => 'slider',
            'title' => esc_html__('Logo Height', 'musiziya'),
            'subtitle' => esc_html__('Specify your logo height.', 'musiziya'),
            'validate' => 'numeric',
            "min" => "10",
            "step" => "1",
            "max" => "300",
            'default' => "50"
        ),
        array(
            'id' => 'header_description',
            'type' => 'switch',
            'title' => esc_html__('Display site description', 'musiziya'),
            'subtitle' => esc_html__('Check if you want to display site description.', 'musiziya'),
            'desc' => esc_html__('Note: It will apply only if You remove logo image. You can change your site description inside -Settings - General', 'musiziya'),
            'default' => false,
        ),

        array(
            'id' => 'header_layout',
            'type' => 'image_select',
            'title' => esc_html__('Header Type', 'musiziya'),
            'subtitle' => esc_html__('Select your header layout: In next updates, we here will be different header types, now both are the same.', 'musiziya'),
            'options' => array(
                'default' => array(
                    'title' => esc_html__('Style One', 'musiziya'),
                    'img' => MUSIZIYA_IMG_URI . '/1column.png',
                ),
                'transparent' => array(
                    'title' => esc_html__('Transparent', 'musiziya'),
                    'img' => MUSIZIYA_IMG_URI . '/2columns.png',
                ),
            ),
            'default' => 'transparent',
        ),

		
	    array(
            'id' => 'menu_bg_style',
            'type' => 'background',
            'background-image' => false,
            'title' => esc_html__('Background Menu', 'musiziya'),
            'subtitle' => esc_html__('Select Background Menu style.', 'musiziya'),
            'transparent' => false,
            'preview' => false,
            'default' => array(
                'background-color' => '#ffffff')
        ),	
		

        
		array(
            'id' => 'new_class_top',
            'type' => 'switch',
            'title' => esc_html__('Class for better sub header', 'musiziya'),
            'subtitle' => esc_html__('on to have good sub header.', 'musiziya'),
            'default' => true,
        ),
		array(
            'id' => 'new_class_trip',
            'type' => 'switch',
            'title' => esc_html__('Class for better header', 'musiziya'),
            'subtitle' => esc_html__('on to have good  header.', 'musiziya'),
            'default' => true,
        ),
        
		
        
        array(
            'id' => 'a_color_header_txt',
            'type' => 'color',
            'title' => esc_html__('links color', 'musiziya'),
            'subtitle' => esc_html__('Change the top header links color.', 'musiziya'),
            'transparent' => false,
            'default' => '#ffffff'
        ),
        array(
            'id' => 'a_color_header_hov',
            'type' => 'color',
            'title' => esc_html__('Left links hover color', 'musiziya'),
            'subtitle' => esc_html__('Change the top header links hover color.', 'musiziya'),
            'transparent' => false,
            'default' => '#ffffff'
        ),
        
        array(
            'id' => 'nav_text_section',
            'icon' => true,
            'type' => 'info',
            'style' => 'info',
            'raw' => esc_html__('Navigation Menu', 'musiziya'),
        ),
		
        array(
            'id' => 'color_nav_a',
            'type' => 'color',
            'title' => esc_html__('Link Color', 'musiziya'),
            'subtitle' => esc_html__('Specify menu link color', 'musiziya'),
            'transparent' => false,
            'default' => '#ffffff'
        ),
        array(
            'id' => 'color_nav_a_hov',
            'type' => 'color',
            'title' => esc_html__('Hover, active, focus', 'musiziya'),
            'subtitle' => esc_html__('Specify menu link hover color', 'musiziya'),
            'transparent' => false,
            'default' => '#ffffff'
        ),

		array(
            'id' => 'social_code_top',
            'type' => 'textarea',
            'title' => esc_html__('From folder Import open file txt socials icons header and copy text', 'musiziya'),
            'subtitle' => esc_html__('Paste here...', 'musiziya'),
			'required' => array('social_icons_top', '=', true),
            'default' =>  esc_html__('...', 'musiziya'),
			'allowed_html' => array(
				'a' => array(
					'href' => array(),
					'title' => array()
				),
				'br' => array(),
				'option' => array(),
				'em' => array(),
				'strong' => array()
			)
        ),
	
        array(
            'id' => 'social_icons_top',
            'type' => 'switch',
            'title' => esc_html__('Show Social icons', 'musiziya'),
            'subtitle' => esc_html__('Click on Off to hide.', 'musiziya'),
            'default' => false,
        ),
	
        array(
            'id' => 'navbar_search',
            'type' => 'switch',
            'title' => esc_html__('Show Search in menu', 'musiziya'),
            'subtitle' => esc_html__('Click on Off to hide.', 'musiziya'),
            'default' => false,
        ),
		
    )
) );

/* Body */
Redux::setSection( $omusiziya_name,array(
    'icon' => 'el el-icon-screen',
    'title' => esc_html__('Body', 'musiziya'),
    'desc' => esc_html__('These are options to modify and style your body area', 'musiziya'),
    'fields' => array(
        array(
            'id' => 'sub_header_style_section',
            'icon' => true,
            'type' => 'info',
            'style' => 'info',
            'raw' => esc_html__('Page Title Area', 'musiziya'),
        ),
      
        array(
            'id' => 'sub_header_bg_img',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Custom background', 'musiziya'),
            'subtitle' => esc_html__('Choose background image for page title area.', 'musiziya'),
            'default' => '',
        ),
		
		
		
        array(
            'id' => 'sub_header_bg_color',
            'type' => 'color',
            'title' => esc_html__('Background color', 'musiziya'),
            'subtitle' => esc_html__('If there is no Background image, specify the sub header background color', 'musiziya'),
            'transparent' => true,
            'desc' => esc_html__('The default value is transparent.', 'musiziya'),
            'default' => '#221b3c'
        ),
        array(
            'id' => 'color_sub_header_txt',
            'type' => 'color',
            'title' => esc_html__('Text Color', 'musiziya'),
            'subtitle' => esc_html__('Change the default text color.', 'musiziya'),
            'desc' => esc_html__('Note: this will be applied on breadcrumbs text color too.', 'musiziya'),
            'transparent' => false,
            'default' => '#221b3c'
        ),


        array(
            'id' => 'body_style_section',
            'icon' => true,
            'type' => 'info',
            'style' => 'info',
            'raw' => esc_html__('Body Area', 'musiziya'),
        ),

        array(
            'id' => 'body_bg_style',
            'type' => 'background',
            'background-image' => false,
            'title' => esc_html__('Background Style', 'musiziya'),
            'subtitle' => esc_html__('Select your body background style.', 'musiziya'),
            'transparent' => false,
            'preview' => false,
            'default' => array(
                'background-color' => '#f8f8f8')
        ),
        array(
            'id' => 'color_a_text',
            'type' => 'color',
            'title' => esc_html__('a link color', 'musiziya'),
            'subtitle' => esc_html__('Color for all links', 'musiziya'),
            'transparent' => false,
            'default' => '#221b3c'
        ),
        array(
            'id' => 'color_a_hov',
            'type' => 'color',
            'title' => esc_html__('a link color hover', 'musiziya'),
            'subtitle' => esc_html__('Hover color for all links', 'musiziya'),
            'transparent' => false,
            'default' => '#221b3c'
        ),

    )
) );

/* Content */
Redux::setSection( $omusiziya_name,array(
    'icon' => 'el el-icon-blogger',
    'title' => esc_html__('Blog', 'musiziya'),
    'desc' => esc_html__('These are options to modify and style your main content area only', 'musiziya'),
    'fields' => array(
        array(
            'id' => 'post_navigation',
            'type' => 'switch',
            'title' => esc_html__('Show post navigation', 'musiziya'),
            'subtitle' => esc_html__('Check if you want to remove post navigation on single post', 'musiziya'),
            'default' => true,
        ),
        array(
            'id' => 'post_content_style_section',
            'icon' => true,
            'type' => 'info',
            'style' => 'info',
            'raw' => esc_html__('Single Post style', 'musiziya'),
        ),
		
        array(
            'id' => 'color_content_bg',
            'type' => 'color',
            'title' => esc_html__('Background color', 'musiziya'),
            'subtitle' => esc_html__('Specify content area background color', 'musiziya'),
            'transparent' => false,
            'default' => '#fff',
        ),


        array(
            'id' => 'color_content_txt_h',
            'type' => 'color',
            'title' => esc_html__('Post title color', 'musiziya'),
            'subtitle' => esc_html__('This color will apply to post title heading, which is (H2) by default.', 'musiziya'),
            'transparent' => false,
            'default' => '#23323'
        ),
        array(
            'id' => 'color_content_txt',
            'type' => 'color',
            'title' => esc_html__('Content text color', 'musiziya'),
            'subtitle' => esc_html__('This color will apply to text color in the content area only', 'musiziya'),
            'transparent' => false,
            'default' => '#23323'
        ),
        array(
            'id' => 'color_content_meta',
            'type' => 'color',
            'title' => esc_html__('Meta text color', 'musiziya'),
            'subtitle' => esc_html__('This color will apply to your meta data (secondary text)', 'musiziya'),
            'transparent' => false,
            'default' => '#808080'
        ),

        array(
            'id' => 'author_content_style_section',
            'icon' => true,
            'type' => 'info',
            'style' => 'info',
            'raw' => esc_html__('Author Box', 'musiziya'),
        ),
        array(
            'id' => 'blog_author_bio',
            'type' => 'switch',
            'title' => esc_html__('Enable author Bio', 'musiziya'),
            'subtitle' => esc_html__('Enable / Disable author box', 'musiziya'),
            'default' => true,
        ),
        array(
            'id' => 'author_bg_color',
            'type' => 'color',
            'title' => esc_html__('Background color', 'musiziya'),
            'subtitle' => esc_html__('Specify content area background color', 'musiziya'),
            'transparent' => false,
            'required' => array('blog_author_bio', '=', true),
            'default' => '#221b3c',
        ),
        array(
            'id' => 'author_txt_color',
            'type' => 'color',
            'title' => esc_html__('Content text color', 'musiziya'),
            'subtitle' => esc_html__('This color will apply to text color in the content area only', 'musiziya'),
            'transparent' => false,
            'required' => array('blog_author_bio', '=', true),
            'default' => '#fff'
        ),

        array(
            'id' => 'author_socials_text',
            'type' => 'text',
            'title' => esc_html__('Author Social Text', 'musiziya'),
            'subtitle' => esc_html__('Change post social text here.', 'musiziya'),
            'required' => array('author_socials', '=', true),
            'desc' => esc_html__('Leave it empty to hide it.', 'musiziya'),
            'default' => esc_html__('Follow me.', 'musiziya')
        )

    )
) );

/* Sidebar */
Redux::setSection( $omusiziya_name,array(
    'icon' => 'el el-icon-lines',
    'title' => esc_html__('Sidebar', 'musiziya'),
    'desc' => esc_html__('These are global styling settings for the sidebar area', 'musiziya'),
    'fields' => array(
        array(
            'id' => 'color_sidebar_bg',
            'type' => 'color',
            'title' => esc_html__('Background color', 'musiziya'),
            'subtitle' => esc_html__('Specify sidebar background color', 'musiziya'),
            'transparent' => false,
            'default' => 'transparent',
        ),
        array(
            'id' => 'color_sidebar_txt_h',
            'type' => 'color',
            'title' => esc_html__('Sidebar titles color', 'musiziya'),
            'subtitle' => esc_html__('This color will apply to your sidebar titles.', 'musiziya'),
            'transparent' => false,
            'default' => '#221b3c'
        ),
        array(
            'id' => 'color_sidebar_txt',
            'type' => 'color',
            'title' => esc_html__('a links color', 'musiziya'),
            'subtitle' => esc_html__('This color will apply to sidebar links.', 'musiziya'),
            'transparent' => false,
            'default' => '#221b3c'
        ),
        array(
            'id' => 'color_sidebar_txt_hov',
            'type' => 'color',
            'title' => esc_html__('a links color hover', 'musiziya'),
            'subtitle' => esc_html__('This color will apply to sidebar links hover.', 'musiziya'),
            'transparent' => false,
            'default' => '#221b3c'
        ),
    )
) );

/* Footer */
Redux::setSection( $omusiziya_name,array(
    'icon' => 'el el-icon-bookmark',
    'title' => esc_html__('Footer', 'musiziya'),
    'desc' => esc_html__('Manage settings for footer area', 'musiziya'),
    'fields' => array(
   
   		array(
            'id' => 'new_class_footer',
            'type' => 'switch',
            'title' => esc_html__('Class to hide default copyright', 'musiziya'),
            'subtitle' => esc_html__('keep it as default.', 'musiziya'),
            'default' => true,
        ),
		
		array(
            'id' => 'header_socials',
            'type' => 'switch',
            'title' => esc_html__('Edit Social Icons', 'musiziya'),
            'subtitle' => esc_html__('On - to edit social icons.', 'musiziya'),
            'required' => array('hide_top_header', '=', true),
            'default' => true,
        ),
        array(
            'id' => 'facebook',
            'type' => 'text',
            'title' => esc_html__('Facebook', 'musiziya'),
            'subtitle' => esc_html__('Insert your Facebook fanpage here.', 'musiziya'),
            'desc' => "",
            'required' => array('header_socials', '=', true),
            'default' => "#"
        ),
        array(
            'id' => 'twitter',
            'type' => 'text',
            'title' => esc_html__('Twitter', 'musiziya'),
            'subtitle' => esc_html__('Insert your Twitter URL here.', 'musiziya'),
            'desc' => "",
            'required' => array('header_socials', '=', true),
            'default' => "#"
        ),
        array(
            'id' => 'dribbble',
            'type' => 'text',
            'title' => esc_html__('Dribbble', 'musiziya'),
            'subtitle' => esc_html__('Insert your Dribbble URL here.', 'musiziya'),
            'desc' => "",
            'required' => array('header_socials', '=', true),
            'default' => ""
        ),
        array(
            'id' => 'google_plus',
            'type' => 'text',
            'title' => esc_html__('Google Plus', 'musiziya'),
            'subtitle' => esc_html__('Insert your Google Plus URL here.', 'musiziya'),
            'desc' => "",
            'required' => array('header_socials', '=', true),
            'default' => ""
        ),
        array(
            'id' => 'pinterest',
            'type' => 'text',
            'title' => esc_html__('Pinterest', 'musiziya'),
            'subtitle' => esc_html__('Insert your Pinterest URL here.', 'musiziya'),
            'desc' => "",
            'required' => array('header_socials', '=', true),
            'default' => ""
        ),
        array(
            'id' => 'flickr',
            'type' => 'text',
            'title' => esc_html__('Flickr', 'musiziya'),
            'subtitle' => esc_html__('Insert your Flickr URL here.', 'musiziya'),
            'desc' => "",
            'required' => array('header_socials', '=', true),
            'default' => ""
        ),
        array(
            'id' => 'instagram',
            'type' => 'text',
            'title' => esc_html__('Instagram', 'musiziya'),
            'subtitle' => esc_html__('Insert your Instagram URL here.', 'musiziya'),
            'desc' => "",
            'required' => array('header_socials', '=', true),
            'default' => "#"
        ),
        array(
            'id' => 'vimeo',
            'type' => 'text',
            'title' => esc_html__('Vimeo', 'musiziya'),
            'subtitle' => esc_html__('Insert your Vimeo URL here.', 'musiziya'),
            'desc' => "",
            'required' => array('header_socials', '=', true),
            'default' => ""
        ),
        array(
            'id' => 'rss',
            'type' => 'text',
            'title' => esc_html__('Rss', 'musiziya'),
            'subtitle' => esc_html__('Insert your Rss URL here.', 'musiziya'),
            'desc' => "",
            'required' => array('header_socials', '=', true),
            'default' => ""
        ),
        array(
            'id' => 'linkedin',
            'type' => 'text',
            'title' => esc_html__('Linkedin', 'musiziya'),
            'subtitle' => esc_html__('Insert your Linkedin URL here.', 'musiziya'),
            'desc' => "",
            'required' => array('header_socials', '=', true),
            'default' => "#"
        ),
		
		array(
			'id'        => 'footer_copyright_text',
			'type'      => 'editor',
			'title'     => esc_html__('Footer Copyright Text', 'musiziya'),
			'subtitle'  => esc_html__('Copyright text', 'musiziya'),
			'default'   => esc_html__('2020 &copy; Payo Themes. All rights reserved. ', 'musiziya'),
		),

        array(
            'id' => 'enable_footer_menu',
            'type' => 'switch',
            'title' => esc_html__('Enable Footer Menu', 'musiziya'),
            'subtitle' => esc_html__('Check if you want to show footer menu inside footer area', 'musiziya'),
            'desc' => esc_html__('Note: you need to set footer menu inside Apperance-Menu', 'musiziya'),
            'default' => false,
        ),
        
        array(
            'id' => 'footer_col',
            'type' => 'image_select',
            'compiler' => true,
            'title' => esc_html__('Footer Widget Columns', 'musiziya'),
            'subtitle' => esc_html__('Choose columns you want for your footer widgets.', 'musiziya'),
            'desc' => esc_html__('You can manage footer area content in Apperance-Widgets-Footer', 'musiziya'),
            'options' => array(
                '1' => array('alt' => '1 Column ', 'img' => MUSIZIYA_IMG_URI . '/1column.png'),
                '2' => array('alt' => '2 Column ', 'img' => MUSIZIYA_IMG_URI . '/2columns.png'),
                '3' => array('alt' => '3 Column ', 'img' => MUSIZIYA_IMG_URI . '/3columns.png'),
                '4' => array('alt' => '4 Column ', 'img' => MUSIZIYA_IMG_URI . '/4columns.png')
            ),
            'default' => '1',

        ),

		
		array(
           'id' => 'color_footer_bg',
            'type' => 'color',
            'title' => esc_html__('Background color', 'musiziya'),
            'subtitle' => esc_html__('This color will apply to footer bg.', 'musiziya'),
            'transparent' => false,
            'default' => '#221b3c'
        ),

        array(
            'id' => 'img_footer_bg',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Image background', 'musiziya'),
            'subtitle' => esc_html__('Choose background image.', 'musiziya'),
            'default' => '',
        ),
		
		
        array(
            'id' => 'color_footer_txt_h',
            'type' => 'color',
            'title' => esc_html__('Footer titles color', 'musiziya'),
            'subtitle' => esc_html__('This color will apply to your footer titles.', 'musiziya'),
            'transparent' => false,
            'default' => '#fff'
        ),
        array(
            'id' => 'color_footer_txt',
            'type' => 'color',
            'title' => esc_html__('Footer Text color', 'musiziya'),
            'subtitle' => esc_html__('This color will apply to footer text.', 'musiziya'),
            'transparent' => false,
            'default' => '#c2c2c2'
        ),
        array(
            'id' => 'color_footer_txt_a',
            'type' => 'color',
            'title' => esc_html__('Footer a links color', 'musiziya'),
            'subtitle' => esc_html__('This color will apply to footer links.', 'musiziya'),
            'transparent' => false,
            'default' => '#c2c2c2'
        ),
        array(
            'id' => 'color_footer_txt_hov',
            'type' => 'color',
            'title' => esc_html__('Footer a links color hover', 'musiziya'),
            'subtitle' => esc_html__('This color will apply to footer links hover.', 'musiziya'),
            'transparent' => false,
            'default' => '#fafafa'
        )


    )


) );

/* Typography */
Redux::setSection( $omusiziya_name,array(
    'icon' => 'el el-icon-font',
    'title' => esc_html__('Typography', 'musiziya'),
    'desc' => esc_html__('Manage fonts and typography settings', 'musiziya'),
    'fields' => array(

        array(
            'id' => 'main_font',
            'type' => 'typography',
            'title' => esc_html__('Main text font', 'musiziya'),
            'google' => true,
            'compiler' => true,
            'font-backup' => false,
            'font-size' => true,
            'color' => true,
            'subsets' => false,
            'line-height' => true,
            'text-align' => false,
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'musiziya'),
            'default' => array(
                'google' => true,
                'font-weight' => '400',
                'font-family' => 'Roboto',
                'font-size' => '16px',
                'line-height' => '28px',
                'color' => '#5e6167',
            ),
            'preview' => array(
                'always_display' => true,
                'font-size' => '14px',
                'text' => esc_html__('We think that readibility is very important part of any WordPress theme. This is actually a rough example of how simple paragpraph of text will look like on your website so you have a simple preview here.', 'musiziya')
				
            )
        ),


        array(
            'id' => 'Heading_section',
            'icon' => true,
            'type' => 'info',
            'style' => 'info',
            'raw' => esc_html__('Heading Style', 'musiziya'),
        ),
        array(
            'id' => 'h1_font',
            'type' => 'typography',
            'title' => esc_html__('H1 font', 'musiziya'),
            'google' => true,
            'font-backup' => false,
            'font-size' => true,
            'color' => true,
            'line-height' => false,
            'text-align' => false,
            'subsets' => false,
            'units' => 'px',
            'subtitle' => esc_html__('Specify the H1 tag font properties.', 'musiziya'),
            'default' => array(
                'google' => true,
                'font-weight' => '400',
                'font-family' => 'Playfair Display',
                'font-size' => '50px',
				'color' => '#221b3c'
            ),

            'preview' => array(
                'always_display' => true,
                'font-size' => '36px',
                'text' => esc_html__('There is no good blog without great readability', 'musiziya')
            )

        ),
        array(
            'id' => 'h2_font',
            'type' => 'typography',
            'title' => esc_html__('H2 font', 'musiziya'),
            'google' => true,
            'font-backup' => false,
            'font-size' => true,
            'color' => false,
            'line-height' => false,
            'text-align' => false,
            'subsets' => false,
            'units' => 'px',
            'subtitle' => esc_html__('Specify the H2 tag font properties.', 'musiziya'),
            'default' => array(
                'google' => true,
                'font-weight' => '400',
                'font-family' => 'Playfair Display',
                'font-size' => '40px',
				'color' => '#221b3c'
            ),
            'preview' => array(
                'always_display' => true,
                'font-size' => '30px',
                'text' => esc_html__('There is no good blog without great readability', 'musiziya')
				
            )

        ),
        array(
            'id' => 'h3_font',
            'type' => 'typography',
            'title' => esc_html__('H3 font', 'musiziya'),
            'google' => true,
            'font-backup' => false,
            'font-size' => true,
            'color' => false,
            'line-height' => false,
            'text-align' => false,
            'subsets' => false,
            'units' => 'px',
            'subtitle' => esc_html__('Specify the H3 tag font properties.', 'musiziya'),
            'default' => array(
                'google' => true,
                'font-weight' => '400',
                'font-family' => 'Playfair Display',
                'font-size' => '27px',
				'color' => '#221b3c'
            ),
            'preview' => array(
                'always_display' => true,
                'font-size' => '24px',
                'text' => esc_html__('There is no good blog without great readability', 'musiziya')
            )

        ),
        array(
            'id' => 'h4_font',
            'type' => 'typography',
            'title' => esc_html__('H4 font', 'musiziya'),
            'google' => true,
            'font-backup' => false,
            'font-size' => true,
            'color' => false,
            'line-height' => false,
            'text-align' => false,
            'subsets' => false,
            'units' => 'px',
            'subtitle' => esc_html__('Specify the H4 tag font properties.', 'musiziya'),
            'default' => array(
                'google' => true,
                'font-weight' => '400',
                'font-family' => 'Playfair Display',
                'font-size' => '22px',
				'color' => '#221b3c'
            ),
            'preview' => array(
                'always_display' => true,
                'font-size' => '18px',
                'text' => esc_html__('There is no good blog without great readability', 'musiziya')
            )

        ),
        array(
            'id' => 'h5_font',
            'type' => 'typography',
            'title' => esc_html__('H5 font', 'musiziya'),
            'google' => true,
            'font-backup' => false,
            'font-size' => true,
            'color' => false,
            'line-height' => false,
            'text-align' => false,
            'subsets' => false,
            'units' => 'px',
            'subtitle' => esc_html__('Specify the H5 tag font properties.', 'musiziya'),
            'default' => array(
                'google' => true,
                'font-weight' => '400',
                'font-family' => 'Playfair Display',
                'font-size' => '16px',
				'color' => '#221b3c'
            ),
            'preview' => array(
                'always_display' => true,
                'font-size' => '14px',
                'text' => esc_html__('There is no good blog without great readability', 'musiziya')
            )

        ),
        array(
            'id' => 'h6_font',
            'type' => 'typography',
            'title' => esc_html__('H6 font', 'musiziya'),
            'google' => true,
            'font-backup' => false,
            'font-size' => true,
            'color' => false,
            'line-height' => false,
            'text-align' => false,
            'subsets' => false,
            'units' => 'px',
            'subtitle' => esc_html__('Specify the H6 tag font properties.', 'musiziya'),
            'default' => array(
                'google' => true,
                'font-weight' => '400',
                'font-family' => 'Playfair Display',
                'font-size' => '17px',
				'color' => '#221b3c'
            ),
            'preview' => array(
                'always_display' => true,
                'font-size' => '12px',
                'text' => esc_html__('There is no good blog without great readability', 'musiziya')
            )

        ),
        array(
            'id' => 'nav_font',
            'type' => 'typography',
            'title' => esc_html__('Navigation font', 'musiziya'),
            'google' => true,
            'compiler' => true,
            'font-backup' => false,
            'font-size' => true,
			'font-weight' => true,
            'color' => false,
            'line-height' => false,
            'text-align' => false,
            'subsets' => false,
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'musiziya'),
            'default' => array(
                'google' => true,
                'font-weight' => '500',
                'font-family' => 'Roboto',
                'font-size' => '15px',
				'color' => '#ffffff'
            ),

            'preview' => array(
                'always_display' => true,
                'font-size' => '14px',
                'text' => esc_html__('Home &nbsp;&nbsp;About &nbsp;&nbsp;Blog &nbsp;&nbsp;Contact', 'musiziya')
            )

        ),
    )
) );
