<?php
/**
* This is the core Musiziya file where most of the
* main functions & features to keep our theme clean.
*
* @copyright Eddie Machado https://github.com/eddiemachado
* @package Musiziya
* @since Musiziya 1.0
*/


// we're firing all out initial functions at the start
add_action( 'after_setup_theme', 'musiziya_ahoy', 16 );

function musiziya_ahoy() {
    // clean up gallery output in wp
	add_filter( 'gallery_style', 'musiziya_remove_gallery_style' );
	// deactivate default gallery CSS
	add_filter( 'use_default_gallery_style', '__return_false' );
    // cleaning up excerpt
	// Read more link on all excerpts
	add_filter( 'excermusiziya_more', 'musiziya_new_excermusiziya_more' );
} 
/* end Musiziya  */

// portfolio no fontawesome
add_filter( 'vpf_enqueue_plugin_font_awesome', '__return_false' );
// end portfolio no fontawesome
function musiziya_remove_gallery_style($css) {
  return preg_replace( "!<style type='text/css'>(.*?)</style>!s", '', $css );
}

// Custom excerpt length
function musiziya_custom_excermusiziya_length(){
	$excerpt = get_the_content();
	$excerpt = preg_replace(" ([.*?])",'',$excerpt);
	$excerpt = strip_shortcodes($excerpt);
	$excerpt = strip_tags($excerpt);
	$excerpt = substr($excerpt, 0, 0);
	$excerpt = substr($excerpt, 0, strripos($excerpt, " "));
	$excerpt = trim(preg_replace( '/s+/', ' ', $excerpt));
	return $excerpt;
}

// Read more link on all excerpts
function musiziya_new_excermusiziya_more( $more ) {
	return '</p><p class="btn-excerpt"><a class="btn btn-default btn-sm " href="' . get_permalink( get_the_ID() ) . '">' . esc_attr__( 'Read More', 'musiziya' ) . '</a>';
}

/*
 * This is a modified the_author_posts_link() which just returns the link.
 * This is nemusiziyary to allow usage of the usual l10n process with printf().
 */
function musiziya_get_the_author_posts_link() {
	global $authordata;
	if ( !is_object( $authordata ) )
		return false;
	$link = sprintf(
		'<a href="%1$s" title="%2$s" rel="author">%3$s</a>',
		get_author_posts_url( $authordata->ID, $authordata->user_nicename ),
		esc_attr( sprintf( esc_attr__( 'Posts by %s', 'musiziya' ), get_the_author() ) ), // No further l10n needed, core will take care of this one
		get_the_author()
	);
	return $link;
}


/* Make your WordPress category list valid by removing the “rel” attribute */
function musiziya_remove_category_rel($string){
  return str_replace('rel="category tag"', '', $string);
}
add_filter('the_category', 'musiziya_remove_category_rel');


/* Set tag sizes in tag cloud widget */
function musiziya_set_tag_cloud_sizes($args) {
	$args['smallest'] = 10;
	$args['largest'] = 20;
	return $args;
}
add_filter('widget_tag_cloud_args','musiziya_set_tag_cloud_sizes');