<?php
/**
 * The template part for selected header
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$social_icons = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'social_icons' ) : '';
$header_transparent = ( is_front_page() ) ? 'header_transparent' : '';
$header_phone = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'header_phone' ) : '';
$header_email = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'header_email' ) : '';

$header_button_label = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'header_button_label' ) : '';
$header_button_link = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'header_button_link' ) : '';
?>

<section class="page_topline ds table_section table_section_md section_padding_top_10 section_padding_bottom_10">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-4 col-sm-6 col-md-push-4 text-center text-sm-left text-md-center">
				<?php if ( ! empty( $social_icons ) ) : ?>
					<?php
					//get icons-social shortcode to render icons in team member item
					$shortcodes_extension = fw()->extensions->get( 'shortcodes' );
					if ( ! empty( $shortcodes_extension ) ) {
						echo fw_ext( 'shortcodes' )->get_shortcode( 'icons_social' )->render( array( 'social_icons' => $social_icons ) );
					}
					?>
				<?php endif; //social icons ?>
            </div>
			<?php if ( $header_phone || $header_email ) : ?>
                <div class="col-md-4 col-sm-6 col-md-pull-4 text-center text-sm-right text-md-left">
                    <div class="inline-content medium">
						<?php if ( $header_phone ) : ?>
                            <span>
                            <i class="fa fa-phone highlight rightpadding_5"></i> <?php echo esc_html( $header_phone ); ?>
                        </span>
						<?php endif; //header_phone
						if ( $header_email ) : ?>
                            <span class="greylinks">
                            <i class="fa fa-pencil highlight rightpadding_5"></i>
                            <a href="mailto:<?php echo esc_attr( $header_email ); ?>"><?php echo esc_html( $header_email ); ?></a>
                        </span>
						<?php endif; //header_phone ?>
                    </div>
                </div>
			<?php endif; ?>
            <div class="col-md-4 col-sm-12 text-center text-md-right">
                <div class="widget widget_search">
					<?php get_search_form(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<header class="page_header header_darkgrey toggler_xs_right tall_header">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12 display_table">
                <div class="header_left_logo display_table_cell">
					<?php get_template_part( 'template-parts/header/header-logo' ); ?>
                </div>

                <div class="header_mainmenu display_table_cell text-center">
                    <nav class="mainmenu_wrapper primary-navigation">
						<?php wp_nav_menu( array(
							'theme_location' => 'primary',
							'menu_class'     => 'sf-menu nav-menu nav',
							'container'      => 'ul'
						) ); ?>
                    </nav>
                    <!-- header toggler -->
                    <span class="toggle_menu"><span></span></span>
                </div>

                <div class="header_right_buttons display_table_cell text-right hidden-xs">
					<?php if ( $header_button_label && $header_button_link ) : ?>
                        <a href="<?php echo esc_html( $header_button_link ); ?>" class="theme_button color1"><?php echo esc_html( $header_button_label ); ?></a>
					<?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</header>