<?php
/**
 * Template for displaying team content
 *
 * Used for both single and search.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

//single item layout
if ( ! is_single() ) :
	$ext_albums_settings = fw()->extensions->get( 'albums' )->get_settings();
	$taxonomy_name = $ext_albums_settings['taxonomy_name'];

	$options = fw_ext_albums_get_options();
	$price = !empty( $options['price'] ) ? $options['price'] : false;
	?>


	<article <?php post_class('vertical-item slide-media text-center loop-color') ?>>
		<div class="item-media-wrap">

			<?php if ( !has_post_thumbnail() ) : ?>

				<div>
					<img src="<?php echo fw_ext_albums_get_plugin_path() . 'static/images/cd.png' ?>" class="no-image-img" alt="<?php esc_attr_e('No image', 'flicker') ?>"/>
					<div class="media-links no-overlay">
						<div class="links-wrap">
							<a href="<?php the_permalink(); ?>" class="p-link"></a>
						</div>
					</div>
				</div>

			<?php else: ?>

				<img src="<?php echo fw_ext_albums_get_plugin_path() . 'static/images/cd.png' ?>" alt="<?php esc_attr_e('cd', 'flicker') ?>"/>
				<div class="item-media back-media">
					<img src="<?php echo fw_ext_albums_get_plugin_path() . 'static/images/cd.png' ?>" alt="<?php esc_attr_e('cd', 'flicker') ?>"/>
				</div>
				<div class="item-media">
					<?php the_post_thumbnail( 'acebeat-square-width' ); ?>
					<div class="media-links no-overlay">
						<div class="links-wrap">
							<a href="<?php the_permalink(); ?>" class="p-link"></a>
						</div>
					</div>
				</div>

			<?php endif; ?>
		</div>

		<div class="item-content topmargin_30">
			<?php if ( $price ) : ?>
				<span class="highlight">
            <?php echo esc_html( $price ); ?>
        </span>
			<?php endif; ?>
			<h4 class="entry-title topmargin_0">
				<a href="<?php the_permalink(); ?>">
					<?php the_title(); ?>
				</a>
			</h4>
		</div>
	</article>
<?php endif;  //is singular ?>