<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}
/**
 * Include static files: javascript and css
 */

//removing default font awesome css style - we using our "fonts.css" file which contain font awesome
wp_deregister_style( 'fw-font-awesome' );

//Add Theme Fonts
wp_enqueue_style(
	'flicker-icon-fonts',
	FLICKER_THEME_URI . '/css/fonts.css',
	array(),
	FLICKER_THEME_VERSION
);

if ( is_admin_bar_showing() ) {
	//Add Frontend admin styles
	wp_register_style(
		'flicker-admin_bar',
		FLICKER_THEME_URI . '/css/admin-frontend.css',
		array(),
		FLICKER_THEME_VERSION
	);
	wp_enqueue_style( 'flicker-admin_bar' );
}

//styles and scripts below only for frontend: if in dashboard - exit
if ( is_admin() ) {
	return;
}

/**
 * Enqueue scripts and styles for the front end.
 */
// Add theme google font, used in the main stylesheet.
wp_enqueue_style(
	'flicker-font',
	flicker_google_font_url(),
	array(),
	FLICKER_THEME_VERSION
);

if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
	wp_enqueue_script( 'comment-reply' );
}

if ( is_singular() && wp_attachment_is_image() ) {
	wp_enqueue_script(
		'flicker-keyboard-image-navigation',
		FLICKER_THEME_URI . '/js/keyboard-image-navigation.js',
		array( 'jquery' ),
		FLICKER_THEME_VERSION
	);
}

//plugins theme script
wp_enqueue_script(
	'flicker-modernizr',
	FLICKER_THEME_URI . '/js/vendor/modernizr-custom.js',
	false,
	FLICKER_THEME_VERSION,
	false
);

//compressed theme scripts - moved to uncompressed version
//wp_enqueue_script(
//	'flicker-compressed',
//	FLICKER_THEME_URI . '/js/compressed.js',
//	array( 'jquery' ),
//	FLICKER_THEME_VERSION,
//	true
//);

//uncompressed scripts
wp_enqueue_script( 'bootstrap',	FLICKER_THEME_URI . '/js/vendor/bootstrap.min.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'appear',	FLICKER_THEME_URI . '/js/vendor/jquery.appear.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'hoverIntent',	FLICKER_THEME_URI . '/js/vendor/jquery.hoverIntent.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'superfish.js',	FLICKER_THEME_URI . '/js/vendor/superfish.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'easing',	FLICKER_THEME_URI . '/js/vendor/jquery.easing.1.3.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'totop',	FLICKER_THEME_URI . '/js/vendor/jquery.ui.totop.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'localScroll',	FLICKER_THEME_URI . '/js/vendor/jquery.localScroll.min.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'scrollTo',	FLICKER_THEME_URI . '/js/vendor/jquery.scrollTo.min.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'scrollbar',	FLICKER_THEME_URI . '/js/vendor/jquery.scrollbar.min.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'parallax',	FLICKER_THEME_URI . '/js/vendor/jquery.parallax-1.1.3.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'easypiechart',	FLICKER_THEME_URI . '/js/vendor/jquery.easypiechart.min.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'bootstrap-progressbar',	FLICKER_THEME_URI . '/js/vendor/bootstrap-progressbar.min.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'countTo',	FLICKER_THEME_URI . '/js/vendor/jquery.countTo.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'prettyPhoto-fixed',	FLICKER_THEME_URI . '/js/vendor/jquery.prettyPhoto.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'countdown',	FLICKER_THEME_URI . '/js/vendor/jquery.countdown.min.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'isotope.pkgd',	FLICKER_THEME_URI . '/js/vendor/isotope.pkgd.min.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'owl.carousel',	FLICKER_THEME_URI . '/js/vendor/owl.carousel.min.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'flexslider',	FLICKER_THEME_URI . '/js/vendor/jquery.flexslider-min.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );
wp_enqueue_script( 'cookie',	FLICKER_THEME_URI . '/js/vendor/jquery.cookie.js', array( 'jquery' ),	FLICKER_THEME_VERSION, 	true );


//getting theme color scheme number
$color_scheme_number = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'color_scheme_number' ) : '';

//if WooCommerce - remove prettyPhoto - we have one in "compressed.js"
if ( class_exists( 'WooCommerce' ) ) :
	wp_dequeue_script( 'prettyPhoto' );
	wp_dequeue_script( 'prettyPhoto-init' );
	wp_deregister_style( 'woocommerce_prettyPhoto_css' );

	// Add Theme Woo Styles and Scripts
	wp_enqueue_style(
		'flicker-woo',
		FLICKER_THEME_URI . '/css/woo' . esc_attr( $color_scheme_number ) . '.css',
		array(),
		FLICKER_THEME_VERSION
	);

	wp_enqueue_script(
		'flicker-woo',
		FLICKER_THEME_URI . '/js/woo.js',
		array( 'jquery' ),
		FLICKER_THEME_VERSION,
		true
	);
endif; //WooCommerce

//selectize script
wp_enqueue_script(
	'selectize',
	FLICKER_THEME_URI . '/js/selectize.min.js',
	array( 'jquery' ),
	false,
	true
);

//main theme script
wp_enqueue_script(
	'flicker-main',
	FLICKER_THEME_URI . '/js/main.js',
	array( 'jquery' ),
	FLICKER_THEME_VERSION,
	true
);

//if AccessPress is active
if ( class_exists( 'SC_Class' ) ) :
	wp_deregister_style( 'fontawesome-css' );
	wp_deregister_style( 'apsc-frontend-css' );
	wp_enqueue_style(
		'flicker-accesspress',
		FLICKER_THEME_URI . '/css/accesspress.css',
		array(),
		FLICKER_THEME_VERSION
	);
endif; //AccessPress

//Add Theme Booked Styles
if( class_exists('booked_plugin')) {
	wp_dequeue_style('booked-styles');
	wp_dequeue_style('booked-responsive');
	wp_enqueue_style(
		'flicker-booked',
		FLICKER_THEME_URI . '/css/booked' . esc_attr( $color_scheme_number ) . '.css',
		array(),
		'1.0.1'
	);
}//Booked


// Add Theme stylesheet.
wp_enqueue_style( 'flicker-css-style', get_stylesheet_uri() );

// Add Bootstrap Style
wp_enqueue_style(
	'bootstrap',
	FLICKER_THEME_URI . '/css/bootstrap.min.css',
	array(),
	FLICKER_THEME_VERSION
);

// Add Selectize Style
wp_enqueue_style(
	'selectize',
	FLICKER_THEME_URI . '/css/selectize.default.css',
	array()
);

// Add Animations Style
wp_enqueue_style(
	'flicker-animations',
	FLICKER_THEME_URI . '/css/animations.css',
	array(),
	FLICKER_THEME_VERSION
);

// Add Theme Style
wp_enqueue_style(
	'flicker-main',
	FLICKER_THEME_URI . '/css/main' . esc_attr( $color_scheme_number ) . '.css',
	array(),
	FLICKER_THEME_VERSION
);
wp_add_inline_style( 'flicker-main', flicker_add_font_styles_in_head() );