<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'post-featured-gallery-section' => array(
		'title'   => esc_html__( 'Featured Gallery', 'flicker' ),
		'type'    => 'box',
		'context' => 'side',

		'options' => array(
			'post-featured-gallery' => array(
				'type'  => 'multi-upload',
				'value' => array(),
				'label' => esc_html__('Images for featured gallery', 'flicker'),
				'desc'  => esc_html__('Display gallery carousel on single event', 'flicker'),
				/**
				 * If set to `true`, the option will allow to upload only images, and display a thumb of the selected one.
				 * If set to `false`, the option will allow to upload any file from the media library.
				 */
				'images_only' => true,
				/**
				 * An array with allowed files extensions what will filter the media library and the upload files.
				 */

			),
		),
	),
	'post-tickets-data' => array(
		'title'   => esc_html__( 'Tickets Info', 'flicker' ),
		'type'    => 'box',
		'context' => 'normal',

		'options' => array(
			'ticket-price'       => array(
				'label' => esc_html__( 'Tickets start price', 'flicker' ),
				'desc'  => esc_html__( 'Tickets price which appear in top right corner. Leave it empty if you don\'t want this information to display', 'flicker' ),
				'type'  => 'text',
				'value' => esc_html__( 'Buy Tickets', 'flicker' )
			),
			'buy-tickets-link'       => array(
				'label' => esc_html__( 'Link for "Buy Tickers" button', 'flicker' ),
				'type'  => 'text',
				'value' => '#'
			),
		),
	)
);
