<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * Framework options
 *
 * @var array $options Fill this array with options to generate framework settings form in WordPress customizer
 */

//find fw_ext
$shortcodes_extension = fw()->extensions->get( 'shortcodes' );
$header_social_icons  = array();
if ( ! empty( $shortcodes_extension ) ) {
	$header_social_icons = $shortcodes_extension->get_shortcode( 'icons_social' )->get_options();
}

$slider_extension = fw()->extensions->get( 'slider' );
$choices = '';
if ( ! empty ( $slider_extension ) ) {
	$choices = $slider_extension->get_populated_sliders_choices();
}

//adding empty value to disable slider
$choices['0'] = esc_html__( 'No Slider', 'flicker' );

$options = array(
	'logo_section'    => array(
		'title'   => esc_html__( 'Site Logo', 'flicker' ),
		'options' => array(
			'logo_image'             => array(
				'type'        => 'upload',
				'value'       => array(),
				'attr'        => array( 'class' => 'logo_image-class', 'data-logo_image' => 'logo_image' ),
				'label'       => esc_html__( 'Main logo image that appears in header', 'flicker' ),
				'desc'        => esc_html__( 'Select your logo', 'flicker' ),
				'help'        => esc_html__( 'Choose image to display as a site logo', 'flicker' ),
				'images_only' => true,
				'files_ext'   => array( 'png', 'jpg', 'jpeg', 'gif' ),
			),
			'logo_text'              => array(
				'type'  => 'text',
				'value' => 'Flicker',
				'attr'  => array( 'class' => 'logo_text-class', 'data-logo_text' => 'logo_text' ),
				'label' => esc_html__( 'Logo Text', 'flicker' ),
				'desc'  => esc_html__( 'Text that appears if logo image not set', 'flicker' ),
				'help'  => esc_html__( 'Type your text to show it in logo', 'flicker' ),
			),
			'footer_logo_image'             => array(
				'type'        => 'upload',
				'value'       => array(),
				'attr'        => array( 'class' => 'logo_image-class', 'data-logo_image' => 'logo_image' ),
				'label'       => esc_html__( 'Logo image that appears in footer', 'flicker' ),
				'desc'        => esc_html__( 'Select your logo', 'flicker' ),
				'help'        => esc_html__( 'Choose image to display in footer', 'flicker' ),
				'images_only' => true,
				'files_ext'   => array( 'png', 'jpg', 'jpeg', 'gif' ),
			),
		),
	),
	'layout'          => array(
		'title'   => esc_html__( 'Theme Layout', 'flicker' ),
		'options' => array(
			'layout' => array(
				'type'    => 'multi-picker',
				'value'   => 'wide',
				'attr'    => array( 'class' => 'theme-layout-class', 'data-theme-layout' => 'layout' ),
				'label'   => esc_html__( 'Theme layout', 'flicker' ),
				'desc'    => esc_html__( 'Wide or Boxed layout', 'flicker' ),
				'picker'  => array(
					'boxed' => array(
						'type'         => 'switch',
						'value'        => '',
						'label'        => false,
						'desc'         => false,
						'left-choice'  => array(
							'value' => '',
							'label' => esc_html__( 'Wide', 'flicker' ),
						),
						'right-choice' => array(
							'value' => 'boxed_options',
							'label' => esc_html__( 'Boxed', 'flicker' ),
						),
					),
				),
				'choices' => array(
					'boxed_options' => array(
						'body_background_image' => array(
							'type'        => 'upload',
							'value'       => '',
							'label'       => esc_html__( 'Body background image', 'flicker' ),
							'help'        => esc_html__( 'Choose body background image if needed.', 'flicker' ),
							'images_only' => true,
						),
						'body_cover'            => array(
							'type'         => 'switch',
							'value'        => '',
							'label'        => esc_html__( 'Parallax background', 'flicker' ),
							'desc'         => esc_html__( 'Enable full width background for body', 'flicker' ),
							'left-choice'  => array(
								'value' => '',
								'label' => esc_html__( 'No', 'flicker' ),
							),
							'right-choice' => array(
								'value' => 'yes',
								'label' => esc_html__( 'Yes', 'flicker' ),
							),
						),
					),
				),

			),
		),
	),
	'version'         => array(
		'title'   => esc_html__( 'Theme Variant', 'flicker' ),
		'options' => array(
			'version' => array(
				'type'    => 'radio',
				'value'   => 'dark',
				'attr'    => array( 'class' => 'theme-layout-class', 'data-theme-layout' => 'layout' ),
				'label'   => esc_html__( 'Theme Version', 'flicker' ),
				'desc'    => esc_html__( 'Light or dark version', 'flicker' ),
				'help'    => esc_html__( 'Select one of predefined versions', 'flicker' ),
				'choices' => array( // Note: Avoid bool or int keys http://bit.ly/1cQgVzk
					'light' => esc_html__( 'Light', 'flicker' ),
					'dark'  => esc_html__( 'Dark', 'flicker' ),
				),
				// Display choices inline instead of list
				'inline'  => true,
			),
		),
	),
	'color_scheme_number'     => array(
		'title'   => esc_html__( 'Theme Color Scheme', 'flicker' ),
		'options' => array(
			'color_scheme_number' => array(
				'type'    => 'image-picker',
				'value'   => '',
				'label'   => esc_html__( 'Color scheme', 'flicker' ),
				'desc'    => esc_html__( 'Select one of predefined theme main colors', 'flicker' ),
				'choices' => array(
					'' => FLICKER_THEME_URI . '/img/theme-options/color_scheme1.png',
					'2' => FLICKER_THEME_URI . '/img/theme-options/color_scheme2.png',
					'3' => FLICKER_THEME_URI . '/img/theme-options/color_scheme3.png',
				),
				'blank'   => false, // (optional) if true, image can be deselected
			),

		),
	),
	'blog_posts' => array(
		'title'   => esc_html__( 'Theme Blog', 'flicker' ),
		'options' => array(
			'blog_slider_switch' => array(
				'type'    => 'multi-picker',
				'label'   => false,
				'desc'    => false,
				'picker'  => array(
					'blog_slider_enabled' => array(
						'type'         => 'switch',
						'value'        => '',
						'label'        => esc_html__( 'Post slider', 'flicker' ),
						'desc'         => esc_html__( 'Enable slider on blog page', 'flicker' ),
						'left-choice'  => array(
							'value' => '',
							'label' => esc_html__( 'No', 'flicker' ),
						),
						'right-choice' => array(
							'value' => 'yes',
							'label' => esc_html__( 'Yes', 'flicker' ),
						),
					),
				),
				'choices' => array(
					'yes' => array(
						'slider_id' => array(
							'type'    => 'select',
							'value'   => '',
							'label'   => esc_html__( 'Select Slider', 'flicker' ),
							'choices' => $choices
						),
					),
				),
			),
		)
	),
	'topline'     => array(
		'title'   => esc_html__( 'Theme Top line', 'flicker' ),
		'options' => array(

			'tl_visible'   => array(
				'type'  => 'switch',
				'value' => true,
				'label' => esc_html__('Show Top line', 'flicker'),
				'left-choice' => array(
					'value' => false,
					'label' => esc_html__('No', 'flicker'),
				),
				'right-choice' => array(
					'value' => true,
					'label' => esc_html__('Yes', 'flicker'),
				),
			),
			'tl_left_teaser'    => array(
				'type'  => 'multi',
				'value' => array(
					'icon' => 'fa fa-clock-o',
					'text' => 'Opening Hours: Weekdays 8.00-20.00',
					'link' => ''
				),
				'label' => esc_html__('Left Teaser', 'flicker'),
				'inner-options'    => array(
					'icon'       => array(
						'type'  => 'icon',
						'label' => esc_html__( 'Icon', 'flicker' ),
						'set'   => 'rt-icons-2',
					),
					'text'  => array(
						'type'  => 'text',
					),
				)
			),
		)
	),
	'toplogo'     => array(
		'title'   => esc_html__( 'Theme Top logo', 'flicker' ),
		'options' => array(
			'toplogo_teasers' => array(
				'type'  => 'addable-box',
				'label' => esc_html__('Top logo teasers', 'flicker'),
				'desc'  => esc_html__('Chose icon and enter teaser text', 'flicker'),
				'template'    => '{{=teaser_text}}',
				'box-options' => array(
					'teaser_icon' => array(
						'type' => 'icon-v2',
						'label' => esc_html__( 'Icon', 'flicker' ),
					),
					'teaser_text' => array(
						'type' => 'text',
						'label' => esc_html__( 'Teaser text' , 'flicker' ),
					),
					'teaser_text_link' => array(
						'type' => 'text',
						'label' => esc_html__( 'Teaser link' , 'flicker' ),
					),
				),
			),
		)
	),
	'headers'     => array(
		'title'   => esc_html__( 'Theme Header', 'flicker' ),
		'options' => array(

			'header'       => array(
				'type'    => 'image-picker',
				'value'   => '1',
				'attr'    => array(
					'class'    => 'header-thumbnail',
					'data-foo' => 'header',
				),
				'label'   => esc_html__( 'Template Header', 'flicker' ),
				'desc'    => esc_html__( 'Select one of predefined theme headers', 'flicker' ),
				'help'    => esc_html__( 'You can select one of predefined theme headers', 'flicker' ),
				'choices' => array(
					'1' => FLICKER_THEME_URI . '/img/theme-options/header1.png',
					'2' => FLICKER_THEME_URI . '/img/theme-options/header2.png',
					'3' => FLICKER_THEME_URI . '/img/theme-options/header3.png',
					'4' => FLICKER_THEME_URI . '/img/theme-options/header4.png',
					'10' => FLICKER_THEME_URI . '/img/theme-options/header10.png',
					'21' => FLICKER_THEME_URI . '/img/theme-options/header21.png',
					'22' => FLICKER_THEME_URI . '/img/theme-options/header22.png',
					'23' => FLICKER_THEME_URI . '/img/theme-options/header23.png',
					'24' => FLICKER_THEME_URI . '/img/theme-options/header24.png',
				),
				'blank'   => false, // (optional) if true, image can be deselected
			),
			'header_phone' => array(
				'type'  => 'text',
				'value' => esc_html__( '1(800)555-12-34', 'flicker' ),
				'label' => esc_html__( 'Phone number', 'flicker' ),
				'desc'  => esc_html__( 'Number to appear in header', 'flicker' ),
				'help'  => esc_html__( 'Not all headers display this info', 'flicker' ),
			),
			'header_email' => array(
				'type'  => 'text',
				'value' => esc_html__( 'info@company.com', 'flicker' ),
				'label' => esc_html__( 'Email', 'flicker' ),
				'desc'  => esc_html__( 'Email to appear in header', 'flicker' ),
				'help'  => esc_html__( 'Not all headers display this info', 'flicker' ),
			),
			$header_social_icons,
			'header_button_label' => array(
				'type'  => 'text',
				'value' => esc_html__( 'Buy Tickets', 'flicker' ),
				'label' => esc_html__( 'Header Button Label', 'flicker' ),
				'help'  => esc_html__( 'Button that appear in header', 'flicker' ),
			),
			'header_button_link' => array(
				'type'  => 'text',
				'value' => esc_html__( 'index.php/contact', 'flicker' ),
				'label' => esc_html__( 'Header Button Link', 'flicker' ),
				'help'  => esc_html__( 'Button that appear in header', 'flicker' ),
			),
		),
	),
	'breadcrumbs'     => array(
		'title'   => esc_html__( 'Theme Title Section', 'flicker' ),
		'options' => array(

			'breadcrumbs' => array(
				'type'    => 'image-picker',
				'value'   => '1',
				'attr'    => array(
					'class'    => 'breadcrumbs-thumbnail',
					'data-foo' => 'breadcrumbs',
				),
				'label'   => esc_html__( 'Page title sections with optional breadcrumbs', 'flicker' ),
				'desc'    => esc_html__( 'Select one of predefined page title sections. Install Unyson Breadcrumbs extension to display breadcrumbs', 'flicker' ),
				'help'    => esc_html__( 'You can select one of predefined theme title sections', 'flicker' ),
				'choices' => array(
					'1' => FLICKER_THEME_URI . '/img/theme-options/breadcrumbs1.png',
					'2' => FLICKER_THEME_URI . '/img/theme-options/breadcrumbs2.png',
					'3' => FLICKER_THEME_URI . '/img/theme-options/breadcrumbs3.png',
					'4' => FLICKER_THEME_URI . '/img/theme-options/breadcrumbs4.png',
					'5' => FLICKER_THEME_URI . '/img/theme-options/breadcrumbs5.png',
				),
				'blank'   => false, // (optional) if true, image can be deselected
			),

		),
	),
	'footer'          => array(
		'title'   => esc_html__( 'Theme Footer', 'flicker' ),
		'options' => array(

			'footer' => array(
				'type'    => 'image-picker',
				'value'   => '1',
				'attr'    => array(
					'class'    => 'footer-thumbnail',
					'data-foo' => 'footer',
				),
				'label'   => esc_html__( 'Page footer', 'flicker' ),
				'desc'    => esc_html__( 'Select one of predefined page footers.', 'flicker' ),
				'help'    => esc_html__( 'You can select one of predefined theme footers', 'flicker' ),
				'choices' => array(
					'1' => FLICKER_THEME_URI . '/img/theme-options/footer1.png',
					'2' => FLICKER_THEME_URI . '/img/theme-options/footer2.png',
				),
				'blank'   => false, // (optional) if true, image can be deselected
			),

		),
	),
	'copyrights'      => array(
		'title'   => esc_html__( 'Theme Copyrights', 'flicker' ),
		'options' => array(

			'copyrights'      => array(
				'type'    => 'image-picker',
				'value'   => '1',
				'attr'    => array(
					'class'    => 'copyrights-thumbnail',
					'data-foo' => 'copyrights',
				),
				'label'   => esc_html__( 'Page copyrights', 'flicker' ),
				'desc'    => esc_html__( 'Select one of predefined page copyrights.', 'flicker' ),
				'help'    => esc_html__( 'You can select one of predefined theme copyrights', 'flicker' ),
				'choices' => array(
					'1' => FLICKER_THEME_URI . '/img/theme-options/copyrights1.png',
					'2' => FLICKER_THEME_URI . '/img/theme-options/copyrights2.png',
				),
				'blank'   => false, // (optional) if true, image can be deselected
			),
			'copyrights_text' => array(
				'type'  => 'textarea',
				'value' => '&copy; Copyright 2017 All Rights Reserved',
				'label' => esc_html__( 'Copyrights text', 'flicker' ),
				'desc'  => esc_html__( 'Please type your copyrights text', 'flicker' ),
			),
			'copyrights_social_icons' => array(
				'type'            => 'addable-box',
				'value'           => '',
				'label'           => esc_html__( 'Social Buttons', 'flicker' ),
				'desc'            => esc_html__( 'Optional social buttons', 'flicker' ),
				'template'        => '{{=icon}}',
				'box-options'     => array(
					'icon'       => array(
						'type'  => 'icon',
						'label' => esc_html__( 'Social Icon', 'flicker' ),
						'set'   => 'social-icons',
					),
					'icon_class' => array(
						'type'        => 'select',
						'value'       => '',
						'label'       => esc_html__( 'Icon type', 'flicker' ),
						'desc'        => esc_html__( 'Select one of predefined social button types', 'flicker' ),
						'choices'     => array(
							''                                    => esc_html__( 'Default', 'flicker' ),
							'border-icon'                         => esc_html__( 'Simple Bordered Icon', 'flicker' ),
							'border-icon round-icon'            => esc_html__( 'Rounded Bordered Icon', 'flicker' ),
							'bg-icon'                             => esc_html__( 'Simple Background Icon', 'flicker' ),
							'bg-icon round-icon'                => esc_html__( 'Rounded Background Icon', 'flicker' ),
							'color-icon bg-icon'                  => esc_html__( 'Color Light Background Icon', 'flicker' ),
							'color-icon bg-icon round-icon'     => esc_html__( 'Color Light Background Rounded Icon', 'flicker' ),
							'color-icon'                          => esc_html__( 'Color Icon', 'flicker' ),
							'color-icon border-icon'              => esc_html__( 'Color Bordered Icon', 'flicker' ),
							'color-icon border-icon round-icon' => esc_html__( 'Rounded Color Bordered Icon', 'flicker' ),
							'color-bg-icon'                       => esc_html__( 'Color Background Icon', 'flicker' ),
							'color-bg-icon round-icon'          => esc_html__( 'Rounded Color Background Icon', 'flicker' ),

						),
						/**
						 * Allow save not existing choices
						 * Useful when you use the select to populate it dynamically from js
						 */
						'no-validate' => false,
					),
					'icon_url'   => array(
						'type'  => 'text',
						'value' => '',
						'label' => esc_html__( 'Icon Link', 'flicker' ),
						'desc'  => esc_html__( 'Provide a URL to your icon', 'flicker' ),
					)
				),
				'limit'           => 0, // limit the number of boxes that can be added
				'add-button-text' => esc_html__( 'Add', 'flicker' ),
				'sortable'        => true,
			),

		),
	),
	'fonts_panel'     => array(
		'title'   => esc_html__( 'Theme Fonts', 'flicker' ),
		'options' => array(
			'body_fonts_section' => array(
				'title'   => esc_html__( 'Font for body', 'flicker' ),
				'options' => array(
					'body_font_picker_switch' => array(
						'type'    => 'multi-picker',
						'label'   => false,
						'desc'    => false,
						'picker'  => array(
							'main_font_enabled' => array(
								'type'         => 'switch',
								'value'        => '',
								'label'        => esc_html__( 'Enable', 'flicker' ),
								'desc'         => esc_html__( 'Enable custom body font', 'flicker' ),
								'left-choice'  => array(
									'value' => '',
									'label' => esc_html__( 'Disabled', 'flicker' ),
								),
								'right-choice' => array(
									'value' => 'main_font_options',
									'label' => esc_html__( 'Enabled', 'flicker' ),
								),
							),
						),
						'choices' => array(
							'main_font_options' => array(
								'main_font' => array(
									'type'       => 'typography-v2',
									'value'      => array(
										'family'         => 'Roboto',
										// For standard fonts, instead of subset and variation you should set 'style' and 'weight'.
										// 'style' => 'italic',
										// 'weight' => 700,
										'subset'         => 'latin-ext',
										'variation'      => 'regular',
										'size'           => 14,
										'line-height'    => 24,
										'letter-spacing' => 0,
										'color'          => '#0000ff'
									),
									'components' => array(
										'family'         => true,
										// 'style', 'weight', 'subset', 'variation' will appear and disappear along with 'family'
										'size'           => true,
										'line-height'    => true,
										'letter-spacing' => true,
										'color'          => false
									),
									'attr'       => array( 'class' => 'custom-class', 'data-foo' => 'bar' ),
									'label'      => esc_html__( 'Custom font', 'flicker' ),
									'desc'       => esc_html__( 'Select custom font for headings', 'flicker' ),
									'help'       => esc_html__( 'You should enable using custom heading fonts above at first', 'flicker' ),
								),
							),
						),
					),
				),
			),

			'headings_fonts_section' => array(
				'title'   => esc_html__( 'Font for headings', 'flicker' ),
				'options' => array(
					'h_font_picker_switch' => array(
						'type'    => 'multi-picker',
						'label'   => false,
						'desc'    => false,
						'picker'  => array(
							'h_font_enabled' => array(
								'type'         => 'switch',
								'value'        => '',
								'label'        => esc_html__( 'Enable', 'flicker' ),
								'desc'         => esc_html__( 'Enable custom heading font', 'flicker' ),
								'left-choice'  => array(
									'value' => '',
									'label' => esc_html__( 'Disabled', 'flicker' ),
								),
								'right-choice' => array(
									'value' => 'h_font_options',
									'label' => esc_html__( 'Enabled', 'flicker' ),
								),
							),
						),
						'choices' => array(
							'h_font_options' => array(
								'h_font' => array(
									'type'       => 'typography-v2',
									'value'      => array(
										'family'         => 'Roboto',
										// For standard fonts, instead of subset and variation you should set 'style' and 'weight'.
										// 'style' => 'italic',
										// 'weight' => 700,
										'subset'         => 'latin-ext',
										'variation'      => 'regular',
										'size'           => 28,
										'line-height'    => '100%',
										'letter-spacing' => 0,
										'color'          => '#0000ff'
									),
									'components' => array(
										'family'         => true,
										// 'style', 'weight', 'subset', 'variation' will appear and disappear along with 'family'
										'size'           => false,
										'line-height'    => false,
										'letter-spacing' => true,
										'color'          => false
									),
									'attr'       => array( 'class' => 'custom-class', 'data-foo' => 'bar' ),
									'label'      => esc_html__( 'Custom font', 'flicker' ),
									'desc'       => esc_html__( 'Select custom font for headings', 'flicker' ),
									'help'       => esc_html__( 'You should enable using custom heading fonts above at first', 'flicker' ),
								),
							),
						),
					),
				),
			),

		),
	),
	'preloader_panel' => array(
		'title' => esc_html__( 'Theme Preloader', 'flicker' ),

		'options' => array(
			'preloader_enabled' => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__( 'Enable Preloader', 'flicker' ),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__( 'Enabled', 'flicker' ),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__( 'Disabled', 'flicker' ),
				),
			),

			'preloader_image' => array(
				'type'        => 'upload',
				'value'       => '',
				'label'       => esc_html__( 'Custom preloader image', 'flicker' ),
				'help'        => esc_html__( 'GIF image recommended. Recommended maximum preloader width 150px, maximum preloader height 150px.', 'flicker' ),
				'images_only' => true,
			),


		),
	),
	'share_buttons'   => array(
		'title' => esc_html__( 'Theme Share Buttons', 'flicker' ),

		'options' => array(
			'share_facebook'    => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__( 'Enable Facebook Share Button', 'flicker' ),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__( 'Enabled', 'flicker' ),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__( 'Disabled', 'flicker' ),
				),
			),
			'share_twitter'     => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__( 'Enable Twitter Share Button', 'flicker' ),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__( 'Enabled', 'flicker' ),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__( 'Disabled', 'flicker' ),
				),
			),
			'share_google_plus' => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__( 'Enable Google+ Share Button', 'flicker' ),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__( 'Enabled', 'flicker' ),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__( 'Disabled', 'flicker' ),
				),
			),
			'share_pinterest'   => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__( 'Enable Pinterest Share Button', 'flicker' ),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__( 'Enabled', 'flicker' ),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__( 'Disabled', 'flicker' ),
				),
			),
			'share_linkedin'    => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__( 'Enable LinkedIn Share Button', 'flicker' ),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__( 'Enabled', 'flicker' ),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__( 'Disabled', 'flicker' ),
				),
			),
			'share_tumblr'      => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__( 'Enable Tumblr Share Button', 'flicker' ),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__( 'Enabled', 'flicker' ),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__( 'Disabled', 'flicker' ),
				),
			),
			'share_reddit'      => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__( 'Enable Reddit Share Button', 'flicker' ),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__( 'Enabled', 'flicker' ),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__( 'Disabled', 'flicker' ),
				),
			),

		),
	),

);