<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * The template for displaying single service
 *
 */

get_header();
$pID = get_the_ID();

//no columns on single service page
$column_classes = fw_ext_extension_get_columns_classes( true );

//getting taxonomy name
$ext_team_settings = fw()->extensions->get( 'team' )->get_settings();
$taxonomy_name = $ext_team_settings['taxonomy_name'];

$atts = fw_get_db_post_option(get_the_ID());

$shortcodes_extension = fw()->extensions->get( 'shortcodes' );

$unique_id = uniqid();
?>
	<div id="content" class="<?php echo esc_attr( $column_classes['main_column_class'] ); ?>">
		<?php
		// Start the Loop.
		while ( have_posts() ) : the_post(); ?>
			<article id="post-<?php the_ID(); ?>" <?php post_class('row columns_padding_25'); ?>>
				<div class="col-md-5">
					<div class="vertical-item content-padding with_background rounded overflow_hidden text-center">
						<div class="item-media">
							<?php the_post_thumbnail( 'flicker-square-width' ); ?>
						</div>
						<div class="item-content">
							<?php the_title( '<h4 class="bottommargin_0">', '</h4>' ); ?>
							<?php if ( ! empty( $atts['position'] ) ) : ?>
								<p class="small-text highlight"><strong><?php echo wp_kses_post( $atts['position'] ); ?></strong></p>
							<?php endif; //position ?>

							<?php if ( ! empty( $atts['social_icons'] ) ) : ?>
								<div>
									<?php
									if ( ! empty( $shortcodes_extension ) ) {
										echo fw_ext( 'shortcodes' )->get_shortcode( 'icons_social' )->render( array( 'social_icons' => $atts['social_icons'], 'container_type' => 'divided-content' ) );
									}
									?>
								</div><!-- eof social icons -->
							<?php endif; //social icons ?>
						</div>
					</div>
				</div>
				<!-- .col-md-5 -->
				<div class="col-md-7">

					<?php the_content(); ?>

					<?php
						//member meta tabs start
						if (
							! empty( $atts['bio'] )
							||
							! empty( $atts['skills'] )
							||
							! empty( json_decode($atts['form']['json'])[1] )
						) :
						$tab_num = 0;
					?>
						<div class="bootstrap-tabs divider_40">
							<ul class="nav nav-tabs" role="tablist">
								<?php
									if ( ! empty( $atts['bio'] ) ) :
								?>
									<li class="<?php echo ( 0 === $tab_num ) ? 'active' : '' ?>">
										<a href="#tab-<?php echo esc_attr( $unique_id . '-' . $tab_num ); ?>" role="tab" data-toggle="tab">
											<?php esc_html_e( 'Bio', 'flicker' ); ?>
										</a>
									</li>
								<?php
									$tab_num++;
									endif; //bio check

									if ( ! empty( $atts['skills'] ) ) :
								?>
									<li class="<?php echo ( 0 === $tab_num ) ? 'active' : '' ?>">
										<a href="#tab-<?php echo esc_attr( $unique_id . '-' . $tab_num ); ?>" role="tab" data-toggle="tab">
											<?php esc_html_e( 'Skills', 'flicker' ); ?>
										</a>
									</li>
								<?php
									$tab_num++;
									endif; //bio check

									if ( ! empty( json_decode($atts['form']['json'])[1] ) ) :
								?>
									<li class="<?php echo ( 0 === $tab_num ) ? 'active' : '' ?>">
										<a href="#tab-<?php echo esc_attr( $unique_id . '-' . $tab_num ); ?>" role="tab" data-toggle="tab">
											<?php esc_html_e( 'Send Message', 'flicker' ); ?>
										</a>
									</li>
								<?php
									$tab_num++;
									endif; //form check
								?>
							</ul>
							<div class="tab-content top-color-border">
								<?php
									$tab_num = 0;
									if ( ! empty( $atts['bio'] ) ) :
								?>
								<div class="tab-pane tab-member-bio fade <?php echo ( 0 === $tab_num ) ? 'in active' : '' ?>"
									id="tab-<?php echo esc_attr( $unique_id ) . '-' . $tab_num ?>">
									<?php echo wp_kses_post( $atts['bio'] ); ?>
								</div><!-- .eof tab-pane -->
								<?php
									$tab_num++;
									endif; //bio check

									if ( ! empty( $atts['skills'] ) ) :
								?>
								<div class="tab-pane tab-member-skills fade <?php echo ( 0 === $tab_num ) ? 'in active' : '' ?>"
									 id="tab-<?php echo esc_attr( $unique_id ) . '-' . $tab_num ?>">
									<?php
										foreach($atts['skills'] as $skill) :
											echo fw_ext( 'shortcodes' )->get_shortcode( 'progress_bar' )->render( $skill );
										endforeach;
									?>
								</div><!-- .eof tab-pane -->
								<?php
									$tab_num++;
									endif; //skills check

									if ( ! empty( json_decode($atts['form']['json'])[1] ) ) :
								?>
								<div class="tab-pane tab-member-form fade <?php echo ( 0 === $tab_num ) ? 'in active' : '' ?>"
									 id="tab-<?php echo esc_attr( $unique_id ) . '-' . $tab_num ?>">
									<?php echo fw_ext( 'shortcodes' )->get_shortcode( 'contact_form' )->render( $atts ); ?>
								</div><!-- .eof tab-pane -->
								<?php
									$tab_num++;
									endif; //form check
								?>
							</div>
						</div>
					<?php endif; //tab content check ?>

					<?php if ( ! empty( $atts['additional_content'] ) ) : ?>
						<div class="member-additional-content topmargin_30">
							<?php echo wp_kses_post( $atts['additional_content'] ); ?>
						</div>
					<?php endif; //additional content ?>

				</div>
			</article><!-- #post-## -->
		<?php endwhile; ?>
	</div><!--eof #content -->
<?php if ( $column_classes['sidebar_class'] ): ?>
	<!-- main aside sidebar -->
	<aside class="<?php echo esc_attr( $column_classes['sidebar_class'] ); ?>">
		<?php get_sidebar(); ?>
	</aside>
	<!-- eof main aside sidebar -->
	<?php
endif;
get_footer();