<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'testimonials_layout' => array(
		'type'    => 'multi-picker',
		'value'   => array(
			'layout'  => 'owlcarousel',
		),
		'label'   => false,
		'desc'    => false,
		'picker'  => array(
			'layout' => array(
				'type'    => 'select',
				'value'   => 'owlcarousel',
				'label'   => esc_html__( 'Testimonials Layout', 'flicker' ),
				'desc'    => esc_html__( 'Select one of predefined testimonials layout', 'flicker' ),
				'choices' => array(
					'owlcarousel'  => esc_html__( 'Owl Carousel', 'flicker' ),
					'flexslider' => esc_html__( 'Big FlexSlider Carousel', 'flicker' ),
				),
			),
		),
		'choices'  => array(
			'owlcarousel'  => array(
				'responsive_lg' => array(
					'type'        => 'select',
					'value'       => '3',
					'label'       => esc_html__( 'Items count on <1200px', 'flicker' ),
					'choices'     => array(
						'4' => '4',
						'3' => '3',
						'2' => '2',
						'1' => '1',
					),
					'no-validate' => false,
				),
				'responsive_md' => array(
					'type'        => 'select',
					'value'       => '2',
					'label'       => esc_html__( 'Items count on 992px-1200px', 'flicker' ),
					'choices'     => array(
						'4' => '4',
						'3' => '3',
						'2' => '2',
						'1' => '1',
					),
					'no-validate' => false,
				),
				'responsive_sm' => array(
					'type'        => 'select',
					'value'       => '2',
					'label'       => esc_html__( 'Items count on 768px-992px', 'flicker' ),
					'choices'     => array(
						'3' => '3',
						'2' => '2',
						'1' => '1',

					),
					'no-validate' => false,
				),
				'responsive_xs' => array(
					'type'        => 'select',
					'value'       => '1',
					'label'       => esc_html__( 'Items count on >768px', 'flicker' ),
					'choices'     => array(
						'2' => '2',
						'1' => '1',
					),
					'no-validate' => false,
				),
			),
			'flexslider' =>  array(),
		)
	),
	'testimonials'        => array(
		'label'         => esc_html__( 'Testimonials', 'flicker' ),
		'popup-title'   => esc_html__( 'Add/Edit Testimonial', 'flicker' ),
		'desc'          => esc_html__( 'Here you can add, remove and edit your Testimonials.', 'flicker' ),
		'type'          => 'addable-popup',
		'template'      => '{{=author_first_name}}',
		'popup-options' => array(
			'content'       => array(
				'label' => esc_html__( 'Quote', 'flicker' ),
				'desc'  => esc_html__( 'Enter the testimonial here', 'flicker' ),
				'type'  => 'textarea',
			),
			'author_avatar' => array(
				'label' => esc_html__( 'Image', 'flicker' ),
				'desc'  => esc_html__( 'Either upload a new, or choose an existing image from your media library', 'flicker' ),
				'type'  => 'upload',
			),
			'author_first_name'   => array(
				'label' => esc_html__( 'First Name', 'flicker' ),
				'desc'  => esc_html__( 'Enter the Name of the Person to quote', 'flicker' ),
				'type'  => 'text'
			),
			'author_last_name'   => array(
				'label' => esc_html__( 'Last Name', 'flicker' ),
				'desc'  => esc_html__( 'Enter the Name of the Person to quote', 'flicker' ),
				'type'  => 'text'
			),
			'author_job'    => array(
				'label' => esc_html__( 'Position', 'flicker' ),
				'desc'  => esc_html__( 'Can be used for a job description', 'flicker' ),
				'type'  => 'text'
			),
			'site_name'     => array(
				'label' => esc_html__( 'Website Name', 'flicker' ),
				'desc'  => esc_html__( 'Linktext for the above Link', 'flicker' ),
				'type'  => 'text'
			),
			'site_url'      => array(
				'label' => esc_html__( 'Website Link', 'flicker' ),
				'desc'  => esc_html__( 'Link to the Persons website', 'flicker' ),
				'type'  => 'text'
			),
			'star_rating' => array(
				'type'    => 'multi-picker',
				'value'   => '',
				'picker'  => array(
					'show_star_rating' => array(
						'type'         => 'switch',
						'label'        => esc_html__( 'Show star rating', 'flicker' ),
						'left-choice'  => array(
							'value' => '',
							'label' => esc_html__( 'No', 'flicker' ),
						),
						'right-choice' => array(
							'value' => 'stars',
							'label' => esc_html__( 'Yes', 'flicker' ),
						),
					),
				),
				'choices' => array(
					''       => array(),
					'stars' => array(
						'stars_value' => array(
							'type'    => 'select',
							'value'   => '5.0',
							'label'   => esc_html__( 'Star rating', 'flicker' ),
							'choices' => array(
								'1.0'  => esc_html__( '1.0', 'flicker' ),
								'1.5'  => esc_html__( '1.5', 'flicker' ),
								'2.0'  => esc_html__( '2.0', 'flicker' ),
								'2.5'  => esc_html__( '2.5', 'flicker' ),
								'3.0'  => esc_html__( '3.0', 'flicker' ),
								'3.5'  => esc_html__( '3.5', 'flicker' ),
								'4.0'  => esc_html__( '4.0', 'flicker' ),
								'4.5'  => esc_html__( '4.5', 'flicker' ),
								'5.0'  => esc_html__( '5.0', 'flicker' ),
							)
						)
					),
				),
			)
		)
	)
);