<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$teaser = fw_ext( 'shortcodes' )->get_shortcode( 'teaser' );

$options = array(
	'tabs'       => array(
		'type'          => 'addable-popup',
		'label'         => esc_html__( 'Tabs', 'flicker' ),
		'popup-title'   => esc_html__( 'Add/Edit Tabs', 'flicker' ),
		'desc'          => esc_html__( 'Create your tabs', 'flicker' ),
		'template'      => '{{=tab_title}}',
		'popup-options' => array(
			'tab_title'           => array(
				'type'  => 'text',
				'label' => esc_html__( 'Title', 'flicker' )
			),
			'tab_columns_width'   => array(
				'type'    => 'select',
				'label'   => esc_html__( 'Column width in tab content', 'flicker' ),
				'value'   => 'col-sm-4',
				'desc'    => esc_html__( 'Choose teaser width inside tab content', 'flicker' ),
				'choices' => array(
					'col-sm-12' => esc_html__( '1/1', 'flicker' ),
					'col-sm-6'  => esc_html__( '1/2', 'flicker' ),
					'col-sm-4'  => esc_html__( '1/3', 'flicker' ),
					'col-sm-3'  => esc_html__( '1/4', 'flicker' ),
				),
			),
			'tab_columns_padding' => array(
				'type'    => 'select',
				'value'   => 'columns_padding_15',
				'label'   => esc_html__( 'Column paddings', 'flicker' ),
				'desc'    => esc_html__( 'Choose columns horizontal paddings value', 'flicker' ),
				'choices' => array(
					'columns_padding_0'  => esc_html__( '0', 'flicker' ),
					'columns_padding_1'  => esc_html__( '1 px', 'flicker' ),
					'columns_padding_2'  => esc_html__( '2 px', 'flicker' ),
					'columns_padding_5'  => esc_html__( '5 px', 'flicker' ),
					'columns_padding_15' => esc_html__( '15 px - default', 'flicker' ),
					'columns_padding_25' => esc_html__( '25 px', 'flicker' ),
				),
			),
			'tab_teasers'         => array(
				'type'          => 'addable-popup',
				'label'         => esc_html__( 'Teasers in tabs', 'flicker' ),
				'popup-title'   => esc_html__( 'Add/Edit Teasers in tabs', 'flicker' ),
				'desc'          => esc_html__( 'Create your teasers in tabs', 'flicker' ),
				'template'      => '{{=title}}',
				'popup-options' => $teaser->get_options(),

			),
		),

	),
	'top_border' => array(
		'type'         => 'switch',
		'value'        => '',
		'label'        => esc_html__( 'Top color border', 'flicker' ),
		'desc'         => esc_html__( 'Add top color border to tab content', 'flicker' ),
		'left-choice'  => array(
			'value' => '',
			'label' => esc_html__( 'No top border', 'flicker' ),
		),
		'right-choice' => array(
			'value' => 'top-color-border',
			'label' => esc_html__( 'Color top border', 'flicker' ),
		),
	),
	'id'         => array( 'type' => 'unique' ),
);