<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$portfolio = fw()->extensions->get( 'portfolio' );
if ( empty( $portfolio ) ) {
	return;
}

$options = array(
	'layout'        => array(
		'label'   => esc_html__( 'Portfolio Layout', 'flicker' ),
		'desc'    => esc_html__( 'Choose projects layout', 'flicker' ),
		'value'   => 'isotope',
		'type'    => 'select',
		'choices' => array(
			'carousel' => esc_html__( 'Carousel', 'flicker' ),
			'isotope'  => esc_html__( 'Masonry Grid', 'flicker' ),
		)
	),
	'centered_carousel'  => array(
		'type'         => 'switch',
		'value'        => false,
		'label'        => esc_html__( 'Centered Carousel', 'flicker' ),
		'desc'         => esc_html__( 'Centered Carousel (only for carousel layout).', 'flicker' ),
	),
	'item_layout'   => array(
		'label'   => esc_html__( 'Item layout', 'flicker' ),
		'desc'    => esc_html__( 'Choose Item layout', 'flicker' ),
		'value'   => 'item-regular',
		'type'    => 'select',
		'choices' => array(
			'item-image'  => esc_html__( 'Just image', 'flicker' ),
			'item-regular'  => esc_html__( 'Image with hovering title', 'flicker' ),
			'item-title'    => esc_html__( 'Image with title', 'flicker' ),
			'item-extended' => esc_html__( 'Image with title and excerpt', 'flicker' ),
		)
	),
	'number'        => array(
		'type'       => 'slider',
		'value'      => 6,
		'properties' => array(
			'min'  => 1,
			'max'  => 12,
			'step' => 1, // Set slider step. Always > 0. Could be fractional.

		),
		'label'      => esc_html__( 'Items number', 'flicker' ),
		'desc'       => esc_html__( 'Number of portfolio projects tu display', 'flicker' ),
	),
	'margin'        => array(
		'label'   => esc_html__( 'Horizontal item margin (px)', 'flicker' ),
		'desc'    => esc_html__( 'Select horizontal item margin', 'flicker' ),
		'value'   => '30',
		'type'    => 'select',
		'choices' => array(
			'0'  => esc_html__( '0', 'flicker' ),
			'1'  => esc_html__( '1px', 'flicker' ),
			'2'  => esc_html__( '2px', 'flicker' ),
			'10' => esc_html__( '10px', 'flicker' ),
			'30' => esc_html__( '30px', 'flicker' ),
		)
	),
	'responsive_xlg' => array(
		'label'   => esc_html__( 'Columns on extra wide screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on wide screens (>=1600px). This option only for carousel view.', 'flicker' ),
		'value'   => '4',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
			'5' => esc_html__( '5', 'flicker' ),
			'6' => esc_html__( '6', 'flicker' ),
			'7' => esc_html__( '7', 'flicker' ),
			'8' => esc_html__( '8', 'flicker' ),
		)
	),
	'responsive_lg' => array(
		'label'   => esc_html__( 'Columns on wide screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on wide screens (>=1200px)', 'flicker' ),
		'value'   => '4',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
			'5' => esc_html__( '5', 'flicker' ),
			'6' => esc_html__( '6', 'flicker' ),
		)
	),
	'responsive_md' => array(
		'label'   => esc_html__( 'Columns on middle screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on middle screens (>=992px)', 'flicker' ),
		'value'   => '3',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
			'5' => esc_html__( '5', 'flicker' ),
			'6' => esc_html__( '6', 'flicker' ),
		)
	),
	'responsive_sm' => array(
		'label'   => esc_html__( 'Columns on small screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on small screens (>=768px)', 'flicker' ),
		'value'   => '2',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
			'5' => esc_html__( '5', 'flicker' ),
		)
	),
	'responsive_xs' => array(
		'label'   => esc_html__( 'Columns on extra small screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on extra small screens (>=500px). This option only for carousel view.', 'flicker' ),
		'value'   => '1',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
		)
	),
	'responsive_xxs' => array(
		'label'   => esc_html__( 'Columns on extra small screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on extra small screens (<500px)', 'flicker' ),
		'value'   => '1',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
		)
	),
	'show_filters'  => array(
		'type'         => 'switch',
		'value'        => false,
		'label'        => esc_html__( 'Show filters', 'flicker' ),
		'desc'         => esc_html__( 'Hide or show categories filters', 'flicker' ),
		'left-choice'  => array(
			'value' => false,
			'label' => esc_html__( 'No', 'flicker' ),
		),
		'right-choice' => array(
			'value' => true,
			'label' => esc_html__( 'Yes', 'flicker' ),
		),
	)
);