<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
//get social icons to add in item:
$icon = fw_ext( 'shortcodes' )->get_shortcode( 'icon' );
//get social icons to add in item:
$icons_social = fw_ext( 'shortcodes' )->get_shortcode( 'icons_social' );

$options = array(
	'title'      => array(
		'type'  => 'text',
		'label' => esc_html__( 'Title of the Box', 'flicker' ),
	),
	'title_tag'  => array(
		'type'    => 'select',
		'value'   => 'h3',
		'label'   => esc_html__( 'Title Tag', 'flicker' ),
		'choices' => array(
			'h2' => esc_html__( 'H2', 'flicker' ),
			'h3' => esc_html__( 'H3', 'flicker' ),
			'h4' => esc_html__( 'H4', 'flicker' ),
		)
	),
	'content'    => array(
		'type'          => 'wp-editor',
		'label'         => esc_html__( 'Item text', 'flicker' ),
		'desc'          => esc_html__( 'Enter desired item content', 'flicker' ),
		'size'          => 'small', // small, large
		'editor_height' => 400,
	),
	'item_style' => array(
		'type'    => 'select',
		'label'   => esc_html__( 'Item Box Style', 'flicker' ),
		'choices' => array(
			''                                => esc_html__( 'Default (no border or background)', 'flicker' ),
			'content-padding with_border'     => esc_html__( 'Bordered', 'flicker' ),
			'content-padding with_background' => esc_html__( 'Muted Background', 'flicker' ),
			'content-padding ls ms'           => esc_html__( 'Grey background', 'flicker' ),
			'content-padding ds'              => esc_html__( 'Darkgrey background', 'flicker' ),
			'content-padding ds ms'           => esc_html__( 'Dark background', 'flicker' ),
			'content-padding cs'              => esc_html__( 'Main color background', 'flicker' ),
			'full-padding with_border'        => esc_html__( 'Bordered with Padding', 'flicker' ),
			'full-padding with_background'    => esc_html__( 'Muted Background with Padding', 'flicker' ),
			'full-padding ls ms'              => esc_html__( 'Grey background with Padding', 'flicker' ),
			'full-padding ds'                 => esc_html__( 'Darkgrey background with Padding', 'flicker' ),
			'full-padding ds ms'              => esc_html__( 'Dark background with Padding', 'flicker' ),
			'full-padding cs'                 => esc_html__( 'Main color background with Padding', 'flicker' ),
		)
	),
	'link'       => array(
		'type'  => 'text',
		'value' => '',
		'label' => esc_html__( 'Item link', 'flicker' ),
		'desc'  => esc_html__( 'Link on title and optional button', 'flicker' ),
	),
	'item_image' => array(
		'type'        => 'upload',
		'value'       => '',
		'label'       => esc_html__( 'Item Image', 'flicker' ),
		'image'       => esc_html__( 'Image for your item. Not all item layouts show image', 'flicker' ),
		'help'        => 'Image for your item. Image can appear as an element, or background or even can be hidden depends from chosen item type',
		'images_only' => true,
	),
	'text_align' => array(
		'type'    => 'select',
		'label'   => esc_html__( 'Text Alignment', 'flicker' ),
		'choices' => array(
			'text-left'   => esc_html__( 'Left', 'flicker' ),
			'text-center' => esc_html__( 'Center', 'flicker' ),
			'text-right'  => esc_html__( 'Right', 'flicker' ),
		)
	),
	'icons'      => array(
		'type'            => 'addable-box',
		'value'           => '',
		'label'           => esc_html__( 'Additional info', 'flicker' ),
		'desc'            => esc_html__( 'Add icons with title and text', 'flicker' ),
		'box-options'     => $icon->get_options(),
		'add-button-text' => esc_html__( 'Add New', 'flicker' ),
		'template'        => '{{=title}}',
		'sortable'        => true,
	),
	$icons_social->get_options(),

);