<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'image'            => array(
		'type'  => 'upload',
		'label' => __( 'Choose Image', 'flicker' ),
		'desc'  => __( 'Either upload a new, or choose an existing image from your media library', 'flicker' )
	),
	'size'             => array(
		'type'    => 'group',
		'options' => array(
			'width'  => array(
				'type'  => 'text',
				'label' => __( 'Width', 'flicker' ),
				'desc'  => __( 'Set image width', 'flicker' ),
				'value' => 300
			),
			'height' => array(
				'type'  => 'text',
				'label' => __( 'Height', 'flicker' ),
				'desc'  => __( 'Set image height', 'flicker' ),
				'value' => 200
			)
		)
	),
	'image-link-group' => array(
		'type'    => 'group',
		'options' => array(
			'link'   => array(
				'type'  => 'text',
				'label' => __( 'Image Link', 'flicker' ),
				'desc'  => __( 'Where should your image link to?', 'flicker' )
			),
			'target' => array(
				'type'         => 'switch',
				'label'        => __( 'Open Link in New Window', 'flicker' ),
				'desc'         => __( 'Select here if you want to open the linked page in a new window', 'flicker' ),
				'right-choice' => array(
					'value' => '_blank',
					'label' => __( 'Yes', 'flicker' ),
				),
				'left-choice'  => array(
					'value' => '_self',
					'label' => __( 'No', 'flicker' ),
				),
			),
		)
	),
	'image-with-frame' => array(
		'type'         => 'switch',
		'label'        => __( 'Image in container with color frame', 'flicker' ),
		'desc'         => __( 'Select here if you want to put image in container with color frame', 'flicker' ),
		'right-choice' => array(
			'value' => true,
			'label' => __( 'Yes', 'flicker' ),
		),
		'left-choice'  => array(
			'value' => false,
			'label' => __( 'No', 'flicker' ),
		),
	),
);

