<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$events = fw()->extensions->get( 'events' );
if ( empty( $events ) ) {
	return;
}

$options = array(
	'layout'        => array(
		'label'   => esc_html__( 'Events Layout', 'flicker' ),
		'desc'    => esc_html__( 'Choose events layout', 'flicker' ),
		'value'   => 'isotope',
		'type'    => 'select',
		'choices' => array(
			'carousel' => esc_html__( 'Carousel', 'flicker' ),
			'isotope'  => esc_html__( 'Masonry Grid', 'flicker' ),
		)
	),
	'number'        => array(
		'type'       => 'slider',
		'value'      => 6,
		'properties' => array(
			'min'  => 1,
			'max'  => 12,
			'step' => 1, // Set slider step. Always > 0. Could be fractional.

		),
		'label'      => esc_html__( 'Items number', 'flicker' ),
		'desc'       => esc_html__( 'Number of portfolio events to display', 'flicker' ),
	),
	'margin'        => array(
		'label'   => esc_html__( 'Horizontal item margin (px)', 'flicker' ),
		'desc'    => esc_html__( 'Select horizontal item margin', 'flicker' ),
		'value'   => '30',
		'type'    => 'select',
		'choices' => array(
			'0'  => esc_html__( '0', 'flicker' ),
			'1'  => esc_html__( '1px', 'flicker' ),
			'2'  => esc_html__( '2px', 'flicker' ),
			'10' => esc_html__( '10px', 'flicker' ),
			'30' => esc_html__( '30px', 'flicker' ),
		)
	),
	'responsive_lg' => array(
		'label'   => esc_html__( 'Columns on wide screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on wide screens (>=1200px)', 'flicker' ),
		'value'   => '4',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
			'5' => esc_html__( '5', 'flicker' ),
			'6' => esc_html__( '6', 'flicker' ),
		)
	),
	'responsive_md' => array(
		'label'   => esc_html__( 'Columns on middle screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on middle screens (>=992px)', 'flicker' ),
		'value'   => '3',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
			'5' => esc_html__( '5', 'flicker' ),
			'6' => esc_html__( '6', 'flicker' ),
		)
	),
	'responsive_sm' => array(
		'label'   => esc_html__( 'Columns on small screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on small screens (>=768px)', 'flicker' ),
		'value'   => '2',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
			'5' => esc_html__( '5', 'flicker' ),
		)
	),
	'responsive_xs' => array(
		'label'   => esc_html__( 'Columns on extra small screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on extra small screens (>=500px)', 'flicker' ),
		'value'   => '1',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
		)
	),
	'responsive_xxs' => array(
		'label'   => esc_html__( 'Columns on extra small screens', 'flicker' ),
		'desc'    => esc_html__( 'Select items number on extra small screens (<500px)', 'flicker' ),
		'value'   => '1',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'flicker' ),
			'2' => esc_html__( '2', 'flicker' ),
			'3' => esc_html__( '3', 'flicker' ),
			'4' => esc_html__( '4', 'flicker' ),
		)
	),
);