<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'label'       => array(
		'label' => esc_html__( 'Button Label', 'flicker' ),
		'desc'  => esc_html__( 'This is the text that appears on your button', 'flicker' ),
		'type'  => 'text',
		'value' => 'Submit'
	),
	'link'        => array(
		'label' => esc_html__( 'Button Link', 'flicker' ),
		'desc'  => esc_html__( 'Where should your button link to', 'flicker' ),
		'type'  => 'text',
		'value' => '#'
	),
	'target'      => array(
		'type'         => 'switch',
		'label'        => esc_html__( 'Open Link in New Window', 'flicker' ),
		'desc'         => esc_html__( 'Select here if you want to open the linked page in a new window', 'flicker' ),
		'right-choice' => array(
			'value' => '_blank',
			'label' => esc_html__( 'Yes', 'flicker' ),
		),
		'left-choice'  => array(
			'value' => '_self',
			'label' => esc_html__( 'No', 'flicker' ),
		),
	),
	'color'       => array(
		'label'   => esc_html__( 'Button Color', 'flicker' ),
		'desc'    => esc_html__( 'Choose a type for your button', 'flicker' ),
		'type'    => 'select',
		'choices' => array(
			'theme_button'         => esc_html__( 'Default', 'flicker' ),
			'theme_button inverse' => esc_html__( 'Inverse', 'flicker' ),
			'theme_button color1'  => esc_html__( 'First Accent Color', 'flicker' ),
			'theme_button color2'  => esc_html__( 'Second Accent Color', 'flicker' ),
			'simple_link'          => esc_html__( 'Just link', 'flicker' ),
			'more-link'            => esc_html__( 'Read More link', 'flicker' ),
		)
	),
	'wide_button' => array(
		'type'  => 'switch',
		'label' => esc_html__( 'Wide button', 'flicker' ),
		'desc'  => esc_html__( 'Switch to create wider button', 'flicker' ),
	),
	'video_button' => array(
		'type'  => 'switch',
		'label' => esc_html__( 'Video Popup Button', 'flicker' ),
		'desc'  => esc_html__( 'Round play button that triggers popup video', 'flicker' ),
	),
);