<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(

	'slide_align'      => array(
		'type'        => 'select',
		'value'       => 'text-left',
		'label'       => esc_html__( 'Slide text alignment', 'flicker' ),
		'desc'        => esc_html__( 'Select slide text alignment', 'flicker' ),
		'choices'     => array(
			'text-left'   => esc_html__( 'Left', 'flicker' ),
			'text-center' => esc_html__( 'Center', 'flicker' ),
			'text-right'  => esc_html__( 'Right', 'flicker' ),
		),
		/**
		 * Allow save not existing choices
		 * Useful when you use the select to populate it dynamically from js
		 */
		'no-validate' => false,
	),
	'slide_layers'     => array(
		'type'        => 'addable-box',
		'value'       => '',
		'label'       => esc_html__( 'Slide Layers', 'flicker' ),
		'desc'        => esc_html__( 'Choose a tag and text inside it', 'flicker' ),
		'box-options' => array(
			'layer_tag'            => array(
				'type'    => 'select',
				'value'   => 'h3',
				'label'   => esc_html__( 'Layer tag', 'flicker' ),
				'desc'    => esc_html__( 'Select a tag for your ', 'flicker' ),
				'choices' => array(
					'h3' => esc_html__( 'H3 tag', 'flicker' ),
					'h2' => esc_html__( 'H2 tag', 'flicker' ),
					'h4' => esc_html__( 'H4 tag', 'flicker' ),
					'h5' => esc_html__( 'H5 tag', 'flicker' ),
					'p'  => esc_html__( 'P tag', 'flicker' ),

				),
			),
			'layer_animation'      => array(
				'type'    => 'select',
				'value'   => 'fadeIn',
				'label'   => esc_html__( 'Animation type', 'flicker' ),
				'desc'    => esc_html__( 'Select one of predefined animations', 'flicker' ),
				'choices' => array(
					''               => esc_html__( 'Default', 'flicker' ),
					'slideDown'      => esc_html__( 'slideDown', 'flicker' ),
					'scaleAppear'    => esc_html__( 'scaleAppear', 'flicker' ),
					'fadeInLeft'     => esc_html__( 'fadeInLeft', 'flicker' ),
					'fadeInUp'       => esc_html__( 'fadeInUp', 'flicker' ),
					'fadeInRight'    => esc_html__( 'fadeInRight', 'flicker' ),
					'fadeInDown'     => esc_html__( 'fadeInDown', 'flicker' ),
					'fadeIn'         => esc_html__( 'fadeIn', 'flicker' ),
					'slideRight'     => esc_html__( 'slideRight', 'flicker' ),
					'slideUp'        => esc_html__( 'slideUp', 'flicker' ),
					'slideLeft'      => esc_html__( 'slideLeft', 'flicker' ),
					'expandUp'       => esc_html__( 'expandUp', 'flicker' ),
					'slideExpandUp'  => esc_html__( 'slideExpandUp', 'flicker' ),
					'expandOpen'     => esc_html__( 'expandOpen', 'flicker' ),
					'bigEntrance'    => esc_html__( 'bigEntrance', 'flicker' ),
					'hatch'          => esc_html__( 'hatch', 'flicker' ),
					'tossing'        => esc_html__( 'tossing', 'flicker' ),
					'pulse'          => esc_html__( 'pulse', 'flicker' ),
					'floating'       => esc_html__( 'floating', 'flicker' ),
					'bounce'         => esc_html__( 'bounce', 'flicker' ),
					'pullUp'         => esc_html__( 'pullUp', 'flicker' ),
					'pullDown'       => esc_html__( 'pullDown', 'flicker' ),
					'stretchLeft'    => esc_html__( 'stretchLeft', 'flicker' ),
					'stretchRight'   => esc_html__( 'stretchRight', 'flicker' ),
					'fadeInUpBig'    => esc_html__( 'fadeInUpBig', 'flicker' ),
					'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'flicker' ),
					'fadeInLeftBig'  => esc_html__( 'fadeInLeftBig', 'flicker' ),
					'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'flicker' ),
					'slideInDown'    => esc_html__( 'slideInDown', 'flicker' ),
					'slideInLeft'    => esc_html__( 'slideInLeft', 'flicker' ),
					'slideInRight'   => esc_html__( 'slideInRight', 'flicker' ),
					'moveFromLeft'   => esc_html__( 'moveFromLeft', 'flicker' ),
					'moveFromRight'  => esc_html__( 'moveFromRight', 'flicker' ),
					'moveFromBottom' => esc_html__( 'moveFromBottom', 'flicker' ),
				),
			),
			'layer_text'           => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Layer text', 'flicker' ),
				'desc'  => esc_html__( 'Text to appear in slide layer', 'flicker' ),
			),
			'layer_text_color'     => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Layer text color', 'flicker' ),
				'desc'    => esc_html__( 'Select a color for your text in layer', 'flicker' ),
				'choices' => array(
					''           => esc_html__( 'Inherited', 'flicker' ),
					'highlight'  => esc_html__( 'First theme main color', 'flicker' ),
					'highlight2' => esc_html__( 'Second theme main color', 'flicker' ),
					'grey'       => esc_html__( 'Dark grey theme color', 'flicker' ),
					'black'      => esc_html__( 'Dark theme color', 'flicker' ),

				),
			),
			'layer_text_weight'    => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Layer text weight', 'flicker' ),
				'desc'    => esc_html__( 'Select a weight for your text in layer', 'flicker' ),
				'choices' => array(
					''     => esc_html__( 'Normal', 'flicker' ),
					'bold' => esc_html__( 'Bold', 'flicker' ),
					'thin' => esc_html__( 'Thin', 'flicker' ),

				),
			),
			'layer_text_transform' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Layer text transform', 'flicker' ),
				'desc'    => esc_html__( 'Select a text transformation for your layer', 'flicker' ),
				'choices' => array(
					''                => esc_html__( 'None', 'flicker' ),
					'text-lowercase'  => esc_html__( 'Lowercase', 'flicker' ),
					'text-uppercase'  => esc_html__( 'Uppercase', 'flicker' ),
					'text-capitalize' => esc_html__( 'Capitalize', 'flicker' ),

				),
			),
		),
		'template'    => esc_html__( 'Slider Layer', 'flicker' ),

		'limit'           => 5, // limit the number of boxes that can be added
		'add-button-text' => esc_html__( 'Add', 'flicker' ),
	),

	'slide_buttons'     => array(
		'type'        => 'addable-box',
		'value'       => '',
		'label'       => esc_html__( 'Slide Buttons', 'flicker' ),
		'desc'        => esc_html__( 'Choose a button, link for it and text inside it', 'flicker' ),
		'box-options' => array(
			'button_type'     => array(
				'type'        => 'select',
				'value'       => '',
				'label'       => esc_html__( 'Slide button', 'flicker' ),
				'desc'        => esc_html__( 'Select slide button. Leave empty if no button needed', 'flicker' ),
				'choices'     => array(
					'theme_button'         => esc_html__( 'Default', 'flicker' ),
					'theme_button inverse' => esc_html__( 'Inverse', 'flicker' ),
					'theme_button color1'  => esc_html__( 'Color', 'flicker' ),
					'simple_link'          => esc_html__( 'Just link', 'flicker' ),
				),
				/**
				 * Allow save not existing choices
				 * Useful when you use the select to populate it dynamically from js
				 */
				'no-validate' => false,
			),
			'button_text'      => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Slide button text', 'flicker' ),
				'desc'  => esc_html__( 'Text in button', 'flicker' ),
			),
			'button_link'      => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Slide button link', 'flicker' ),
				'desc'  => esc_html__( 'Paste a link', 'flicker' ),
			),
		),
		'template'    => esc_html__( 'Slider Button', 'flicker' ),
		'limit'           => 5, // limit the number of boxes that can be added
		'add-button-text' => esc_html__( 'Add', 'flicker' ),
	),
	'slide_button_animation' => array(
		'type'    => 'select',
		'value'   => 'fadeIn',
		'label'   => esc_html__( 'Buttons animation type', 'flicker' ),
		'desc'    => esc_html__( 'Select one of predefined animations', 'flicker' ),
		'choices' => array(
			''               => esc_html__( 'Default', 'flicker' ),
			'slideDown'      => esc_html__( 'slideDown', 'flicker' ),
			'scaleAppear'    => esc_html__( 'scaleAppear', 'flicker' ),
			'fadeInLeft'     => esc_html__( 'fadeInLeft', 'flicker' ),
			'fadeInUp'       => esc_html__( 'fadeInUp', 'flicker' ),
			'fadeInRight'    => esc_html__( 'fadeInRight', 'flicker' ),
			'fadeInDown'     => esc_html__( 'fadeInDown', 'flicker' ),
			'fadeIn'         => esc_html__( 'fadeIn', 'flicker' ),
			'slideRight'     => esc_html__( 'slideRight', 'flicker' ),
			'slideUp'        => esc_html__( 'slideUp', 'flicker' ),
			'slideLeft'      => esc_html__( 'slideLeft', 'flicker' ),
			'expandUp'       => esc_html__( 'expandUp', 'flicker' ),
			'slideExpandUp'  => esc_html__( 'slideExpandUp', 'flicker' ),
			'expandOpen'     => esc_html__( 'expandOpen', 'flicker' ),
			'bigEntrance'    => esc_html__( 'bigEntrance', 'flicker' ),
			'hatch'          => esc_html__( 'hatch', 'flicker' ),
			'tossing'        => esc_html__( 'tossing', 'flicker' ),
			'pulse'          => esc_html__( 'pulse', 'flicker' ),
			'floating'       => esc_html__( 'floating', 'flicker' ),
			'bounce'         => esc_html__( 'bounce', 'flicker' ),
			'pullUp'         => esc_html__( 'pullUp', 'flicker' ),
			'pullDown'       => esc_html__( 'pullDown', 'flicker' ),
			'stretchLeft'    => esc_html__( 'stretchLeft', 'flicker' ),
			'stretchRight'   => esc_html__( 'stretchRight', 'flicker' ),
			'fadeInUpBig'    => esc_html__( 'fadeInUpBig', 'flicker' ),
			'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'flicker' ),
			'fadeInLeftBig'  => esc_html__( 'fadeInLeftBig', 'flicker' ),
			'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'flicker' ),
			'slideInDown'    => esc_html__( 'slideInDown', 'flicker' ),
			'slideInLeft'    => esc_html__( 'slideInLeft', 'flicker' ),
			'slideInRight'   => esc_html__( 'slideInRight', 'flicker' ),
			'moveFromLeft'   => esc_html__( 'moveFromLeft', 'flicker' ),
			'moveFromRight'  => esc_html__( 'moveFromRight', 'flicker' ),
			'moveFromBottom' => esc_html__( 'moveFromBottom', 'flicker' ),
		),
	),
);